/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.sciencegoals;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.services.etc.SourceClusterDetector;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.experts.ConfigurationHelper;
import alma.obsprep.services.experts.TechnicalJustificationExpert;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.WizardSBGenerationException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.concurrent.ConcurrentHashMap;
import lombok.NonNull;

public class TJDynamicRangeCalculations {
    private final DynamicRangesExceeded dynamicRangesExceeded = new DynamicRangesExceeded(this);
    private static EnumSet<Configuration.ConfigurationExtent> bothTMArrayTypes = EnumSet.of(Configuration.ConfigurationExtent.EXTENDED, Configuration.ConfigurationExtent.COMPACT);

    boolean isHighDRWithHighFrequencyRxb(@NonNull TechnicalJustificationExpert.TechnicalJustificationCalculations technicalJustificationCalculations, TechnicalJustificationExpert.TechnicalJustificationCalculations technicalJustificationCalculations2, @NonNull ScienceGoal scienceGoal) {
        if (technicalJustificationCalculations == null) {
            throw new NullPointerException("tjData is marked non-null but is null");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("sg is marked non-null but is null");
        }
        if (!ReceiverBand.isHighFrequencyBand(scienceGoal.getReceiverBand())) {
            return false;
        }
        boolean bl = this.isHighContinuumOrLineImagingDynamicRange(technicalJustificationCalculations2, 50);
        if (bl) {
            Log.logger(TJDynamicRangeCalculations.class).fine("isHighDRWithHighFrequencyRxb: " + bl);
        }
        return bl;
    }

    boolean isHighContinuumOrLineImagingDynamicRange(@NonNull TechnicalJustificationExpert.TechnicalJustificationCalculations technicalJustificationCalculations, int n) {
        boolean bl;
        if (technicalJustificationCalculations == null) {
            throw new NullPointerException("tjData is marked non-null but is null");
        }
        double d = technicalJustificationCalculations.getPeakFluxSNR();
        double d2 = technicalJustificationCalculations.getLineFluxSNR();
        boolean bl2 = d > (double)n;
        boolean bl3 = bl = d2 > (double)n;
        if (bl) {
            this.dynamicRangesExceeded.setLineIDRExceeded(bl);
        }
        if (bl2) {
            this.dynamicRangesExceeded.setContinuumIDRExceeded(bl2);
        }
        return bl2 || bl;
    }

    boolean isHighDRWithExtendedConfigurations(@NonNull TechnicalJustificationExpert.TechnicalJustificationCalculations technicalJustificationCalculations, TechnicalJustificationExpert.TechnicalJustificationCalculations technicalJustificationCalculations2, @NonNull ScienceGoal scienceGoal) {
        if (technicalJustificationCalculations == null) {
            throw new NullPointerException("tjData is marked non-null but is null");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("clusteredSG is marked non-null but is null");
        }
        if (!ConfigurationHelper.isConfigurationsScheduled(scienceGoal, bothTMArrayTypes, 6, 7, 8, 9, 10)) {
            return false;
        }
        boolean bl = this.isHighContinuumOrLineImagingDynamicRange(technicalJustificationCalculations2, 50);
        if (bl) {
            Log.logger(TJDynamicRangeCalculations.class).fine("isHighDRWithExtendedConfigurations: " + bl);
        }
        return bl;
    }

    boolean isHighDRWithWithACAOrShortConfigurationsWithLowRxbs(@NonNull TechnicalJustificationExpert.TechnicalJustificationCalculations technicalJustificationCalculations, TechnicalJustificationExpert.TechnicalJustificationCalculations technicalJustificationCalculations2, @NonNull ScienceGoal scienceGoal) {
        boolean bl;
        if (technicalJustificationCalculations == null) {
            throw new NullPointerException("tjData is marked non-null but is null");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("clusteredSG is marked non-null but is null");
        }
        boolean bl2 = bl = scienceGoal.getPerformanceParameters().getUseACA() || scienceGoal.isStandAloneACA();
        if (scienceGoal.getReceiverBand().getNumber() <= 7 && (bl || ConfigurationHelper.isConfigurationsScheduled(scienceGoal, bothTMArrayTypes, 1, 2, 3, 4, 5))) {
            boolean bl3 = this.isHighContinuumOrLineImagingDynamicRange(technicalJustificationCalculations2, 100);
            Log.logger(TJDynamicRangeCalculations.class).fine("isHighDRWithWithACAOrShortConfigurationsWithLowRxbs: " + bl3);
            return bl3;
        }
        return false;
    }

    boolean isHighSDRWithLowRxbs(@NonNull TechnicalJustificationExpert.TechnicalJustificationCalculations technicalJustificationCalculations, @NonNull TechnicalJustificationExpert.TechnicalJustificationCalculations technicalJustificationCalculations2, @NonNull ScienceGoal scienceGoal) {
        boolean bl;
        if (technicalJustificationCalculations == null) {
            throw new NullPointerException("tjData is marked non-null but is null");
        }
        if (technicalJustificationCalculations2 == null) {
            throw new NullPointerException("clusteredTJData is marked non-null but is null");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("clusteredSG is marked non-null but is null");
        }
        if (scienceGoal.getReceiverBand().getNumber() > 6) {
            return false;
        }
        boolean bl2 = bl = technicalJustificationCalculations2.getSpectralDynamicRange() > 1000.0;
        if (bl) {
            this.dynamicRangesExceeded.setSDRExceeded(bl);
            Log.logger(TJDynamicRangeCalculations.class).fine("isHighSDRWithLowRxbs: " + bl);
        }
        return bl;
    }

    boolean isHighSDRWithB7(@NonNull TechnicalJustificationExpert.TechnicalJustificationCalculations technicalJustificationCalculations, TechnicalJustificationExpert.TechnicalJustificationCalculations technicalJustificationCalculations2, @NonNull ScienceGoal scienceGoal) {
        boolean bl;
        if (technicalJustificationCalculations == null) {
            throw new NullPointerException("tjData is marked non-null but is null");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("clusteredSG is marked non-null but is null");
        }
        if (scienceGoal.getReceiverBand().getNumber() != 7) {
            return false;
        }
        boolean bl2 = bl = technicalJustificationCalculations2.getSpectralDynamicRange() > 400.0;
        if (bl) {
            this.dynamicRangesExceeded.setSDRExceeded(bl);
            Log.logger(TJDynamicRangeCalculations.class).fine("isHighSDRWithB7: " + bl);
        }
        return bl;
    }

    boolean isHighSDRWithB8(@NonNull TechnicalJustificationExpert.TechnicalJustificationCalculations technicalJustificationCalculations, @NonNull TechnicalJustificationExpert.TechnicalJustificationCalculations technicalJustificationCalculations2, @NonNull ScienceGoal scienceGoal) {
        boolean bl;
        if (technicalJustificationCalculations == null) {
            throw new NullPointerException("tjData is marked non-null but is null");
        }
        if (technicalJustificationCalculations2 == null) {
            throw new NullPointerException("clusteredTJData is marked non-null but is null");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("clusteredSG is marked non-null but is null");
        }
        if (scienceGoal.getReceiverBand().getNumber() != 8) {
            return false;
        }
        boolean bl2 = bl = technicalJustificationCalculations2.getSpectralDynamicRange() > 250.0;
        if (bl) {
            this.dynamicRangesExceeded.setSDRExceeded(bl);
            Log.logger(TJDynamicRangeCalculations.class).fine("isHighSDRWithB8: " + bl);
        }
        return bl;
    }

    boolean isHighSDRWithB9(@NonNull TechnicalJustificationExpert.TechnicalJustificationCalculations technicalJustificationCalculations, @NonNull TechnicalJustificationExpert.TechnicalJustificationCalculations technicalJustificationCalculations2, @NonNull ScienceGoal scienceGoal) {
        boolean bl;
        if (technicalJustificationCalculations == null) {
            throw new NullPointerException("tjData is marked non-null but is null");
        }
        if (technicalJustificationCalculations2 == null) {
            throw new NullPointerException("clusteredTJData is marked non-null but is null");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("clusteredSG is marked non-null but is null");
        }
        if (scienceGoal.getReceiverBand().getNumber() != 9) {
            return false;
        }
        boolean bl2 = bl = technicalJustificationCalculations2.getSpectralDynamicRange() > 170.0;
        if (bl) {
            this.dynamicRangesExceeded.setSDRExceeded(bl);
            Log.logger(TJDynamicRangeCalculations.class).fine("isHighSDRWithB9: " + bl);
        }
        return bl;
    }

    boolean isHighSDRWithB10(@NonNull TechnicalJustificationExpert.TechnicalJustificationCalculations technicalJustificationCalculations, @NonNull TechnicalJustificationExpert.TechnicalJustificationCalculations technicalJustificationCalculations2, @NonNull ScienceGoal scienceGoal) {
        boolean bl;
        if (technicalJustificationCalculations == null) {
            throw new NullPointerException("tjData is marked non-null but is null");
        }
        if (technicalJustificationCalculations2 == null) {
            throw new NullPointerException("clusteredTJData is marked non-null but is null");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("clusteredSG is marked non-null but is null");
        }
        if (scienceGoal.getReceiverBand().getNumber() != 10) {
            return false;
        }
        boolean bl2 = bl = technicalJustificationCalculations2.getSpectralDynamicRange() > 150.0;
        if (bl) {
            this.dynamicRangesExceeded.setSDRExceeded(bl);
            Log.logger(TJDynamicRangeCalculations.class).fine("isHighSDRWithB10: " + bl);
        }
        return bl;
    }

    public DynamicRangesExceeded determineHighDynamicRangeInfringements(TechnicalJustificationExpert.TechnicalJustificationCalculations technicalJustificationCalculations, @NonNull ScienceGoal scienceGoal2) {
        Collection<ScienceGoal> collection;
        if (scienceGoal2 == null) {
            throw new NullPointerException("sg is marked non-null but is null");
        }
        this.dynamicRangesExceeded.reset();
        try {
            collection = new SourceClusterDetector(scienceGoal2).splitScienceGoalIntoSourceClusters();
        }
        catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
            throw new WizardSBGenerationException(invalidObsProgramParametersException);
        }
        ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap(20);
        collection.parallelStream().forEach(scienceGoal -> {
            TechnicalJustificationExpert.TechnicalJustificationCalculations technicalJustificationCalculations = TechnicalJustificationExpert.builder().scienceGoal((ScienceGoal)scienceGoal).build().calculateTJValuesForStandardObsmode();
            concurrentHashMap.put(scienceGoal, technicalJustificationCalculations);
        });
        for (ScienceGoal scienceGoal3 : collection) {
            TechnicalJustificationExpert.TechnicalJustificationCalculations technicalJustificationCalculations2 = (TechnicalJustificationExpert.TechnicalJustificationCalculations)concurrentHashMap.get(scienceGoal3);
            assert (technicalJustificationCalculations2 != null);
            this.isHighDRWithHighFrequencyRxb(technicalJustificationCalculations, technicalJustificationCalculations2, scienceGoal3);
            this.isHighDRWithExtendedConfigurations(technicalJustificationCalculations, technicalJustificationCalculations2, scienceGoal3);
            this.isHighDRWithWithACAOrShortConfigurationsWithLowRxbs(technicalJustificationCalculations, technicalJustificationCalculations2, scienceGoal3);
            this.isHighSDRWithLowRxbs(technicalJustificationCalculations, technicalJustificationCalculations2, scienceGoal3);
            this.isHighSDRWithB7(technicalJustificationCalculations, technicalJustificationCalculations2, scienceGoal3);
            this.isHighSDRWithB8(technicalJustificationCalculations, technicalJustificationCalculations2, scienceGoal3);
            this.isHighSDRWithB9(technicalJustificationCalculations, technicalJustificationCalculations2, scienceGoal3);
            this.isHighSDRWithB10(technicalJustificationCalculations, technicalJustificationCalculations2, scienceGoal3);
        }
        return this.dynamicRangesExceeded;
    }

    public class DynamicRangesExceeded {
        private boolean isContinuumIDRExceeded = false;
        private boolean isLineIDRExceeded = false;
        private boolean isSDRExceeded = false;

        public boolean isHighDynamicRangeDetected() {
            return this.isContinuumIDRExceeded || this.isLineIDRExceeded || this.isSDRExceeded;
        }

        public void reset() {
            this.isSDRExceeded = false;
            this.isLineIDRExceeded = false;
            this.isContinuumIDRExceeded = false;
        }

        public DynamicRangesExceeded(TJDynamicRangeCalculations tJDynamicRangeCalculations) {
        }

        public boolean isContinuumIDRExceeded() {
            return this.isContinuumIDRExceeded;
        }

        public boolean isLineIDRExceeded() {
            return this.isLineIDRExceeded;
        }

        public boolean isSDRExceeded() {
            return this.isSDRExceeded;
        }

        public void setContinuumIDRExceeded(boolean bl) {
            this.isContinuumIDRExceeded = bl;
        }

        public void setLineIDRExceeded(boolean bl) {
            this.isLineIDRExceeded = bl;
        }

        public void setSDRExceeded(boolean bl) {
            this.isSDRExceeded = bl;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof DynamicRangesExceeded)) {
                return false;
            }
            DynamicRangesExceeded dynamicRangesExceeded = (DynamicRangesExceeded)object;
            if (!dynamicRangesExceeded.canEqual(this)) {
                return false;
            }
            if (this.isContinuumIDRExceeded() != dynamicRangesExceeded.isContinuumIDRExceeded()) {
                return false;
            }
            if (this.isLineIDRExceeded() != dynamicRangesExceeded.isLineIDRExceeded()) {
                return false;
            }
            return this.isSDRExceeded() == dynamicRangesExceeded.isSDRExceeded();
        }

        protected boolean canEqual(Object object) {
            return object instanceof DynamicRangesExceeded;
        }

        public int hashCode() {
            int n = 1;
            n = n * 59 + (this.isContinuumIDRExceeded() ? 79 : 97);
            n = n * 59 + (this.isLineIDRExceeded() ? 79 : 97);
            n = n * 59 + (this.isSDRExceeded() ? 79 : 97);
            return n;
        }

        public String toString() {
            return "TJDynamicRangeCalculations.DynamicRangesExceeded(isContinuumIDRExceeded=" + this.isContinuumIDRExceeded() + ", isLineIDRExceeded=" + this.isLineIDRExceeded() + ", isSDRExceeded=" + this.isSDRExceeded() + ")";
        }
    }
}

