/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.schedblock;

import alma.obsprep.ot.editors.schedblock.PointingPatternEditor;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

class IndividualPointingsExportOptions
extends JPanel {
    private static final String ABSCOORDS_BTN_NAME = "ExportOptionsDialog.expAbsCoordsBtn";
    private static final String OFFSETCOORDS_BTN_NAME = "ExportOptionsDialog.expOffsetCoordsBtn";
    private final ButtonGroup exportGroup = new ButtonGroup();
    private final JRadioButton absoluteCoordsBtn;
    private final JRadioButton offsetCoordsBtn;
    private final AbsoluteCoordsOptions absCoordsOptions;
    private final OffsetCoordsOptions offsetCoordsOptions;

    public IndividualPointingsExportOptions() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.absoluteCoordsBtn = new JRadioButton("Export using absolute coordinates");
        this.absoluteCoordsBtn.setName(ABSCOORDS_BTN_NAME);
        this.absoluteCoordsBtn.setToolTipText("Export pointings using absolute coordinates");
        this.exportGroup.add(this.absoluteCoordsBtn);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.absoluteCoordsBtn, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.add((Component)new JLabel("         "), gridBagConstraints);
        this.absCoordsOptions = new AbsoluteCoordsOptions();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.add((Component)this.absCoordsOptions, gridBagConstraints);
        this.offsetCoordsBtn = new JRadioButton("Export using offset coordinates");
        this.offsetCoordsBtn.setName(OFFSETCOORDS_BTN_NAME);
        this.offsetCoordsBtn.setToolTipText("Export pointings using offset coordinates.");
        this.exportGroup.add(this.offsetCoordsBtn);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        this.add((Component)this.offsetCoordsBtn, gridBagConstraints);
        this.offsetCoordsOptions = new OffsetCoordsOptions();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        this.add((Component)this.offsetCoordsOptions, gridBagConstraints);
        this.offsetCoordsBtn.setSelected(true);
        this.setOffsetCoordsEnabled(true);
        this.setAbsCoordsEnabled(false);
        ActionListener actionListener = actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            if (abstractButton.getName().equals(ABSCOORDS_BTN_NAME)) {
                this.setAbsCoordsEnabled(true);
                this.setOffsetCoordsEnabled(false);
            } else if (abstractButton.getName().equals(OFFSETCOORDS_BTN_NAME)) {
                this.setAbsCoordsEnabled(false);
                this.setOffsetCoordsEnabled(true);
            }
        };
        this.absoluteCoordsBtn.addActionListener(actionListener);
        this.offsetCoordsBtn.addActionListener(actionListener);
    }

    public boolean isAbsoluteCoords() {
        return this.absoluteCoordsBtn.isSelected();
    }

    public boolean isOffsetCoords() {
        return this.offsetCoordsBtn.isSelected();
    }

    public PointingPatternEditor.AbsoluteCoordsFormat getAbsCoordsType() {
        return this.absCoordsOptions.getCoordsType();
    }

    public void setAbsCoordsEnabled(boolean bl) {
        this.absCoordsOptions.setEnabled(bl);
    }

    public PointingPatternEditor.OffsetCoordsFormat getOffsetCoordsType() {
        return this.offsetCoordsOptions.getCoordsType();
    }

    public void setOffsetCoordsEnabled(boolean bl) {
        this.offsetCoordsOptions.setEnabled(bl);
    }

    private class AbsoluteCoordsOptions
    extends JPanel {
        private final ButtonGroup coordsGroup = new ButtonGroup();
        private final JRadioButton sexagBtn;
        private final JRadioButton degreesBtn;
        private final JRadioButton radiansBtn;

        public AbsoluteCoordsOptions() {
            this.setLayout(new BoxLayout(this, 0));
            this.sexagBtn = new JRadioButton("Sexagesimal");
            this.sexagBtn.setName("ExportOptionsDialog.CoordsSexagesimal");
            this.coordsGroup.add(this.sexagBtn);
            this.degreesBtn = new JRadioButton("Degrees");
            this.degreesBtn.setName("ExportOptionsDialog.CoordsDegrees");
            this.coordsGroup.add(this.degreesBtn);
            this.radiansBtn = new JRadioButton("Radians");
            this.radiansBtn.setName("ExportOptionsDialog.CoordsRadians");
            this.coordsGroup.add(this.radiansBtn);
            this.add(this.sexagBtn);
            this.add(this.degreesBtn);
            this.add(this.radiansBtn);
            this.sexagBtn.setSelected(true);
        }

        public PointingPatternEditor.AbsoluteCoordsFormat getCoordsType() {
            if (this.sexagBtn.isSelected()) {
                return PointingPatternEditor.AbsoluteCoordsFormat.SEXAGESIMAL;
            }
            if (this.degreesBtn.isSelected()) {
                return PointingPatternEditor.AbsoluteCoordsFormat.DEGREES;
            }
            if (this.radiansBtn.isSelected()) {
                return PointingPatternEditor.AbsoluteCoordsFormat.RADIANS;
            }
            throw new IllegalArgumentException("Unhandled coordinate system selected");
        }

        @Override
        public void setEnabled(boolean bl) {
            this.sexagBtn.setEnabled(bl);
            this.degreesBtn.setEnabled(bl);
            this.radiansBtn.setEnabled(bl);
        }
    }

    private class OffsetCoordsOptions
    extends JPanel {
        private final ButtonGroup coordsGroup = new ButtonGroup();
        private final JRadioButton arcsecBtn;
        private final JRadioButton arcminBtn;
        private final JRadioButton degreesBtn;

        public OffsetCoordsOptions() {
            this.setLayout(new BoxLayout(this, 0));
            this.arcsecBtn = new JRadioButton("Arcsec");
            this.arcsecBtn.setName("ExportOptionsDialog.Arcsec");
            this.coordsGroup.add(this.arcsecBtn);
            this.arcminBtn = new JRadioButton("Arcmin");
            this.arcminBtn.setName("ExportOptionsDialog.Arcmins");
            this.coordsGroup.add(this.arcminBtn);
            this.degreesBtn = new JRadioButton("Degrees");
            this.degreesBtn.setName("ExportOptionsDialog.Degrees");
            this.coordsGroup.add(this.degreesBtn);
            this.add(this.arcsecBtn);
            this.add(this.arcminBtn);
            this.add(this.degreesBtn);
            this.arcsecBtn.setSelected(true);
        }

        public PointingPatternEditor.OffsetCoordsFormat getCoordsType() {
            if (this.arcsecBtn.isSelected()) {
                return PointingPatternEditor.OffsetCoordsFormat.ARCSECS;
            }
            if (this.arcminBtn.isSelected()) {
                return PointingPatternEditor.OffsetCoordsFormat.ARCMINS;
            }
            if (this.degreesBtn.isSelected()) {
                return PointingPatternEditor.OffsetCoordsFormat.DEGREES;
            }
            return null;
        }

        @Override
        public void setEnabled(boolean bl) {
            this.arcsecBtn.setEnabled(bl);
            this.arcminBtn.setEnabled(bl);
            this.degreesBtn.setEnabled(bl);
        }
    }
}

