/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.actions;

import alma.entity.xmlbinding.obsproject.types.ControlBlockTArrayRequestedType;
import alma.entity.xmlbinding.valuetypes.AngleT;
import alma.entity.xmlbinding.valuetypes.AngularVelocityT;
import alma.entity.xmlbinding.valuetypes.DoubleWithUnitT;
import alma.entity.xmlbinding.valuetypes.FluxT;
import alma.entity.xmlbinding.valuetypes.FrequencyT;
import alma.entity.xmlbinding.valuetypes.IntTimeSourceT;
import alma.entity.xmlbinding.valuetypes.LatitudeT;
import alma.entity.xmlbinding.valuetypes.LongitudeT;
import alma.entity.xmlbinding.valuetypes.SensitivityT;
import alma.entity.xmlbinding.valuetypes.SpeedT;
import alma.entity.xmlbinding.valuetypes.TimeT;
import alma.entity.xmlbinding.valuetypes.UserAngleT;
import alma.entity.xmlbinding.valuetypes.UserFrequencyT;
import alma.entity.xmlbinding.valuetypes.UserSensitivityT;
import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.obsprep.bo.obsproject.CalibrationSetupParameters;
import alma.obsprep.bo.obsproject.ExpectedProperties;
import alma.obsprep.bo.obsproject.ExpectedSpectralLine;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.ScienceSpectralWindow;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.obsproject.TechnicalJustification;
import alma.obsprep.bo.obsproject.data.SpectralSetupParametersData;
import alma.obsprep.bo.obsproposal.Investigator;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.bo.schedblock.AmplitudeCalParameters;
import alma.obsprep.bo.schedblock.BandpassCalParameters;
import alma.obsprep.bo.schedblock.CheckSourceCalParameters;
import alma.obsprep.bo.schedblock.DGCReferenceCalParameters;
import alma.obsprep.bo.schedblock.DGCScienceCalParameters;
import alma.obsprep.bo.schedblock.DelayCalParameters;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.FocusCalParameters;
import alma.obsprep.bo.schedblock.PhaseCalParameters;
import alma.obsprep.bo.schedblock.PointingCalParameters;
import alma.obsprep.bo.schedblock.PointingPattern;
import alma.obsprep.bo.schedblock.PolarizationCalParameters;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.SchedBlockControl;
import alma.obsprep.bo.schedblock.SchedulingConstraints;
import alma.obsprep.bo.schedblock.ScienceParameters;
import alma.obsprep.bo.schedblock.SidebandRatioCalParameters;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.guiutil.mvc.InvalidCoordException;
import alma.obsprep.guiutil.mvc.OutOfRangeException;
import alma.obsprep.ot.actions.SearchFilter;
import alma.obsprep.ot.models.sciencegoals.AngularResolutionMode;
import alma.valuetypes.KeywordValue;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.Velocity;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.math.DoubleMath;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class SearchActionFilters {
    static final List<Class<? extends Serializable>> vupClasses = List.of(AngleT.class, UserAngleT.class, FrequencyT.class, UserFrequencyT.class, TimeT.class, SensitivityT.class, UserSensitivityT.class, AngularVelocityT.class, SpeedT.class, FluxT.class, LatitudeT.class, LongitudeT.class, IntTimeSourceT.class);
    static final ImmutableMap<String, String> VELOCITY_MAP = new ImmutableMap.Builder().put((Object)"islsrk", (Object)Velocity.REFERENCESYSTEM_LSRK).put((Object)"istopo", (Object)Velocity.REFERENCESYSTEM_TOPO).put((Object)"isbar", (Object)Velocity.REFERENCESYSTEM_BAR).put((Object)"ishel", (Object)Velocity.REFERENCESYSTEM_HEL).build();
    static final ImmutableMap<String, String> DOPPLER_MAP = new ImmutableMap.Builder().put((Object)"isoptical", (Object)Velocity.DOPPLERCALCTYPE_OPTICAL).put((Object)"isrelativistic", (Object)Velocity.DOPPLERCALCTYPE_RELATIVISTIC).put((Object)"isradio", (Object)Velocity.DOPPLERCALCTYPE_RADIO).build();
    static final ImmutableMap<String, String> REFSYSTEM_MAP = new ImmutableMap.Builder().put((Object)"isicrs", (Object)SkyCoordinates.SYSTEM_ICRS).put((Object)"isj2000", (Object)SkyCoordinates.SYSTEM_J2000).put((Object)"isgalactic", (Object)SkyCoordinates.SYSTEM_GALACTIC).put((Object)"ishorizon", (Object)SkyCoordinates.SYSTEM_HORIZON).put((Object)"isecliptic", (Object)SkyCoordinates.SYSTEM_ECLIPTIC).put((Object)"isazel", (Object)SkyCoordinates.SYSTEM_AZEL).build();
    static final List<SearchFilter<? super BusinessObject>> boSearchFilters = new ArrayList<SearchFilter<? super BusinessObject>>();
    static final List<ReflectionMethodExclusions> getterMethodsToIgnore = new ArrayList<ReflectionMethodExclusions>();

    private static void createBusinessObjectSearchFilters() {
        SearchActionFilters.createSchedBlockSearchFilter();
        SearchActionFilters.createScienceGoalSearchFilter();
        SearchActionFilters.createTargetSearchFilter();
        SearchActionFilters.createObservingParametersFilter();
        SearchActionFilters.createFieldSourceSearchFilter();
        SearchActionFilters.createSpectralSpecSearchFilter();
        SearchActionFilters.createTJSearchFilter();
        SearchActionFilters.createSpectralSetupSearchFilter();
        SearchActionFilters.createTargetParametersSearchFilter();
        SearchActionFilters.createCalibrationSetupSearchFilter();
        SearchActionFilters.createControlAndPerformanceSearchFilter();
        SearchActionFilters.createProposalSearchFilter();
        SearchActionFilters.createProjectSearchFilter();
    }

    private static void createObservingParametersFilter() {
        SearchFilter searchFilter = new SearchFilter(ScienceParameters.class, Optional.of("science"));
        SearchActionFilters.addObservingParametersReflectionFilter(searchFilter);
        boSearchFilters.add(searchFilter);
        searchFilter = new SearchFilter(PointingCalParameters.class, Optional.of("pointing"));
        SearchActionFilters.addObservingParametersReflectionFilter(searchFilter);
        boSearchFilters.add(searchFilter);
        searchFilter = new SearchFilter(BandpassCalParameters.class, Optional.of("bandpass"));
        SearchActionFilters.addObservingParametersReflectionFilter(searchFilter);
        boSearchFilters.add(searchFilter);
        searchFilter = new SearchFilter(FocusCalParameters.class, Optional.of("focus"));
        SearchActionFilters.addObservingParametersReflectionFilter(searchFilter);
        boSearchFilters.add(searchFilter);
        searchFilter = new SearchFilter(DelayCalParameters.class, Optional.of("delay"));
        SearchActionFilters.addObservingParametersReflectionFilter(searchFilter);
        boSearchFilters.add(searchFilter);
        searchFilter = new SearchFilter(CheckSourceCalParameters.class, Optional.of("checksource"));
        SearchActionFilters.addObservingParametersReflectionFilter(searchFilter);
        boSearchFilters.add(searchFilter);
        searchFilter = new SearchFilter(AmplitudeCalParameters.class, Optional.of("amplitude"));
        SearchActionFilters.addObservingParametersReflectionFilter(searchFilter);
        boSearchFilters.add(searchFilter);
        searchFilter = new SearchFilter(DGCReferenceCalParameters.class, Optional.of("dgcreference"));
        SearchActionFilters.addObservingParametersReflectionFilter(searchFilter);
        boSearchFilters.add(searchFilter);
        searchFilter = new SearchFilter(DGCScienceCalParameters.class, Optional.of("dgcscience"));
        SearchActionFilters.addObservingParametersReflectionFilter(searchFilter);
        boSearchFilters.add(searchFilter);
        searchFilter = new SearchFilter(PhaseCalParameters.class, Optional.of("phase"));
        SearchActionFilters.addObservingParametersReflectionFilter(searchFilter);
        boSearchFilters.add(searchFilter);
        searchFilter = new SearchFilter(PolarizationCalParameters.class, Optional.of("polarization"));
        SearchActionFilters.addObservingParametersReflectionFilter(searchFilter);
        boSearchFilters.add(searchFilter);
        searchFilter = new SearchFilter(SidebandRatioCalParameters.class, Optional.of("sideband"));
        SearchActionFilters.addObservingParametersReflectionFilter(searchFilter);
        boSearchFilters.add(searchFilter);
    }

    private static void addObservingParametersReflectionFilter(SearchFilter<? super BusinessObject> searchFilter) {
        searchFilter.addPredicate(object -> {
            BusinessObject businessObject2 = (BusinessObject)object;
            List<BusinessObject> list = List.of(businessObject2);
            return list.stream().filter(businessObject -> SearchActionFilters.reflectionSearchOnBO(businessObject, searchFilter.searchString)).findFirst().isPresent();
        });
    }

    private static void createReflectionSearchExclusions() {
        getterMethodsToIgnore.add(new ReflectionMethodExclusions(ExpectedProperties.class, List.of("getReferenceFrequency")));
        getterMethodsToIgnore.add(new ReflectionMethodExclusions(PerformanceParameters.class, List.of("getReferenceFrequency")));
    }

    private static void createCalibrationSetupSearchFilter() {
        SearchFilter<Object> searchFilter = new SearchFilter<Object>(CalibrationSetupParameters.class, Optional.of("calibration"));
        searchFilter.addPredicate(object -> {
            CalibrationSetupParameters calibrationSetupParameters = (CalibrationSetupParameters)((Object)((Object)object));
            if (StringUtils.containsIgnoreCase((CharSequence)"issystem", (CharSequence)searchFilter.searchString) && calibrationSetupParameters.isSystemDefinedCalibration()) {
                return true;
            }
            if (StringUtils.containsIgnoreCase((CharSequence)"isuser", (CharSequence)searchFilter.searchString) && calibrationSetupParameters.isUserDefinedCalibration()) {
                return true;
            }
            return StringUtils.containsIgnoreCase((CharSequence)"isampcal", (CharSequence)searchFilter.searchString) && calibrationSetupParameters.isAmplitudeSpecificSystemDefinedCalibration();
        });
        boSearchFilters.add(searchFilter);
    }

    private static void createControlAndPerformanceSearchFilter() {
        SearchFilter<Object> searchFilter = new SearchFilter<Object>(PerformanceParameters.class, Optional.of("cp"));
        searchFilter.addPredicate(object -> {
            PerformanceParameters performanceParameters = (PerformanceParameters)object;
            if (SearchActionFilters.reflectionSearchOnBO((BusinessObject)performanceParameters, searchFilter.searchString)) {
                return true;
            }
            if (StringUtils.containsIgnoreCase((CharSequence)"issaca", (CharSequence)searchFilter.searchString) && performanceParameters.isAngularResolutionModeSACA()) {
                return true;
            }
            if (StringUtils.containsIgnoreCase((CharSequence)"isrange", (CharSequence)searchFilter.searchString) && performanceParameters.isAngularResolutionModeRange()) {
                return true;
            }
            if (StringUtils.containsIgnoreCase((CharSequence)"isany", (CharSequence)searchFilter.searchString) && performanceParameters.isAngularResolutionModeAny()) {
                return true;
            }
            if (StringUtils.containsIgnoreCase((CharSequence)"issingle", (CharSequence)searchFilter.searchString) && performanceParameters.getAngularResolutionMode().equals(AngularResolutionMode.Single)) {
                return true;
            }
            if (StringUtils.containsIgnoreCase((CharSequence)"istimeconstrained", (CharSequence)searchFilter.searchString) && performanceParameters.getIsTimeConstrained()) {
                return true;
            }
            if (StringUtils.containsIgnoreCase((CharSequence)"istimeoverride", (CharSequence)searchFilter.searchString) && performanceParameters.getNeedsMoreTime()) {
                return true;
            }
            return StringUtils.containsIgnoreCase((CharSequence)"issimultaneousarray", (CharSequence)searchFilter.searchString) && performanceParameters.getIsSimultaneous12and7();
        });
        boSearchFilters.add(searchFilter);
    }

    private static void createFieldSourceSearchFilter() {
        SearchFilter<Object> searchFilter = new SearchFilter<Object>(FieldSource.class, Optional.of("fieldsource"));
        searchFilter.addPredicate(object -> {
            FieldSource fieldSource = (FieldSource)object;
            boolean bl = fieldSource.getFieldPattern().isRectanglePattern();
            boolean bl2 = fieldSource.getFieldPattern().isPointingPattern();
            if (StringUtils.containsIgnoreCase((CharSequence)fieldSource.getSourceName(), (CharSequence)searchFilter.searchString)) {
                return true;
            }
            ArrayList arrayList = Lists.newArrayList((Object[])new BusinessObject[]{fieldSource});
            if (fieldSource.getReferenceCount() > 0) {
                arrayList.add(fieldSource.getReference(0));
            }
            if (bl) {
                arrayList.add(fieldSource.getFieldPattern());
            } else if (bl2) {
                PointingPattern pointingPattern = (PointingPattern)((Object)fieldSource.getFieldPattern());
                arrayList.addAll(Arrays.asList(pointingPattern.getPhaseCenterCoordinates()));
            }
            if (arrayList.stream().filter(businessObject -> SearchActionFilters.reflectionSearchOnBO(businessObject, searchFilter.searchString)).findFirst().isPresent()) {
                return true;
            }
            if (!fieldSource.getIsQuery()) {
                boolean bl3 = fieldSource.getNonSiderealMotion();
                if (StringUtils.containsIgnoreCase((CharSequence)"issolar", (CharSequence)searchFilter.searchString) && bl3) {
                    return true;
                }
                if (StringUtils.containsIgnoreCase((CharSequence)"isrectangle", (CharSequence)searchFilter.searchString) && bl) {
                    return true;
                }
                if (StringUtils.containsIgnoreCase((CharSequence)"ispointing", (CharSequence)searchFilter.searchString) && fieldSource.getFieldPattern().isPointingPattern()) {
                    return true;
                }
                if (!bl3) {
                    Velocity velocity = fieldSource.getSourceVelocity();
                    if (SearchActionFilters.checkMap(VELOCITY_MAP, searchFilter.searchString, velocity.getReferenceSystem())) {
                        return true;
                    }
                    if (SearchActionFilters.checkMap(DOPPLER_MAP, searchFilter.searchString, velocity.getDopplerCalcType())) {
                        return true;
                    }
                    if (SearchActionFilters.searchSkyCoordinates(searchFilter, fieldSource.getSourceCoordinates())) {
                        return true;
                    }
                }
            }
            return false;
        });
        boSearchFilters.add(searchFilter);
    }

    private static void createProposalSearchFilter() {
        SearchFilter<Object> searchFilter = new SearchFilter<Object>(ObsProposal.class, Optional.of("proposal"));
        searchFilter.addPredicate(object -> {
            ObsProposal obsProposal = (ObsProposal)object;
            List<String> list = List.of(obsProposal.getAbstract(), obsProposal.getTitle(), obsProposal.getPrincipalInvestigator().getEMail(), obsProposal.getPrincipalInvestigator().getFullName(), obsProposal.getRelatedProposals(), obsProposal.getPreviousProposals(), obsProposal.getDuplicateObservationsJustification());
            for (String string : list) {
                if (!StringUtils.containsIgnoreCase((CharSequence)string, (CharSequence)searchFilter.searchString)) continue;
                return true;
            }
            for (String string : obsProposal.getKeyword()) {
                if (!StringUtils.containsIgnoreCase((CharSequence)string, (CharSequence)searchFilter.searchString)) continue;
                return true;
            }
            List list2 = Stream.of(new Investigator[][]{obsProposal.getCoInvestigator(), obsProposal.getCoPrincipalInvestigator()}).flatMap(Stream::of).toList();
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                Investigator investigator = (Investigator)((Object)((Object)iterator.next()));
                if (StringUtils.containsIgnoreCase((CharSequence)investigator.getFullName(), (CharSequence)searchFilter.searchString)) {
                    return true;
                }
                if (!StringUtils.containsIgnoreCase((CharSequence)investigator.getEMail(), (CharSequence)searchFilter.searchString)) continue;
                return true;
            }
            return false;
        });
        boSearchFilters.add(searchFilter);
    }

    private static void createProjectSearchFilter() {
        SearchFilter<Object> searchFilter = new SearchFilter<Object>(ObsProject.class, Optional.of("project"));
        searchFilter.addPredicate(object -> {
            ObsProject obsProject = (ObsProject)object;
            List<String> list = List.of(obsProject.getPI(), obsProject.getProjectName(), obsProject.getCode(), obsProject.getStaffProjectNote(), obsProject.getTaMainComments(), obsProject.getConsensusReport(), obsProject.getTaPhase2Comments());
            for (String string : list) {
                if (!StringUtils.containsIgnoreCase((CharSequence)string, (CharSequence)searchFilter.searchString)) continue;
                return true;
            }
            return false;
        });
        boSearchFilters.add(searchFilter);
    }

    private static void createSchedBlockSearchFilter() {
        SearchFilter<Object> searchFilter = new SearchFilter<Object>(SchedBlock.class, Optional.of("sb"));
        searchFilter.addPredicate(object -> {
            String string22;
            SchedBlock schedBlock = (SchedBlock)object;
            List<SchedBlockControl> list = List.of(schedBlock, schedBlock.getSchedulingConstraints(), schedBlock.getPreconditions(), schedBlock.getSchedBlockControl());
            if (list.stream().filter(businessObject -> SearchActionFilters.reflectionSearchOnBO(businessObject, searchFilter.searchString)).findFirst().isPresent()) {
                return true;
            }
            for (String string22 : List.of(schedBlock.getNote(), schedBlock.getName(), schedBlock.getStatus(), schedBlock.getModeName(), schedBlock.getModeType())) {
                if (!StringUtils.containsIgnoreCase((CharSequence)string22, (CharSequence)searchFilter.searchString)) continue;
                return true;
            }
            Object object2 = schedBlock.getSchedBlockControl();
            if (StringUtils.containsIgnoreCase((CharSequence)Integer.toString(object2.getExecutionCount()), (CharSequence)searchFilter.searchString)) {
                return true;
            }
            string22 = schedBlock.getObsUnitControl().getArrayRequested();
            if (StringUtils.containsIgnoreCase((CharSequence)"istm", (CharSequence)searchFilter.searchString) && string22.equals(ControlBlockTArrayRequestedType.TWELVE_M.toString())) {
                return true;
            }
            if (StringUtils.containsIgnoreCase((CharSequence)"is7m", (CharSequence)searchFilter.searchString) && string22.equals(ControlBlockTArrayRequestedType.SEVEN_M.toString())) {
                return true;
            }
            if (StringUtils.containsIgnoreCase((CharSequence)"istp", (CharSequence)searchFilter.searchString) && string22.equals(ControlBlockTArrayRequestedType.TP_ARRAY.toString())) {
                return true;
            }
            if (StringUtils.containsIgnoreCase((CharSequence)"isStandardMode", (CharSequence)searchFilter.searchString) && schedBlock.getStandardMode()) {
                return true;
            }
            if (StringUtils.containsIgnoreCase((CharSequence)"isNonStandardMode", (CharSequence)searchFilter.searchString) && !schedBlock.getStandardMode()) {
                return true;
            }
            SchedulingConstraints schedulingConstraints = schedBlock.getSchedulingConstraints();
            if (StringUtils.containsIgnoreCase((CharSequence)schedulingConstraints.getRepresentativeTarget().getFieldSource().getSourceName(), (CharSequence)searchFilter.searchString)) {
                return true;
            }
            for (String string : schedulingConstraints.getNominalConfiguration()) {
                if (!StringUtils.containsIgnoreCase((CharSequence)string, (CharSequence)searchFilter.searchString)) continue;
                return true;
            }
            for (KeywordValue keywordValue : schedBlock.getExpertParameter()) {
                if (StringUtils.containsIgnoreCase((CharSequence)keywordValue.getKeyword(), (CharSequence)searchFilter.searchString)) {
                    return true;
                }
                if (!StringUtils.containsIgnoreCase((CharSequence)keywordValue.getValue(), (CharSequence)searchFilter.searchString)) continue;
                return true;
            }
            return false;
        });
        boSearchFilters.add(searchFilter);
    }

    private static boolean reflectionSearchOnBO(BusinessObject businessObject, String string) {
        Object object = businessObject.getCastorObject();
        Class<?> clazz = object.getClass();
        Set<Method> set = Arrays.stream(clazz.getMethods()).filter(method -> StringUtils.startsWith((CharSequence)method.getName(), (CharSequence)"get") && method.getParameterCount() == 0).collect(Collectors.toSet());
        set.removeAll(SearchActionFilters.removeMethodsToBeExcluded(businessObject, set));
        for (Method method2 : set) {
            if (SearchActionFilters.isNumeric(string) && vupClasses.contains(method2.getReturnType()) && SearchActionFilters.valueUnitPairFilter(method2, object, string)) {
                return true;
            }
            if (method2.getParameterCount() != 0 || !method2.getReturnType().equals(String.class)) continue;
            try {
                Object object2 = method2.invoke(object, (Object[])null);
                String string2 = (String)object2;
                if (!StringUtils.containsIgnoreCase((CharSequence)string2, (CharSequence)string)) continue;
                return true;
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
            }
        }
        return false;
    }

    private static List<Method> removeMethodsToBeExcluded(BusinessObject businessObject, Set<Method> set) {
        ArrayList<Method> arrayList = new ArrayList<Method>();
        getterMethodsToIgnore.stream().filter(reflectionMethodExclusions -> reflectionMethodExclusions.bo.equals(businessObject.getClass())).map(reflectionMethodExclusions -> reflectionMethodExclusions.getterMethodsToIgnore).forEach(list2 -> list2.stream().forEach(string -> arrayList.addAll(set.stream().filter(method -> {
            String string2 = method.getName();
            return string2.equals(string) || string2.equals("getClass");
        }).toList())));
        return arrayList;
    }

    private static boolean isNumeric(String string) {
        try {
            Double.parseDouble(string);
        }
        catch (NullPointerException | NumberFormatException runtimeException) {
            return false;
        }
        return true;
    }

    private static boolean valueUnitPairFilter(Method method, Object object, String string) {
        DoubleWithUnitT doubleWithUnitT;
        assert (method != null);
        assert (object != null);
        assert (string != null);
        if (method.getParameterCount() != 0) {
            throw new IllegalArgumentException("Illegal argument: method.getParameterCount() (" + method.getParameterCount() + ") did not pass the test: method.getParameterCount() test");
        }
        try {
            doubleWithUnitT = (DoubleWithUnitT)method.invoke(object, (Object[])null);
            if (doubleWithUnitT == null) {
                return false;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
            return false;
        }
        if (StringUtils.startsWith((CharSequence)Double.toString(doubleWithUnitT.getContent()), (CharSequence)string)) {
            return true;
        }
        try {
            double d = Double.parseDouble(string);
            if (DoubleMath.fuzzyEquals((double)d, (double)doubleWithUnitT.getContent(), (double)1.0E-5)) {
                return true;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return false;
    }

    private static void createScienceGoalSearchFilter() {
        SearchFilter<Object> searchFilter = new SearchFilter<Object>(ScienceGoal.class, Optional.of("sciencegoal"));
        searchFilter.addPredicate(object -> {
            ScienceGoal scienceGoal = (ScienceGoal)object;
            if (StringUtils.containsIgnoreCase((CharSequence)scienceGoal.getName(), (CharSequence)searchFilter.searchString)) {
                return true;
            }
            return StringUtils.containsIgnoreCase((CharSequence)scienceGoal.getNote(), (CharSequence)searchFilter.searchString);
        });
        boSearchFilters.add(searchFilter);
    }

    private static void createSpectralSetupSearchFilter() {
        SearchFilter<Object> searchFilter = new SearchFilter<Object>(SpectralSetupParameters.class, Optional.of("spectralsetup"));
        searchFilter.addPredicate(object -> {
            int n;
            SpectralSetupParameters spectralSetupParameters = (SpectralSetupParameters)((Object)((Object)object));
            for (int i = 0; i < spectralSetupParameters.getAbstractScienceSpectralWindowCount(); ++i) {
                if (!StringUtils.containsIgnoreCase((CharSequence)spectralSetupParameters.getAbstractScienceSpectralWindow(i).getTransitionName(), (CharSequence)searchFilter.searchString)) continue;
                return true;
            }
            ArrayList<SpectralSetupParameters> arrayList = new ArrayList<SpectralSetupParameters>();
            Arrays.asList(spectralSetupParameters.getScienceSpectralWindow()).stream().forEach(scienceSpectralWindow -> arrayList.add((SpectralSetupParameters)((Object)((Object)scienceSpectralWindow))));
            arrayList.add(spectralSetupParameters);
            if (arrayList.stream().filter(businessObject -> SearchActionFilters.reflectionSearchOnBO(businessObject, searchFilter.searchString)).findFirst().isPresent()) {
                return true;
            }
            ImmutableMap immutableMap = new ImmutableMap.Builder().put((Object)"isfull", (Object)SpectralSetupParametersData.POLARISATION_FULL).put((Object)"isdual", (Object)SpectralSetupParametersData.POLARISATION_DOUBLE).put((Object)"issingle", (Object)SpectralSetupParametersData.POLARISATION_SINGLE_X).build();
            if (SearchActionFilters.checkMap((ImmutableMap<String, String>)immutableMap, searchFilter.searchString, spectralSetupParameters.getPolarisation())) {
                return true;
            }
            if (StringUtils.containsIgnoreCase((CharSequence)searchFilter.searchString, (CharSequence)"isspectral") && spectralSetupParameters.isSpectralLine()) {
                return true;
            }
            if (StringUtils.containsIgnoreCase((CharSequence)searchFilter.searchString, (CharSequence)"iscontinuum") && spectralSetupParameters.isSingleContinuum()) {
                return true;
            }
            if (StringUtils.containsIgnoreCase((CharSequence)searchFilter.searchString, (CharSequence)"isspectralscan") && spectralSetupParameters.isSpectralScan()) {
                return true;
            }
            if (StringUtils.containsIgnoreCase((CharSequence)searchFilter.searchString, (CharSequence)"iswalsh") && spectralSetupParameters.isWalshSwitching()) {
                return true;
            }
            String string = searchFilter.searchString;
            if (string.matches("band=[\\d]+") && (n = Integer.valueOf(StringUtils.splitByWholeSeparator((String)string, (String)"=")[1]).intValue()) >= 1 && n <= 10 && n == spectralSetupParameters.getReceiverBand().getNumber()) {
                return true;
            }
            if (string.matches("restline=.+")) {
                String string2 = StringUtils.splitByWholeSeparator((String)string, (String)"=")[1];
                for (ScienceSpectralWindow scienceSpectralWindow2 : spectralSetupParameters.getScienceSpectralWindow()) {
                    for (ExpectedSpectralLine expectedSpectralLine : scienceSpectralWindow2.getExpectedSpectralLine()) {
                        if (!StringUtils.containsIgnoreCase((CharSequence)string2, (CharSequence)expectedSpectralLine.getTransition())) continue;
                        return true;
                    }
                }
            }
            return false;
        });
        boSearchFilters.add(searchFilter);
    }

    private static void createSpectralSpecSearchFilter() {
        SearchFilter<Object> searchFilter = new SearchFilter<Object>(SpectralSpec.class, Optional.of("instrumentsetup"));
        searchFilter.addPredicate(object -> {
            SpectralSpec spectralSpec = (SpectralSpec)object;
            return StringUtils.containsIgnoreCase((CharSequence)spectralSpec.getName(), (CharSequence)searchFilter.searchString);
        });
        boSearchFilters.add(searchFilter);
    }

    private static void createTargetParametersSearchFilter() {
        SearchFilter<Object> searchFilter = new SearchFilter<Object>(TargetParameters.class, Optional.of("fieldsetup"));
        searchFilter.addPredicate(object -> {
            Object object2;
            TargetParameters targetParameters = (TargetParameters)object;
            ArrayList arrayList = Lists.newArrayList((Object[])new BusinessObject[]{targetParameters, targetParameters.getSourceVelocity(), targetParameters.getExpectedProperties()});
            if (targetParameters.isRectanglePattern()) {
                object2 = targetParameters.getFieldRectangle()[0];
                arrayList.add(object2);
                arrayList.add(object2.getSourceCoordinates());
            } else if (targetParameters.isPointingPattern()) {
                object2 = targetParameters.getPointingPattern();
                arrayList.addAll(Arrays.asList(object2.getPhaseCenterCoordinates()));
            }
            if (arrayList.stream().filter(businessObject -> SearchActionFilters.reflectionSearchOnBO(businessObject, searchFilter.searchString)).findFirst().isPresent()) {
                return true;
            }
            if (StringUtils.containsIgnoreCase((CharSequence)targetParameters.getSourceName(), (CharSequence)searchFilter.searchString)) {
                return true;
            }
            if (StringUtils.containsIgnoreCase((CharSequence)"issolar", (CharSequence)searchFilter.searchString) && targetParameters.getNonSiderealMotion()) {
                return true;
            }
            if (StringUtils.containsIgnoreCase((CharSequence)"isrectangle", (CharSequence)searchFilter.searchString) && targetParameters.isRectanglePattern()) {
                return true;
            }
            if (StringUtils.containsIgnoreCase((CharSequence)"ispointing", (CharSequence)searchFilter.searchString) && targetParameters.isPointingPattern()) {
                return true;
            }
            if (SearchActionFilters.searchSkyCoordinates(searchFilter, targetParameters.getSourceCoordinates())) {
                return true;
            }
            object2 = targetParameters.getSourceVelocity();
            if (SearchActionFilters.checkMap(VELOCITY_MAP, searchFilter.searchString, ((Velocity)((Object)((Object)object2))).getReferenceSystem())) {
                return true;
            }
            return SearchActionFilters.checkMap(DOPPLER_MAP, searchFilter.searchString, object2.getDopplerCalcType());
        });
        boSearchFilters.add(searchFilter);
    }

    private static boolean searchSkyCoordinates(SearchFilter<? super BusinessObject> searchFilter, SkyCoordinates skyCoordinates) {
        if (StringUtils.containsIgnoreCase((CharSequence)skyCoordinates.getSystem(), (CharSequence)searchFilter.searchString)) {
            return true;
        }
        if (SearchActionFilters.checkMap(REFSYSTEM_MAP, searchFilter.searchString, skyCoordinates.getSystem())) {
            return true;
        }
        try {
            if (StringUtils.containsIgnoreCase((CharSequence)skyCoordinates.getLatitude().toDDMMSS(), (CharSequence)searchFilter.searchString)) {
                return true;
            }
            if (StringUtils.containsIgnoreCase((CharSequence)skyCoordinates.getLongitude().toHHMMSS(), (CharSequence)searchFilter.searchString)) {
                return true;
            }
        }
        catch (InvalidCoordException | OutOfRangeException exception) {
            // empty catch block
        }
        return false;
    }

    private static boolean checkMap(ImmutableMap<String, String> immutableMap, String string3, String string4) {
        return immutableMap.keySet().stream().filter(string2 -> StringUtils.containsIgnoreCase((CharSequence)string2, (CharSequence)string3)).map(string -> (String)immutableMap.get(string)).filter(string2 -> StringUtils.containsIgnoreCase((CharSequence)string2, (CharSequence)string4)).findFirst().isPresent();
    }

    private static void createTargetSearchFilter() {
        SearchFilter<Object> searchFilter = new SearchFilter<Object>(Target.class, Optional.of("target"));
        searchFilter.addPredicate(object -> StringUtils.containsIgnoreCase((CharSequence)((Target)object).getFieldSource().getSourceName(), (CharSequence)searchFilter.searchString));
        boSearchFilters.add(searchFilter);
    }

    private static void createTJSearchFilter() {
        SearchFilter<Object> searchFilter = new SearchFilter<Object>(TechnicalJustification.class, Optional.of("tj"));
        searchFilter.addPredicate(object -> StringUtils.containsIgnoreCase((CharSequence)((TechnicalJustification)((Object)((Object)object))).getJustificationText(), (CharSequence)searchFilter.searchString));
        boSearchFilters.add(searchFilter);
    }

    public static List<SearchFilter<? super BusinessObject>> getBOsearchfilters() {
        return boSearchFilters;
    }

    static {
        SearchActionFilters.createBusinessObjectSearchFilters();
        SearchActionFilters.createReflectionSearchExclusions();
    }

    static class ReflectionMethodExclusions {
        Class<? extends BusinessObject> bo;
        List<String> getterMethodsToIgnore;

        ReflectionMethodExclusions(Class<? extends BusinessObject> clazz, List<String> list) {
            this.bo = clazz;
            this.getterMethodsToIgnore = list;
        }
    }
}

