/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.obsproject;

import alma.entity.xmlbinding.obsproject.RectangleT;
import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.hla.runtime.obsprep.bo.ReferenceableProxy;
import alma.hla.runtime.obsprep.bo.ReferenceablesMap;
import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.annotations.RectanglePatternI;
import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.obsproject.RepresentativeFrequencyChangeEvent;
import alma.obsprep.bo.obsproject.RepresentativeFrequencyListener;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.obsproject.data.RectangleData;
import alma.obsprep.bo.schedblock.FieldPattern;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.guiutil.mvc.InvalidCoordException;
import alma.obsprep.guiutil.mvc.OutOfRangeException;
import alma.obsprep.ot.editors.spatialvisual.subform.MosaicParameters;
import alma.obsprep.services.experts.RectangleAreaExpert;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import alma.valuetypes.Latitude;
import alma.valuetypes.Longitude;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.UserAngle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;

public class Rectangle
extends RectangleData
implements RectanglePatternI,
RepresentativeFrequencyListener {
    private Array array = Array.ARRAY_12M;
    private Rectangle rectTP = null;
    private Rectangle rect12m = null;
    private MosaicParameters mosaicParameters = new MosaicParameters();
    private TargetParameters targetParameters;
    private RectangleAreaExpert rectangleAreaExpert = null;
    private boolean isSystemRotationApplied = false;
    private List<CartesianCoordinate> tpRectangleVertices = new ArrayList<CartesianCoordinate>();

    public Rectangle(RectangleT rectangleT) {
        super(rectangleT);
    }

    public List<CartesianCoordinate> getTpRectangleVertices() {
        return this.tpRectangleVertices;
    }

    public void clearTPVertices() {
        this.tpRectangleVertices.clear();
    }

    public void addTPVertex(Angle angle, Angle angle2) {
        this.tpRectangleVertices.add(new CartesianCoordinate(angle.deepCopy(), angle2.deepCopy()));
    }

    public List<CartesianCoordinate> getTPVertices() {
        return Collections.unmodifiableList(this.tpRectangleVertices);
    }

    public void initAsNew() {
        super.initAsNew();
        this.getLong().setUnit(Angle.UNIT_ARCSEC);
        this.getShort().setUnit(Angle.UNIT_ARCSEC);
        this.getPALong().setUnit(Angle.UNIT_DEG);
        Frequency frequency = Frequency.createFrequencyGHZ(1.0);
        this.setReferenceFrequency(frequency);
        this.setSpacingToNyquist();
        UserAngle userAngle = this.getSpacing();
        userAngle.setObservingFrequency(this.getReferenceFrequency());
        userAngle.setUserUnitList(UserAngle.units_SmallAngle);
    }

    public void wrapObjects(ReferenceablesMap referenceablesMap, List<ReferenceableProxy<? extends IBusinessObject>> list) {
        super.wrapObjects(referenceablesMap, list);
        UserAngle userAngle = this.gettrueSpacing();
        if (userAngle != null) {
            userAngle.unitMap().suspendUnitMapUpdater();
            userAngle.setObservingFrequency(this.getReferenceFrequency());
            userAngle.unitMap().resumeUnitMapUpdater();
            userAngle.setUserUnitList(UserAngle.units_SmallAngle);
        }
    }

    public void setReferenceFrequency(Frequency frequency) {
        super.setReferenceFrequency(frequency);
        this.getSpacing().setObservingFrequency(frequency);
    }

    public void setSpacing(UserAngle userAngle) {
        UserAngle userAngle2 = userAngle.deepCopy();
        userAngle2.setObservingFrequency(this.getReferenceFrequency());
        super.setSpacing(userAngle2);
    }

    public void setSpacingToNyquist() {
        this.getSpacing().setUserContentAndUserUnit(1.0 / Math.sqrt(3.0) / 1.13, UserAngle.USERUNIT_FRACTION_OF_MAIN_BEAM);
    }

    @Override
    public boolean isRectanglePattern() {
        return true;
    }

    @Override
    public FieldPattern.FieldPatternType getFieldPatternType() {
        return FieldPattern.FieldPatternType.RECTANGLE;
    }

    public TargetParameters getTargetParameters() {
        return (TargetParameters)this.getParent();
    }

    public RectangleAreaExpert getRectangleAreaExpert() {
        if (this.rectangleAreaExpert == null) {
            this.rectangleAreaExpert = RectangleAreaExpert.of(this);
        }
        return this.rectangleAreaExpert;
    }

    public int getNumberOfPointings() {
        return this.getRectangleAreaExpert().getNumberOfPointings(Array.ARRAY_12M);
    }

    public int getNumberOfPointings(Array array) {
        return this.getRectangleAreaExpert().getNumberOfPointings(array);
    }

    @Override
    public Angle getRotationAngle() {
        return (Angle)this.getPALong().multiply(-1.0);
    }

    public ValueUnitPair getLatitudeLength() {
        return this.getShort();
    }

    public ValueUnitPair getLongitudeLength() {
        return this.getLong();
    }

    public Angle getOrthogonalStep() {
        return this.getSpacing();
    }

    @Override
    public Frequency getObservingFrequency() {
        return this.getReferenceFrequency();
    }

    @Override
    public MosaicParameters getMosaicParameters() {
        return this.mosaicParameters;
    }

    @Override
    public void setRotationAngle(@NonNull Angle angle) {
        if (angle == null) {
            throw new NullPointerException("angle is marked non-null but is null");
        }
        this.getPALong().setContentAndUnit(-angle.getContent(), angle.getUnit());
    }

    @Override
    public void representativeFrequencyUpdated(@NonNull RepresentativeFrequencyChangeEvent representativeFrequencyChangeEvent) {
        Frequency frequency;
        if (representativeFrequencyChangeEvent == null) {
            throw new NullPointerException("evt is marked non-null but is null");
        }
        TargetParameters targetParameters = this.getTargetParameters();
        if (targetParameters == null) {
            return;
        }
        ScienceGoal scienceGoal = targetParameters.getScienceGoal();
        if (scienceGoal == null) {
            return;
        }
        Object object = representativeFrequencyChangeEvent.getSource();
        if (object instanceof Frequency) {
            frequency = (Frequency)((Object)representativeFrequencyChangeEvent.getSource());
        } else {
            try {
                frequency = this.getTargetParameters().getScienceGoal().getSpectralSetupParameters().getRepresentativeFrequency();
            }
            catch (NullPointerException nullPointerException) {
                frequency = Frequency.createFrequencyGHZ(0.0);
            }
        }
        SpectralSetupParameters spectralSetupParameters = scienceGoal.getSpectralSetupParameters();
        if (!frequency.isZero()) {
            Frequency frequency2 = spectralSetupParameters.isSingleContinuumSkyFrequency() || spectralSetupParameters.isSpectralScan() ? frequency : targetParameters.getSourceVelocity().dopplerShift(frequency);
            this.getSpacing().setObservingFrequency(frequency2);
            this.setReferenceFrequency(frequency2);
        }
    }

    public Rectangle getTPArrayRectangle() {
        if (this.rectTP == null) {
            this.rectTP = Rectangle.createRectangle();
            this.rectTP.rect12m = this;
            this.rectTP.array = Array.ARRAY_TP;
        }
        Frequency frequency = this.getReferenceFrequency();
        this.updateRectTP(RectangleAreaExpert.of(this).getActualTPArrayRectangle(frequency, Optional.ofNullable(this.targetParameters)));
        return this.rectTP;
    }

    public Rectangle getTPArrayRectangle(@NonNull SpectralSpec spectralSpec) {
        if (spectralSpec == null) {
            throw new NullPointerException("ss is marked non-null but is null");
        }
        if (this.rectTP == null) {
            this.rectTP = Rectangle.createRectangle();
            this.rectTP.rect12m = this;
            this.rectTP.array = Array.ARRAY_TP;
        }
        RectangleAreaExpert rectangleAreaExpert = RectangleAreaExpert.of(this);
        this.updateRectTP(rectangleAreaExpert.getActualTPArrayRectangle(spectralSpec, Optional.ofNullable(this.targetParameters)));
        return this.rectTP;
    }

    public Rectangle getTPArrayRectangle(Frequency frequency) {
        if (this.rectTP == null) {
            this.rectTP = Rectangle.createRectangle();
            this.rectTP.rect12m = this;
            this.rectTP.array = Array.ARRAY_TP;
        }
        this.updateRectTP(RectangleAreaExpert.of(this).getActualTPArrayRectangle(frequency, Optional.ofNullable(this.targetParameters)));
        return this.rectTP;
    }

    private void updateRectTP(@NonNull Rectangle rectangle) {
        if (rectangle == null) {
            throw new NullPointerException("rectangle is marked non-null but is null");
        }
        this.rectTP.getLong().setContentAndUnit((ValueUnitPair)rectangle.getLong());
        this.rectTP.getShort().setContentAndUnit((ValueUnitPair)rectangle.getShort());
        this.rectTP.getPALong().setContentAndUnit((ValueUnitPair)rectangle.getPALong());
        this.rectTP.getSpacing().setContentAndUnit(rectangle.getSpacing());
        this.rectTP.setReferenceFrequency(rectangle.getReferenceFrequency());
        this.rectTP.setCentre(rectangle.getCentre());
    }

    public SkyCoordinates getSourceCoordinates() {
        if (this.array == Array.ARRAY_12M) {
            return super.getSourceCoordinates();
        }
        return this.rect12m.getSourceCoordinates();
    }

    public String toDetailString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName()).append("@");
        stringBuilder.append(this.hashCode()).append(" ");
        stringBuilder.append(this.getLongitudeLength()).append(" x ").append(this.getLatitudeLength()).append(" at ");
        SkyCoordinates skyCoordinates = this.getSourceCoordinates();
        if (skyCoordinates == null) {
            stringBuilder.append("[ (not set) ]");
        } else {
            stringBuilder.append("[").append((Object)this.getSourceCoordinates().getLongitude()).append(",").append((Object)this.getSourceCoordinates().getLatitude()).append("]");
        }
        stringBuilder.append(" obs at " + String.valueOf((Object)this.gettrueReferenceFrequency()));
        return stringBuilder.toString();
    }

    public String toString() {
        return this.toDetailString();
    }

    public void setIsMosaic(boolean bl) {
        TargetParameters targetParameters = this.getTargetParameters();
        if (null != targetParameters) {
            targetParameters.setIsMosaic(bl);
        }
    }

    @Override
    public boolean isMosaic() {
        TargetParameters targetParameters = this.getTargetParameters();
        return null == targetParameters ? false : targetParameters.getIsMosaic();
    }

    public SkyCoordinates getTPRectangleCentralCoordinate() throws UnableToDetermineCentralCoordinateException {
        SkyCoordinates skyCoordinates = SkyCoordinates.createOffsetCoordinates();
        if (this.tpRectangleVertices.size() != 4) {
            throw new UnableToDetermineCentralCoordinateException("TP rectangle is not set up: expected 4 corners");
        }
        CartesianCoordinate cartesianCoordinate = this.tpRectangleVertices.get(0);
        CartesianCoordinate cartesianCoordinate2 = this.tpRectangleVertices.get(2);
        Angle angle = (Angle)((Angle)cartesianCoordinate.getX().plus((AbstractDoubleWithUnit)cartesianCoordinate2.getX())).divide(2.0);
        Angle angle2 = (Angle)((Angle)cartesianCoordinate.getY().plus((AbstractDoubleWithUnit)cartesianCoordinate2.getY())).divide(2.0);
        skyCoordinates.setLatitude(Latitude.createLatitude((double)angle2.getContentInUnits(Angle.UNIT_ARCSEC), (String)Angle.UNIT_ARCSEC));
        skyCoordinates.setLongitude(Longitude.createLongitude((double)angle.getContentInUnits(Angle.UNIT_ARCSEC), (String)Angle.UNIT_ARCSEC));
        skyCoordinates.setSystem(SkyCoordinates.SYSTEM_J2000);
        Log.logger(Rectangle.class).fine(String.format("TP rectangle mid-point (arcsecs) is: %.4g long %.4g lat", angle.getContentInUnits(Angle.UNIT_ARCSEC), angle2.getContentInUnits(Angle.UNIT_ARCSEC)));
        try {
            Log.logger(Rectangle.class).fine(String.format("TP rectangle mid-point (arcsecs) is: RA %s Dec %s", skyCoordinates.getLongitude().toHHMMSS(), skyCoordinates.getLatitude().toDDMMSS()));
        }
        catch (InvalidCoordException | OutOfRangeException exception) {
            // empty catch block
        }
        return skyCoordinates;
    }

    public void duplicate(@NonNull Rectangle rectangle) {
        if (rectangle == null) {
            throw new NullPointerException("rectangle is marked non-null but is null");
        }
        rectangle.array = this.array;
        rectangle.rectangleAreaExpert = this.rectangleAreaExpert;
        rectangle.mosaicParameters = this.mosaicParameters;
        rectangle.rect12m = this.rect12m;
        rectangle.rectTP = this.rectTP;
        rectangle.tpRectangleVertices = this.tpRectangleVertices;
        rectangle.getLong().setContentAndUnit((ValueUnitPair)this.getLong());
        rectangle.getShort().setContentAndUnit((ValueUnitPair)this.getShort());
        rectangle.getPALong().setContentAndUnit((ValueUnitPair)this.getPALong());
        rectangle.getSpacing().setContentAndUnit(this.getSpacing());
        rectangle.getRotationAngle().setContentAndUnit((ValueUnitPair)this.getRotationAngle());
        rectangle.setReferenceFrequency(this.getReferenceFrequency());
        rectangle.setCentre(this.getCentre());
        rectangle.setTargetParameters(this.targetParameters);
    }

    public void setTargetParameters(TargetParameters targetParameters) {
        this.targetParameters = targetParameters.deepCopy();
    }

    @Override
    public Array getArray() {
        return this.array;
    }

    public void setArray(Array array) {
        this.array = array;
    }

    public boolean isSystemRotationApplied() {
        return this.isSystemRotationApplied;
    }

    public void setSystemRotationApplied(boolean bl) {
        this.isSystemRotationApplied = bl;
    }

    public static class CartesianCoordinate {
        private Angle X = null;
        private Angle Y = null;

        public CartesianCoordinate(@NonNull Angle angle, @NonNull Angle angle2) {
            if (angle == null) {
                throw new NullPointerException("x is marked non-null but is null");
            }
            if (angle2 == null) {
                throw new NullPointerException("y is marked non-null but is null");
            }
            this.X = angle;
            this.Y = angle2;
        }

        public Angle getX() {
            return this.X;
        }

        public Angle getY() {
            return this.Y;
        }

        public void setX(Angle angle) {
            this.X = angle;
        }

        public void setY(Angle angle) {
            this.Y = angle;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof CartesianCoordinate)) {
                return false;
            }
            CartesianCoordinate cartesianCoordinate = (CartesianCoordinate)object;
            if (!cartesianCoordinate.canEqual(this)) {
                return false;
            }
            Angle angle = this.getX();
            Angle angle2 = cartesianCoordinate.getX();
            if (angle == null ? angle2 != null : !((Object)((Object)angle)).equals((Object)angle2)) {
                return false;
            }
            Angle angle3 = this.getY();
            Angle angle4 = cartesianCoordinate.getY();
            return !(angle3 == null ? angle4 != null : !((Object)((Object)angle3)).equals((Object)angle4));
        }

        protected boolean canEqual(Object object) {
            return object instanceof CartesianCoordinate;
        }

        public int hashCode() {
            int n = 1;
            Angle angle = this.getX();
            n = n * 59 + (angle == null ? 43 : ((Object)((Object)angle)).hashCode());
            Angle angle2 = this.getY();
            n = n * 59 + (angle2 == null ? 43 : ((Object)((Object)angle2)).hashCode());
            return n;
        }

        public String toString() {
            return "Rectangle.CartesianCoordinate(X=" + String.valueOf((Object)this.getX()) + ", Y=" + String.valueOf((Object)this.getY()) + ")";
        }
    }

    public static class UnableToDetermineCentralCoordinateException
    extends Exception {
        public UnableToDetermineCentralCoordinateException(String string) {
            super(string);
        }
    }
}

