/*
 * Decompiled with CFR 0.152.
 */
package jsky.catalog.gui;

import diva.canvas.CanvasComponent;
import diva.canvas.CanvasLayer;
import diva.canvas.DamageRegion;
import diva.canvas.TransformContext;
import diva.canvas.event.LayerEvent;
import diva.canvas.event.LayerListener;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import jsky.catalog.BasicQueryArgs;
import jsky.catalog.Catalog;
import jsky.catalog.PlotableCatalog;
import jsky.catalog.QueryArgs;
import jsky.catalog.RowCoordinates;
import jsky.catalog.TablePlotSymbol;
import jsky.catalog.TableQueryResult;
import jsky.catalog.gui.SymbolSelectionEvent;
import jsky.catalog.gui.SymbolSelectionListener;
import jsky.catalog.gui.TablePlotter;
import jsky.catalog.gui.TableSelectionEvent;
import jsky.catalog.gui.TableSelectionListener;
import jsky.catalog.gui.TableSymbolConfig;
import jsky.coords.CoordinateConverter;
import jsky.coords.CoordinateRadius;
import jsky.coords.Coordinates;
import jsky.coords.ImageCoords;
import jsky.coords.NamedCoordinates;
import jsky.coords.WorldCoordinates;
import jsky.coords.WorldCoords;
import jsky.graphics.CanvasGraphics;
import jsky.image.graphics.DivaImageGraphics;
import jsky.image.graphics.ShapeUtil;
import jsky.image.gui.GraphicsImageDisplay;
import jsky.image.gui.ImageCoordinateConverter;
import jsky.navigator.NavigatorPane;
import jsky.util.IApplyCancel;
import jsky.util.java2d.ShapeUtilities;

public class BasicTablePlotter
implements TablePlotter,
LayerListener,
ChangeListener {
    private DivaImageGraphics _imageGraphics;
    private CanvasLayer _layer;
    private ImageCoordinateConverter _coordinateConverter;
    private double _imageEquinox = 2000.0;
    private List<TableListItem> _tableList = new LinkedList<TableListItem>();
    private SymbolListItem[] _symbolAr;
    private List<FigureListItem> _figureList;
    private boolean _visible = true;
    private EventListenerList _listenerList = new EventListenerList();
    private EventListenerList _tableListenerList = new EventListenerList();
    private Map<Catalog, TablePlotSymbol[]> _plotSymbolMap = new Hashtable<Catalog, TablePlotSymbol[]>(32);
    private Stroke _selectedStroke = new BasicStroke(3.0f);

    @Override
    public void setCanvasGraphics(CanvasGraphics canvasGraphics) {
        this._imageGraphics = (DivaImageGraphics)canvasGraphics;
        NavigatorPane pane = (NavigatorPane)this._imageGraphics.getGraphicsPane();
        this._layer = pane.getSymbolLayer();
        pane.getBackgroundEventLayer().addLayerListener((LayerListener)this);
    }

    @Override
    public CanvasGraphics getCanvasGraphics() {
        return this._imageGraphics;
    }

    @Override
    public CoordinateConverter getCoordinateConverter() {
        return this._coordinateConverter;
    }

    @Override
    public void setCoordinateConverter(CoordinateConverter c) {
        this._coordinateConverter = (ImageCoordinateConverter)c;
    }

    public boolean check(TableQueryResult table) {
        WorldCoordinates pos;
        GraphicsImageDisplay imageDisplay = (GraphicsImageDisplay)this._coordinateConverter.getImageDisplay();
        if (imageDisplay.isClear() && (pos = table.getWCSCenter()) != null) {
            imageDisplay.blankImage(pos.getRaDeg(), pos.getDecDeg());
        }
        return this._coordinateConverter.isWCS();
    }

    @Override
    public void plot(TableQueryResult table) {
        if (this._layer == null || this._coordinateConverter == null) {
            return;
        }
        if (!this.check(table)) {
            return;
        }
        TablePlotSymbol[] symbols = this.getPlotSymbolInfo(table);
        if (symbols == null) {
            return;
        }
        for (TablePlotSymbol symbol : symbols) {
            symbol.setTable(table);
        }
        this._symbolAr = new SymbolListItem[symbols.length];
        for (int i = 0; i < symbols.length; ++i) {
            this._symbolAr[i] = new SymbolListItem(symbols[i]);
        }
        this.plotSymbols(table, symbols);
        ListIterator<TableListItem> it = this._tableList.listIterator(0);
        while (it.hasNext()) {
            TableListItem item = it.next();
            if (item.table != table && !item.table.getName().equals(table.getName()) || item.table.getCatalog() != table.getCatalog()) continue;
            it.remove();
            break;
        }
        this._tableList.add(new TableListItem(table, this._symbolAr));
        this._coordinateConverter.removeChangeListener((ChangeListener)this);
        this._coordinateConverter.addChangeListener((ChangeListener)this);
        this._layer.repaint();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.replotAll();
    }

    @Override
    public TablePlotSymbol[] getPlotSymbolInfo(TableQueryResult table) {
        TablePlotSymbol[] o = this._plotSymbolMap.get(table);
        Catalog catalog = table.getCatalog();
        if (o == null && catalog != null) {
            o = this._plotSymbolMap.get(catalog);
        }
        if (o instanceof TablePlotSymbol[]) {
            return o;
        }
        if (catalog instanceof PlotableCatalog) {
            TablePlotSymbol[] symbols = ((PlotableCatalog)catalog).getSymbols();
            if (symbols != null) {
                this._plotSymbolMap.put((Catalog)table, symbols);
                this._plotSymbolMap.put(catalog, symbols);
            }
            return symbols;
        }
        return null;
    }

    @Override
    public void setPlotSymbolInfo(TableQueryResult table, TablePlotSymbol[] symbols) {
        Catalog catalog = table.getCatalog();
        this._plotSymbolMap.put((Catalog)table, symbols);
        if (catalog != null) {
            this._plotSymbolMap.put(catalog, symbols);
        }
    }

    protected void plotSymbols(TableQueryResult table, TablePlotSymbol[] symbols) {
        int cooSys;
        int nrows = table.getRowCount();
        RowCoordinates rowCoords = table.getRowCoordinates();
        Vector dataVec = table.getDataVector();
        boolean isWCS = rowCoords.isWCS();
        boolean isPix = rowCoords.isPix();
        if (isPix) {
            cooSys = 0;
        } else if (isWCS) {
            cooSys = 4;
            this._imageEquinox = this._coordinateConverter.getEquinox();
        } else {
            throw new RuntimeException("no wcs or image coordinates to plot");
        }
        for (int row = 0; row < nrows; ++row) {
            double y;
            double x;
            Vector rowVec = (Vector)dataVec.get(row);
            Coordinates pos = rowCoords.getCoordinates(rowVec);
            if (pos == null) continue;
            if (isPix) {
                x = pos.getX();
                y = pos.getY();
            } else {
                double[] radec = ((WorldCoords)pos).getRaDec(this._imageEquinox);
                x = radec[0];
                y = radec[1];
            }
            for (int i = 0; i < symbols.length; ++i) {
                this._figureList = this._symbolAr[i].figureList;
                try {
                    this.plotRow(row, rowVec, x, y, cooSys, symbols[i]);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    protected void plotRow(int row, Vector rowVec, double x, double y, int cooSys, TablePlotSymbol symbol) {
        boolean cond = symbol.getCond(rowVec);
        if (!cond) {
            return;
        }
        double radius = symbol.getSize(rowVec);
        if (radius <= 0.0 || Double.isNaN(radius)) {
            return;
        }
        double ratio = symbol.getRatio(rowVec);
        double angle = symbol.getAngle(rowVec);
        String label = symbol.getLabel(rowVec);
        this.plotSymbol(row, symbol, x, y, cooSys, radius, ratio, angle, label);
    }

    protected void plotSymbol(int row, TablePlotSymbol symbol, double x, double y, int cooSys, double radius, double ratio, double angle, String label) {
        Point2D.Double pos = new Point2D.Double(x, y);
        this._coordinateConverter.convertCoords(pos, cooSys, 3, false);
        double w = this._coordinateConverter.getWidth();
        double h = this._coordinateConverter.getHeight();
        if (pos.x < 0.0 || pos.y < 0.0 || pos.x >= w || pos.y >= h) {
            return;
        }
        this._coordinateConverter.convertCoords(pos, 3, 1, false);
        Point2D.Double size = new Point2D.Double(radius, radius);
        int sizeType = this.getCoordType(symbol.getUnits());
        this._coordinateConverter.convertCoords(size, sizeType, 1, true);
        Shape shape = this.makeShape(symbol, pos.x, pos.y, Math.max(size.x, size.y), ratio, angle);
        FigureListItem item = new FigureListItem(shape, label, row);
        this._figureList.add(item);
    }

    protected int getCoordType(String name) {
        if (name != null && name.length() != 0) {
            if (name.startsWith("deg")) {
                return 4;
            }
            if (name.equals("image")) {
                return 0;
            }
            if (name.equals("screen")) {
                return 1;
            }
            if (name.equals("canvas")) {
                return 2;
            }
            if (name.equals("user")) {
                return 3;
            }
        }
        return 0;
    }

    protected Shape makeShape(TablePlotSymbol symbol, double x, double y, double size, double ratio, double angle) {
        int shape = symbol.getShape();
        switch (shape) {
            case 0: {
                return new Ellipse2D.Double(x - size, y - size, size * 2.0, size * 2.0);
            }
            case 1: {
                return new Rectangle2D.Double(x - size, y - size, size * 2.0, size * 2.0);
            }
            case 3: {
                return ShapeUtil.makeCross((double)x, (double)y, (double)size);
            }
            case 4: {
                return ShapeUtil.makeTriangle((double)x, (double)y, (double)size);
            }
            case 5: {
                return ShapeUtil.makeDiamond((double)x, (double)y, (double)size);
            }
        }
        Point2D.Double center = new Point2D.Double(x, y);
        Point2D.Double north = new Point2D.Double(x, y - size);
        Point2D.Double east = new Point2D.Double(x - size, y);
        this.getNorthAndEast(center, size, ratio, angle, north, east);
        switch (shape) {
            case 7: {
                return ShapeUtil.makeCompass((Point2D.Double)center, (Point2D.Double)north, (Point2D.Double)east);
            }
            case 8: {
                return ShapeUtil.makeLine((Point2D.Double)center, (Point2D.Double)north);
            }
            case 9: {
                return ShapeUtil.makeArrow((Point2D.Double)center, (Point2D.Double)north);
            }
            case 6: {
                return ShapeUtil.makeEllipse((Point2D.Double)center, (Point2D.Double)north, (Point2D.Double)east);
            }
            case 2: {
                return ShapeUtil.makePlus((Point2D.Double)center, (Point2D.Double)north, (Point2D.Double)east);
            }
        }
        throw new RuntimeException("Unknown plot symbol shape: " + symbol.getShapeName());
    }

    protected void getNorthAndEast(Point2D.Double center, double size, double ratio, double angle, Point2D.Double north, Point2D.Double east) {
        if (this._coordinateConverter.isWCS()) {
            Point2D.Double wcsCenter = new Point2D.Double(center.x, center.y);
            this._coordinateConverter.screenToWorldCoords(wcsCenter, false);
            Point2D.Double wcsRadius = new Point2D.Double(size, size);
            this._coordinateConverter.screenToWorldCoords(wcsRadius, true);
            if (ratio < 1.0) {
                wcsRadius.y *= 1.0 / ratio;
            } else if (ratio > 1.0) {
                wcsRadius.x *= ratio;
            }
            east.x = Math.IEEEremainder(wcsCenter.x + Math.abs(wcsRadius.x) / Math.cos(wcsCenter.y / 180.0 * Math.PI), 360.0);
            if (east.x < 0.0) {
                east.x += 360.0;
            }
            east.y = wcsCenter.y;
            north.x = wcsCenter.x;
            north.y = wcsCenter.y + Math.abs(wcsRadius.y);
            if (north.y >= 90.0) {
                north.y = 180.0 - north.y;
            } else if (north.y <= -90.0) {
                north.y = -180.0 - north.y;
            }
            this._coordinateConverter.worldToScreenCoords(north, false);
            this._coordinateConverter.worldToScreenCoords(east, false);
        } else {
            double rx = size;
            double ry = size;
            if (ratio < 1.0) {
                ry *= 1.0 / ratio;
            } else if (ratio > 1.0) {
                rx *= ratio;
            }
            east.x = center.x - rx;
            east.y = center.y;
            north.x = center.x;
            north.y = center.y - ry;
        }
        if (angle != 0.0) {
            this.rotatePoint(north, center, angle);
            this.rotatePoint(east, center, angle);
        }
    }

    protected void rotatePoint(Point2D.Double p, Point2D.Double center, double angle) {
        p.x -= center.x;
        p.y -= center.y;
        double tmp = p.x;
        double rad = angle * Math.PI / 180.0;
        double cosa = Math.cos(rad);
        double sina = Math.sin(rad);
        p.x = p.x * cosa + p.y * sina + center.x;
        p.y = -tmp * sina + p.y * cosa + center.y;
    }

    @Override
    public void unplot(TableQueryResult table) {
        ListIterator<TableListItem> it = this._tableList.listIterator(0);
        while (it.hasNext()) {
            TableListItem item = it.next();
            if (item.table != table) continue;
            it.remove();
            this._layer.repaint();
            break;
        }
    }

    @Override
    public void unplotAll() {
        this._tableList = new LinkedList<TableListItem>();
        this._layer.repaint();
    }

    @Override
    public void replotAll() {
        LinkedList<TableListItem> list = new LinkedList<TableListItem>(this._tableList);
        this._tableList = new LinkedList<TableListItem>();
        for (TableListItem item : list) {
            item.inRange = this.tableInRange(item.table);
            if (item.inRange) {
                this.plot(item.table);
                continue;
            }
            this._tableList.add(item);
        }
        this._layer.repaint();
    }

    @Override
    public TableQueryResult[] getTables() {
        int n = this._tableList.size();
        if (n == 0) {
            return null;
        }
        ListIterator<TableListItem> it = this._tableList.listIterator(0);
        ArrayList<TableQueryResult> tableList = new ArrayList<TableQueryResult>(n);
        while (it.hasNext()) {
            TableListItem item = it.next();
            if (!item.inRange) continue;
            tableList.add(item.table);
        }
        n = tableList.size();
        if (n == 0) {
            return null;
        }
        TableQueryResult[] tables = new TableQueryResult[n];
        return tableList.toArray(tables);
    }

    protected void repaint(Shape shape) {
        this._layer.repaint(DamageRegion.createDamageRegion((TransformContext)new TransformContext((CanvasComponent)this._layer), (Rectangle2D)shape.getBounds2D()));
    }

    public void selectSymbol(TableQueryResult table, int tableRow, boolean selected) {
        ListIterator<TableListItem> tableIt = this._tableList.listIterator(0);
        while (tableIt.hasNext()) {
            TableListItem tli = tableIt.next();
            if (tli.table != table) continue;
            for (int i = 0; i < tli.symbolAr.length; ++i) {
                SymbolListItem sli = tli.symbolAr[i];
                ListIterator<FigureListItem> figureListIt = sli.figureList.listIterator(0);
                while (figureListIt.hasNext()) {
                    FigureListItem fli = figureListIt.next();
                    if (fli.row != tableRow || fli.selected == selected) continue;
                    fli.selected = selected;
                    this.repaint(fli.shape);
                }
            }
        }
        this.fireTableSelectionEvent(table, tableRow, selected);
    }

    @Override
    public void selectSymbol(TableQueryResult table, int tableRow) {
        this.selectSymbol(table, tableRow, true);
    }

    @Override
    public void deselectSymbol(TableQueryResult table, int tableRow) {
        this.selectSymbol(table, tableRow, false);
    }

    @Override
    public void addSymbolSelectionListener(SymbolSelectionListener listener) {
        this._listenerList.add(SymbolSelectionListener.class, listener);
    }

    @Override
    public void removeSymbolSelectionListener(SymbolSelectionListener listener) {
        this._listenerList.remove(SymbolSelectionListener.class, listener);
    }

    protected void fireSymbolSelectionEvent(TableQueryResult table, int row, boolean isSelected) {
        SymbolSelectionEvent event = new SymbolSelectionEvent(row, table);
        Object[] listeners = this._listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != SymbolSelectionListener.class) continue;
            SymbolSelectionListener listener = (SymbolSelectionListener)listeners[i + 1];
            if (isSelected) {
                listener.symbolSelected(event);
                continue;
            }
            listener.symbolDeselected(event);
        }
    }

    @Override
    public void addTableSelectionListener(TableSelectionListener listener) {
        this._tableListenerList.add(TableSelectionListener.class, listener);
    }

    @Override
    public void removeTableSelectionListener(TableSelectionListener listener) {
        this._tableListenerList.remove(TableSelectionListener.class, listener);
    }

    protected void fireTableSelectionEvent(TableQueryResult table, int row, boolean selected) {
        TableSelectionEvent event = new TableSelectionEvent(row, table);
        Object[] listeners = this._tableListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TableSelectionListener.class) continue;
            TableSelectionListener listener = (TableSelectionListener)listeners[i + 1];
            if (!selected) continue;
            listener.tableSelected(event);
        }
    }

    @Override
    public void setVisible(boolean isVisible) {
        this._visible = isVisible;
    }

    public boolean isVisible() {
        return this._visible;
    }

    @Override
    public IApplyCancel getConfigPanel(TableQueryResult table) {
        return new TableSymbolConfig(this, table);
    }

    @Override
    public void paintSymbols(Graphics2D g2d, Rectangle2D region) {
        if (!this._visible) {
            return;
        }
        g2d.setPaintMode();
        ListIterator<TableListItem> tableIt = this._tableList.listIterator(0);
        while (tableIt.hasNext()) {
            TableListItem tli = tableIt.next();
            if (!tli.inRange) continue;
            for (int i = 0; i < tli.symbolAr.length; ++i) {
                SymbolListItem sli = tli.symbolAr[i];
                g2d.setColor(sli.symbol.getFg());
                ListIterator<FigureListItem> figureListIt = sli.figureList.listIterator(0);
                while (figureListIt.hasNext()) {
                    FigureListItem fli = figureListIt.next();
                    if (region != null && !fli.shape.intersects(region)) continue;
                    if (fli.selected) {
                        Stroke stroke = g2d.getStroke();
                        g2d.setStroke(this._selectedStroke);
                        g2d.draw(fli.shape);
                        g2d.setStroke(stroke);
                    } else {
                        g2d.draw(fli.shape);
                    }
                    if (fli.label == null) continue;
                    Rectangle r = fli.shape.getBounds();
                    g2d.drawString(fli.label, (float)r.getCenterX(), (float)r.getCenterY());
                }
            }
        }
    }

    @Override
    public void transformGraphics(AffineTransform trans) {
        ListIterator<TableListItem> tableIt = this._tableList.listIterator(0);
        while (tableIt.hasNext()) {
            TableListItem tli = tableIt.next();
            for (int i = 0; i < tli.symbolAr.length; ++i) {
                SymbolListItem sli = tli.symbolAr[i];
                ListIterator<FigureListItem> figureListIt = sli.figureList.listIterator(0);
                while (figureListIt.hasNext()) {
                    FigureListItem fli = figureListIt.next();
                    fli.shape = ShapeUtilities.transformModify(fli.shape, trans);
                }
            }
        }
        this._layer.repaint();
    }

    protected boolean tableInRange(TableQueryResult table) {
        CoordinateRadius region;
        QueryArgs queryArgs = table.getQueryArgs();
        if (queryArgs == null) {
            region = this.getTableRegion(table);
            if (region != null) {
                queryArgs = new BasicQueryArgs((Catalog)table);
                queryArgs.setRegion(region);
                table.setQueryArgs(queryArgs);
            }
        } else {
            region = queryArgs.getRegion();
        }
        if (region == null) {
            return false;
        }
        Coordinates centerPosition = region.getCenterPosition();
        if (!(centerPosition instanceof WorldCoords)) {
            return true;
        }
        if (!this._coordinateConverter.isWCS()) {
            return false;
        }
        WorldCoords pos = (WorldCoords)centerPosition;
        double ra = pos.getRaDeg();
        double dec = pos.getDecDeg();
        double w = region.getWidth();
        double h = region.getHeight();
        Rectangle2D.Double tableRect = new Rectangle2D.Double(ra, dec, w, h);
        Point2D.Double p = this._coordinateConverter.getWCSCenter();
        pos = new WorldCoords(p.x, p.y, this._imageEquinox);
        ra = pos.getRaDeg();
        dec = pos.getDecDeg();
        w = this._coordinateConverter.getWidthInDeg() * 60.0;
        h = this._coordinateConverter.getHeightInDeg() * 60.0;
        Rectangle2D.Double imageRect = new Rectangle2D.Double(ra, dec, w, h);
        return tableRect.intersects(imageRect);
    }

    protected CoordinateRadius getTableRegion(TableQueryResult table) {
        int nrows = table.getRowCount();
        if (nrows == 0) {
            return null;
        }
        RowCoordinates rowCoords = table.getRowCoordinates();
        double tableEquinox = rowCoords.getEquinox();
        Vector dataVec = table.getDataVector();
        if (rowCoords.isPix()) {
            Point2D.Double p = this._coordinateConverter.getImageCenter();
            ImageCoords pos = new ImageCoords(p.x, p.y);
            double w = this._coordinateConverter.getWidth();
            double h = this._coordinateConverter.getHeight();
            double r = Math.sqrt(w * w + h * h);
            return new CoordinateRadius((Coordinates)pos, r, w, h);
        }
        if (!rowCoords.isWCS()) {
            return null;
        }
        double ra0 = 0.0;
        double ra1 = 0.0;
        double dec0 = 0.0;
        double dec1 = 0.0;
        boolean firstTime = true;
        for (int row = 1; row < nrows; ++row) {
            Vector rowVec = (Vector)dataVec.get(row);
            Coordinates pos = rowCoords.getCoordinates(rowVec);
            if (pos == null) continue;
            if (firstTime) {
                firstTime = false;
                ra1 = ra0 = pos.getX();
                dec1 = dec0 = pos.getY();
                continue;
            }
            double ra = pos.getX();
            double dec = pos.getY();
            ra0 = Math.min(ra0, ra);
            ra1 = Math.max(ra1, ra);
            dec0 = Math.min(dec0, dec);
            dec1 = Math.max(dec1, dec);
        }
        WorldCoords centerPos = new WorldCoords((ra0 + ra1) / 2.0, (dec0 + dec1) / 2.0, tableEquinox);
        double d = WorldCoords.dist((double)ra0, (double)dec0, (double)ra1, (double)dec1);
        return new CoordinateRadius((Coordinates)centerPos, d / 2.0);
    }

    public void mouseDragged(LayerEvent e) {
    }

    public void mousePressed(LayerEvent e) {
    }

    public void mouseReleased(LayerEvent e) {
    }

    public void mouseClicked(LayerEvent e) {
        if (!this._visible) {
            return;
        }
        double x = e.getLayerX();
        double y = e.getLayerY();
        boolean toggleSel = e.isShiftDown() || e.isControlDown();
        ListIterator<TableListItem> tableIt = this._tableList.listIterator(0);
        while (tableIt.hasNext()) {
            TableListItem tli = tableIt.next();
            if (!tli.inRange) continue;
            for (int i = 0; i < tli.symbolAr.length; ++i) {
                SymbolListItem sli = tli.symbolAr[i];
                ListIterator<FigureListItem> figureListIt = sli.figureList.listIterator(0);
                while (figureListIt.hasNext()) {
                    FigureListItem fli = figureListIt.next();
                    if (sli.symbol.getBoundingShape(fli.shape).contains(x, y)) {
                        if (toggleSel) {
                            fli.selected = !fli.selected;
                            this.repaint(fli.shape);
                            this.fireSymbolSelectionEvent(tli.table, fli.row, fli.selected);
                            continue;
                        }
                        if (fli.selected) continue;
                        fli.selected = true;
                        this.repaint(fli.shape);
                        this.fireSymbolSelectionEvent(tli.table, fli.row, fli.selected);
                        continue;
                    }
                    if (toggleSel || !fli.selected) continue;
                    fli.selected = false;
                    this.repaint(fli.shape);
                    this.fireSymbolSelectionEvent(tli.table, fli.row, fli.selected);
                }
            }
        }
    }

    @Override
    public NamedCoordinates getCatalogPosition(Point2D.Double p) {
        ListIterator<TableListItem> tableIt = this._tableList.listIterator(0);
        while (tableIt.hasNext()) {
            TableListItem tli = tableIt.next();
            if (!tli.inRange) continue;
            for (int i = 0; i < tli.symbolAr.length; ++i) {
                SymbolListItem sli = tli.symbolAr[i];
                ListIterator<FigureListItem> figureListIt = sli.figureList.listIterator(0);
                while (figureListIt.hasNext()) {
                    Object o;
                    FigureListItem fli = figureListIt.next();
                    if (!fli.selected || !sli.symbol.getBoundingShape(fli.shape).contains(p)) continue;
                    RowCoordinates rowCoords = tli.table.getRowCoordinates();
                    if (!rowCoords.isWCS()) {
                        return null;
                    }
                    Vector dataVec = tli.table.getDataVector();
                    this._imageEquinox = this._coordinateConverter.getEquinox();
                    Vector rowVec = (Vector)dataVec.get(fli.row);
                    Coordinates cpos = rowCoords.getCoordinates(rowVec);
                    if (cpos == null) {
                        return null;
                    }
                    WorldCoords pos = (WorldCoords)cpos;
                    double[] radec = pos.getRaDec(this._imageEquinox);
                    p.x = radec[0];
                    p.y = radec[1];
                    this._coordinateConverter.convertCoords(p, 4, 1, false);
                    int idCol = rowCoords.getIdCol();
                    String id = null;
                    if (idCol != -1 && (o = rowVec.get(idCol)) != null) {
                        id = o.toString();
                    }
                    Vector columnIdentifiers = tli.table.getColumnIdentifiers();
                    int numCols = columnIdentifiers.size();
                    String brightness = "";
                    for (int col = 0; col < numCols; ++col) {
                        Object o2;
                        String s = (String)columnIdentifiers.get(col);
                        String sl = s.toLowerCase();
                        if (sl.equals("mag")) {
                            o2 = rowVec.get(col);
                            if (o2 == null) continue;
                            brightness = o2 + " mag";
                            break;
                        }
                        if (!sl.endsWith("mag") || sl.startsWith("e") || (o2 = rowVec.get(col)) == null) continue;
                        if (brightness.length() != 0) {
                            brightness = brightness + ", ";
                        }
                        brightness = brightness + o2 + s.charAt(0);
                    }
                    return new NamedCoordinates(id, (Coordinates)pos, brightness);
                }
            }
        }
        return null;
    }

    protected class FigureListItem {
        public Shape shape;
        public String label;
        public int row;
        public boolean selected = false;

        public FigureListItem(Shape s, String lab, int r) {
            this.shape = s;
            this.label = lab;
            this.row = r;
        }
    }

    protected class SymbolListItem {
        public TablePlotSymbol symbol;
        public List<FigureListItem> figureList = new LinkedList<FigureListItem>();

        public SymbolListItem(TablePlotSymbol s) {
            this.symbol = s;
        }
    }

    protected class TableListItem {
        public TableQueryResult table;
        public SymbolListItem[] symbolAr;
        public boolean inRange = true;

        public TableListItem(TableQueryResult t, SymbolListItem[] ar) {
            this.table = t;
            this.symbolAr = ar;
        }
    }
}

