/*
 * Decompiled with CFR 0.152.
 */
package diva.graph.layout;

import diva.graph.GraphModel;
import diva.graph.GraphUtilities;
import diva.graph.basic.BasicGraphModel;
import diva.graph.layout.AbstractGlobalLayout;
import diva.graph.layout.LayoutTarget;
import diva.graph.layout.LayoutUtilities;
import diva.graph.modular.CompositeNode;
import diva.graph.modular.Edge;
import diva.graph.modular.Node;
import diva.util.ArrayIterator;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class LevelLayout
extends AbstractGlobalLayout {
    public static final int VERTICAL = 0;
    public static final int HORIZONTAL = 1;
    protected int _orientation = 0;
    private BasicGraphModel _local = new BasicGraphModel();
    private boolean _randomizedPlacement = true;

    public LevelLayout(LayoutTarget target) {
        super(target);
    }

    protected Object copyComposite(Object origComposite) {
        GraphModel model = this.getLayoutTarget().getGraphModel();
        CompositeNode copyComposite = this._local.createComposite(null);
        HashMap map = new HashMap();
        Iterator i = model.nodes(origComposite);
        while (i.hasNext()) {
            Object origNode = i.next();
            if (!this.getLayoutTarget().isNodeVisible(origNode)) continue;
            Rectangle2D r = this.getLayoutTarget().getBounds(origNode);
            LevelInfo inf = new LevelInfo();
            inf.origNode = origNode;
            inf.x = r.getX();
            inf.y = r.getY();
            inf.width = r.getWidth();
            inf.height = r.getHeight();
            Node copyNode = this._local.createNode(inf);
            this._local.addNode(this, copyNode, copyComposite);
            map.put(origNode, copyNode);
        }
        i = model.nodes(origComposite);
        while (i.hasNext()) {
            Object origTail = i.next();
            Iterator j = model.outEdges(origTail);
            while (j.hasNext()) {
                Object origEdge = j.next();
                Object origHead = model.getHead(origEdge);
                if (origHead == null) continue;
                Object copyTail = map.get(origTail);
                Object copyHead = map.get(origHead);
                if (copyHead == null || copyTail == null) continue;
                Edge copyEdge = this._local.createEdge(origEdge);
                this._local.setEdgeTail(this, copyEdge, copyTail);
                this._local.setEdgeHead(this, copyEdge, copyHead);
            }
        }
        return copyComposite;
    }

    protected void copyLayout(Object origComposite, Object copyComposite) {
        Iterator ns = this._local.nodes(copyComposite);
        while (ns.hasNext()) {
            Object copyNode = ns.next();
            LevelInfo inf = this.getLevelInfo(copyNode);
            this.ASSERT(inf != null, "null inf");
            if (inf.origNode == null) continue;
            Rectangle2D r = this.getLayoutTarget().getBounds(inf.origNode);
            this.ASSERT(r != null, "null rect");
            this.getLayoutTarget().translate(inf.origNode, inf.x - r.getX(), inf.y - r.getY());
        }
        LayoutUtilities.routeVisibleEdges(origComposite, this.getLayoutTarget());
    }

    public BasicGraphModel getLocalGraphModel() {
        return this._local;
    }

    public int getOrientation() {
        return this._orientation;
    }

    public boolean getRandomizedPlacement() {
        return this._randomizedPlacement;
    }

    public void layout(Object composite) {
        LevelData levelData = this.calculateLayout(composite);
        if (levelData != null) {
            this.applyLayout(levelData, composite);
        }
    }

    public LevelData calculateLayout(Object composite) {
        GraphModel model = this.getLayoutTarget().getGraphModel();
        if (model.getNodeCount(composite) > 0) {
            int lvl2;
            Object n2;
            Iterator j;
            int lvl;
            Object node;
            LevelData levelData = new LevelData(this.getLayoutTarget(), composite);
            levelData._copyGraph = this.copyComposite(composite);
            this.breakCycles(levelData._copyGraph, this._local);
            this.computeLevels(levelData);
            Iterator i = this._local.nodes(levelData._copyGraph);
            while (i.hasNext()) {
                node = i.next();
                lvl = this.getLevel(node);
                j = GraphUtilities.inNodes(node, this._local);
                while (j.hasNext()) {
                    n2 = j.next();
                    lvl2 = this.getLevel(n2);
                    this.ASSERT(lvl2 < lvl, "Level order error " + node + ", " + n2);
                }
            }
            this.ASSERT(LayoutUtilities.checkContainment(levelData._copyGraph, this._local), "Inconsistent post-computeLevels");
            this.addDummies(levelData);
            i = this._local.nodes(levelData._copyGraph);
            while (i.hasNext()) {
                node = i.next();
                lvl = this.getLevel(node);
                j = GraphUtilities.inNodes(node, this._local);
                while (j.hasNext()) {
                    n2 = j.next();
                    lvl2 = this.getLevel(n2);
                    this.ASSERT(lvl2 == lvl - 1, "Level equality error " + node + ", " + n2);
                }
            }
            i = this._local.nodes(levelData._copyGraph);
            while (i.hasNext()) {
                node = i.next();
                if (!this.isDummy(node)) continue;
                Iterator outs = this._local.outEdges(node);
                this.ASSERT(outs.hasNext(), "Dummy w/ no out-edges");
                outs.next();
                this.ASSERT(!outs.hasNext(), "Dummy w/ multiple out edges");
                Iterator ins = this._local.inEdges(node);
                this.ASSERT(ins.hasNext(), "Dummy w/ no in edges");
                ins.next();
                this.ASSERT(!ins.hasNext(), "Dummy w/ multiple in edges");
            }
            this.ASSERT(LayoutUtilities.checkContainment(levelData._copyGraph, this._local), "Inconsistent post-addDummies");
            this.makeLevels(levelData);
            for (int i2 = 1; i2 < levelData._levels.length; ++i2) {
                ArrayList nodes = levelData._levels[i2];
                this.ASSERT(nodes.size() != 0, "Empty level " + i2);
            }
            this.ASSERT(LayoutUtilities.checkContainment(levelData._copyGraph, this._local), "Inconsistent post-makeLevels");
            return levelData;
        }
        return null;
    }

    public void applyLayout(LevelData levelData, Object g) {
        this.applyLayout(levelData, g, true);
    }

    public void applyLayout(LevelData levelData, Object g, boolean useDummies) {
        Rectangle2D r = this.getLayoutTarget().getViewport(g);
        this.placeNodes(levelData, r, useDummies);
        this.copyLayout(levelData._origGraph, levelData._copyGraph);
    }

    public void setOrientation(int o) {
        if (o != 0 && o != 1) {
            String err = "Orientation must be either VERTICAL or HORIZONTAL";
            throw new IllegalArgumentException(err);
        }
        this._orientation = o;
    }

    public void setRandomizedPlacement(boolean flag) {
        this._randomizedPlacement = flag;
    }

    private void ASSERT(boolean b, String err) throws RuntimeException {
        if (!b) {
            throw new RuntimeException(err);
        }
    }

    private void breakCycles(Object composite, GraphModel model) {
        boolean hasCycles = true;
        block0: while (hasCycles) {
            hasCycles = false;
            Iterator i = model.nodes(composite);
            while (i.hasNext()) {
                Object root = i.next();
                this.setAllVisited(composite, false);
                if (!this.checkAndBreak(null, root)) continue;
                hasCycles = true;
                continue block0;
            }
        }
    }

    private boolean checkAndBreak(Object edge, Object node) {
        this.ASSERT(node != null, "null tail: " + node);
        if (this.isVisited(node)) {
            this.ASSERT(edge != null, "null incoming edge: " + node);
            Object head = this._local.getHead(edge);
            Object tail = this._local.getTail(edge);
            if (head == tail) {
                this._local.setEdgeHead(this, edge, null);
                this._local.setEdgeTail(this, edge, null);
            } else {
                this._local.setEdgeHead(this, edge, tail);
                this._local.setEdgeTail(this, edge, head);
            }
            return true;
        }
        this.setVisited(node, true);
        Iterator i = this._local.outEdges(node);
        while (i.hasNext()) {
            Object outEdge = i.next();
            Object outNode = this._local.getHead(outEdge);
            this.ASSERT(outNode != null, "null head: " + edge);
            if (!this.checkAndBreak(outEdge, outNode)) continue;
            return true;
        }
        this.setVisited(node, false);
        return false;
    }

    private void addDummies(LevelData levelData) {
        ArrayList<Node> dummies = new ArrayList<Node>();
        Iterator nodes = this._local.nodes(levelData._copyGraph);
        while (nodes.hasNext()) {
            Object to = nodes.next();
            if (this.isDummy(to)) continue;
            Iterator in = this._local.inEdges(to);
            while (in.hasNext()) {
                Object edge = in.next();
                if (this.isDummy(this._local.getTail(edge))) continue;
                while (this.getLevel(to) > this.getLevel(this._local.getTail(edge)) + 1) {
                    LevelInfo dumInfo = new LevelInfo();
                    Node dummy = this._local.createNode(dumInfo);
                    dumInfo.level = this.getLevel(this._local.getTail(edge)) + 1;
                    dummies.add(dummy);
                    this._local.setEdgeHead(this, edge, dummy);
                    edge = this._local.createEdge(null);
                    this._local.setEdgeTail(this, edge, dummy);
                    this._local.setEdgeHead(this, edge, to);
                }
            }
        }
        Iterator i = dummies.iterator();
        while (i.hasNext()) {
            this._local.addNode(this, i.next(), levelData._copyGraph);
        }
    }

    private void makeLevels(LevelData levelData) {
        levelData._maxLevel = -1;
        Object maxNode = null;
        Iterator i = this._local.nodes(levelData._copyGraph);
        while (i.hasNext()) {
            Object node = i.next();
            int level = this.getLevel(node);
            if (level <= levelData._maxLevel) continue;
            levelData._maxLevel = level;
            maxNode = node;
        }
        levelData._levels = new ArrayList[levelData._maxLevel + 1];
        for (int i2 = 0; i2 < levelData._maxLevel + 1; ++i2) {
            levelData._levels[i2] = new ArrayList();
        }
        this.setAllVisited(levelData._copyGraph, false);
        this.initialOrderNodes(levelData, maxNode);
    }

    private void initialOrderNodes(LevelData levelData, Object maxNode) {
        this.addSubGraphReverseDFS(levelData, maxNode);
        Iterator i = this._local.nodes(levelData._copyGraph);
        while (i.hasNext()) {
            Object node = i.next();
            if (this.isVisited(node)) continue;
            this.addSubGraphReverseDFS(levelData, node);
        }
    }

    private void addSubGraphReverseDFS(LevelData levelData, Object node) {
        this.setVisited(node, true);
        Iterator ins = GraphUtilities.inNodes(node, this._local);
        while (ins.hasNext()) {
            Object in = ins.next();
            this.ASSERT(in != null, "NULL found, n = " + node);
            if (this.isVisited(in)) continue;
            this.addSubGraphReverseDFS(levelData, in);
        }
        levelData._levels[this.getLevel(node)].add(node);
    }

    private void placeNodes(LevelData levelData, Rectangle2D vp, boolean useDummies) {
        int nonEmptyLevels = 0;
        ArrayIterator i = new ArrayIterator(levelData._levels);
        while (i.hasNext()) {
            ArrayList nodes = (ArrayList)i.next();
            if (nodes.size() <= 0) continue;
            ++nonEmptyLevels;
        }
        nonEmptyLevels = Math.max(1, nonEmptyLevels);
        if (this.getOrientation() == 0) {
            double ystep = vp.getHeight() / (double)nonEmptyLevels;
            double y = vp.getY() + ystep / 2.0;
            ArrayIterator i2 = new ArrayIterator(levelData._levels);
            while (i2.hasNext()) {
                int levelWidth;
                ArrayList nodes = (ArrayList)i2.next();
                if (useDummies) {
                    levelWidth = nodes.size();
                } else {
                    levelWidth = 0;
                    for (Object n : nodes) {
                        if (this.isDummy(n)) continue;
                        ++levelWidth;
                    }
                }
                double xstep = vp.getWidth() / (double)levelWidth;
                double x = vp.getX() + xstep / 2.0;
                if (nodes.size() == 0) continue;
                for (Object node : nodes) {
                    if (!this.isDummy(node)) {
                        this.placeNode(node, x, y);
                    }
                    x += xstep;
                }
                y += ystep;
            }
        } else {
            double xstep = vp.getWidth() / (double)nonEmptyLevels;
            double x = vp.getX() + xstep / 2.0;
            ArrayIterator i3 = new ArrayIterator(levelData._levels);
            while (i3.hasNext()) {
                int levelWidth;
                ArrayList nodes = (ArrayList)i3.next();
                if (useDummies) {
                    levelWidth = nodes.size();
                } else {
                    levelWidth = 0;
                    for (Object n : nodes) {
                        if (this.isDummy(n)) continue;
                        ++levelWidth;
                    }
                }
                double ystep = vp.getHeight() / (double)levelWidth;
                double y = vp.getY() + ystep / 2.0;
                if (nodes.size() == 0) continue;
                for (Object node : nodes) {
                    if (!this.isDummy(node)) {
                        this.placeNode(node, x, y);
                    }
                    y += ystep;
                }
                x += xstep;
            }
        }
    }

    private void placeNode(Object node, double x, double y) {
        LevelInfo inf = this.getLevelInfo(node);
        if (this._randomizedPlacement) {
            x += Math.random() * 0.25 * inf.width;
            y += Math.random() * 0.25 * inf.height;
        }
        inf.x = x - inf.width / 2.0;
        inf.y = y - inf.height / 2.0;
    }

    private LevelInfo getLevelInfo(Object node) {
        return (LevelInfo)this._local.getSemanticObject(node);
    }

    private int getLevel(Object node) {
        return this.getLevelInfo((Object)node).level;
    }

    private void setLevel(Object node, int l) {
        this.getLevelInfo((Object)node).level = l;
    }

    private int getUsage(Object node) {
        return this.getLevelInfo((Object)node).usage;
    }

    private boolean isDummy(Object node) {
        LevelInfo inf = this.getLevelInfo(node);
        return inf.origNode == null;
    }

    private void setUsage(Object node, int val) {
        this.getLevelInfo((Object)node).usage = val;
    }

    private void topoSort(Object node, ArrayList topo) {
        this.setVisited(node, true);
        Iterator i = GraphUtilities.inNodes(node, this._local);
        while (i.hasNext()) {
            Object n2 = i.next();
            if (this.isVisited(n2)) continue;
            this.topoSort(n2, topo);
        }
        topo.add(node);
    }

    private void makeMeta(LevelData levelData) {
        levelData._meta = this._local.createNode(new LevelInfo());
        Iterator ns = this._local.nodes(levelData._copyGraph);
        while (ns.hasNext()) {
            Object node = ns.next();
            Edge edge = this._local.createEdge(null);
            this._local.setEdgeTail(this, edge, node);
            this._local.setEdgeHead(this, edge, levelData._meta);
        }
        this._local.addNode(this, levelData._meta, levelData._copyGraph);
    }

    private void removeMeta(LevelData levelData) {
        try {
            GraphUtilities.purgeNode(this, levelData._meta, this._local);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
        levelData._meta = null;
    }

    public void setVisited(Object node, boolean val) {
        this.getLevelInfo((Object)node).visited = val;
    }

    public void setAllVisited(Object composite, boolean val) {
        Iterator i = this._local.nodes(composite);
        while (i.hasNext()) {
            this.setVisited(i.next(), val);
        }
    }

    public boolean isVisited(Object node) {
        return this.getLevelInfo((Object)node).visited;
    }

    private void computeLevels(LevelData levelData) {
        this.setAllVisited(levelData._copyGraph, false);
        this.makeMeta(levelData);
        ArrayList topo = new ArrayList();
        this.topoSort(levelData._meta, topo);
        int maxLevel = 0;
        Iterator i = topo.iterator();
        while (i.hasNext()) {
            int level = 0;
            Object node = i.next();
            Iterator ins = GraphUtilities.inNodes(node, this._local);
            while (ins.hasNext()) {
                Object in = ins.next();
                level = Math.max(level, this.getLevel(in) + 1);
            }
            this.setLevel(node, level);
            maxLevel = Math.max(maxLevel, level);
        }
        for (int i2 = topo.size() - 1; i2 >= 0; --i2) {
            Object node = topo.get(i2);
            int usage = maxLevel;
            if (!this._local.outEdges(node).hasNext()) {
                usage = this.getLevel(node);
            }
            Iterator outs = GraphUtilities.outNodes(node, this._local);
            while (outs.hasNext()) {
                Object out = outs.next();
                usage = Math.min(usage, this.getUsage(out) - 1);
            }
            this.setUsage(node, usage);
        }
        for (Object node : topo) {
            this.setLevel(node, this.getUsage(node));
        }
        this.removeMeta(levelData);
    }

    public static class LevelInfo {
        public Object origNode = null;
        public double barycenter;
        public int level = -1;
        public int usage = Integer.MAX_VALUE;
        public double x;
        public double y;
        public double width;
        public double height;
        public boolean visited = false;
    }

    public class LevelData {
        protected LayoutTarget _target;
        protected Object _origGraph;
        protected Object _copyGraph;
        protected int _maxLevel = -1;
        protected ArrayList[] _levels = null;
        protected Object _meta = null;

        public LevelData(LayoutTarget t, Object composite) {
            this._target = t;
            this._origGraph = composite;
        }

        public int getLevelCount() {
            return this._levels.length;
        }

        public int getMaxLevelWidth(boolean withDummy) {
            int max = -1;
            if (withDummy) {
                for (int i = 0; i < this.getLevelCount(); ++i) {
                    ArrayList list = this._levels[i];
                    if (list.size() <= max) continue;
                    max = list.size();
                }
            } else {
                for (int i = 0; i < this.getLevelCount(); ++i) {
                    ArrayList list = this._levels[i];
                    if (list.size() <= max) continue;
                    int ct = 0;
                    for (Object n : list) {
                        if (LevelLayout.this.isDummy(n)) continue;
                        ++ct;
                    }
                    max = Math.max(ct, max);
                }
            }
            return max;
        }
    }
}

