/*
 * Decompiled with CFR 0.152.
 */
package diva.canvas.connector;

import diva.canvas.Site;
import diva.canvas.connector.ArcConnector;
import diva.canvas.connector.ArcManipulator;
import diva.canvas.connector.ConnectorEvent;
import diva.canvas.connector.ConnectorInteractor;
import diva.canvas.event.LayerEvent;
import java.awt.geom.Point2D;

public class ArcInteractor
extends ConnectorInteractor {
    public ArcInteractor(ArcManipulator m) {
        super(m);
    }

    protected void fireConnectorEvent(int id) {
        ArcConnector connector = (ArcConnector)this.getConnector();
        Site site = this.getHandle().getSite();
        int end = site == connector.getTailSite() ? 22 : (site == connector.getMidpointSite() ? 24 : 21);
        ConnectorEvent event = new ConnectorEvent(id, connector.getLayer(), this.getTarget(), connector, end);
        this._notifyConnectorListeners(event, id);
    }

    public void translate(LayerEvent e, double dx, double dy) {
        ArcConnector connector = (ArcConnector)this.getConnector();
        Site site = this.getHandle().getSite();
        if (site != connector.getMidpointSite()) {
            super.translate(e, dx, dy);
        } else {
            double limit;
            double targetX = this.getX() + dx;
            double targetY = this.getY() + dy;
            Point2D mid = connector.getArcMidpoint();
            double newdx = targetX - mid.getX();
            double newdy = targetY - mid.getY();
            if (newdx > 0.0 && dx < 0.0 || newdx < 0.0 && dx > 0.0) {
                newdx = 0.0;
            }
            if (newdy > 0.0 && dy < 0.0 || newdy < 0.0 && dy > 0.0) {
                newdy = 0.0;
            }
            if (newdx > (limit = 25.0)) {
                newdx = limit;
            } else if (newdx < -limit) {
                newdx = -limit;
            }
            if (newdy > limit) {
                newdy = limit;
            } else if (newdy < -limit) {
                newdy = -limit;
            }
            connector.translateMidpoint(newdx, newdy);
            connector.reroute();
        }
        this.fireConnectorEvent(12);
    }
}

