/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MultiXML {
    private int verbose = 1;
    private String destdir;
    private String in;
    private String stylesheet;
    private Map params = new HashMap();
    static final /* synthetic */ boolean $assertionsDisabled;

    public static void main(String[] args) throws IOException, TransformerException, SAXException, ParserConfigurationException {
        MultiXML worker = new MultiXML();
        String usage = "MultiXML [-verbose] [-style sheet] [-param name=value ...] infile outdir";
        try {
            ArrayList<String> argv = new ArrayList<String>(Arrays.asList(args));
            while (((String)argv.get(0)).startsWith("-")) {
                String arg = (String)argv.get(0);
                if (arg.equals("-verbose")) {
                    argv.remove(0);
                    worker.setVerbose(2);
                    continue;
                }
                if (arg.equals("-style")) {
                    argv.remove(0);
                    worker.setStylesheet((String)argv.remove(0));
                    continue;
                }
                if (arg.equals("-param")) {
                    argv.remove(0);
                    String setting = (String)argv.remove(0);
                    int epos = setting.indexOf("=");
                    String name = setting.substring(0, epos);
                    String value = setting.substring(epos + 1);
                    worker.getParams().put(name, value);
                    continue;
                }
                if (arg.equals("-h")) {
                    System.out.println(usage);
                    System.exit(0);
                    continue;
                }
                throw new IllegalArgumentException();
            }
            worker.setIn((String)argv.remove(0));
            worker.setDestdir((String)argv.remove(0));
            if (argv.size() != 0) {
                throw new IllegalArgumentException();
            }
        }
        catch (RuntimeException e) {
            System.err.println(usage);
            System.exit(1);
        }
        worker.run();
        System.exit(0);
    }

    public void setVerbose(int verbose) {
        this.verbose = verbose;
    }

    public void setDestdir(String destdir) {
        this.destdir = destdir;
    }

    public void setIn(String in) {
        this.in = in;
    }

    public void setStylesheet(String stylesheet) {
        this.stylesheet = stylesheet;
    }

    public Map getParams() {
        return this.params;
    }

    public void run() throws IOException, TransformerException, SAXException, ParserConfigurationException {
        Document doc;
        DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        this.log(1, "Parsing document " + (this.in == null ? " on standard input " : this.in));
        Document document = doc = this.in == null || this.in.equals("-") ? docBuilder.parse(System.in) : docBuilder.parse(this.in);
        if (this.stylesheet != null) {
            StreamSource ssrc = new StreamSource(this.stylesheet);
            Transformer styler = TransformerFactory.newInstance().newTransformer(ssrc);
            Iterator it = this.params.keySet().iterator();
            while (it.hasNext()) {
                String name = (String)it.next();
                Object value = this.params.get(name);
                styler.setParameter(name, value);
            }
            DOMSource xsrc = new DOMSource(doc);
            DOMResult xres = new DOMResult();
            this.log(1, "Transforming with stylesheet " + this.stylesheet);
            styler.transform(xsrc, xres);
            doc = (Document)xres.getNode();
        }
        File outDir = new File(this.destdir);
        outDir.mkdir();
        NodeList nl = doc.getDocumentElement().getElementsByTagName("filesection");
        this.log(1, "Writing " + nl.getLength() + " files to " + outDir);
        for (int i = 0; i < nl.getLength(); ++i) {
            Element el = (Element)nl.item(i);
            if (!$assertionsDisabled && !el.getTagName().equals("filesection")) {
                throw new AssertionError();
            }
            File file = new File(outDir, el.getAttribute("file"));
            String pubid = el.hasAttribute("doctype-public") ? el.getAttribute("doctype-public") : null;
            String sysid = el.hasAttribute("doctype-system") ? el.getAttribute("doctype-system") : null;
            String indent = el.hasAttribute("indent") ? el.getAttribute("indent") : null;
            String method = el.hasAttribute("method") ? el.getAttribute("method") : null;
            Transformer trans = TransformerFactory.newInstance().newTransformer();
            if (pubid != null) {
                trans.setOutputProperty("doctype-public", pubid);
            }
            if (sysid != null) {
                trans.setOutputProperty("doctype-system", sysid);
            }
            if (indent != null) {
                trans.setOutputProperty("indent", indent);
            }
            if (method != null) {
                trans.setOutputProperty("method", method);
            }
            this.log(2, "Output file " + file);
            FileOutputStream out = new FileOutputStream(file);
            StreamResult xres = new StreamResult(out);
            for (Node child = el.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (!(child instanceof Element)) continue;
                trans.transform(new DOMSource(child), xres);
            }
            ((OutputStream)out).close();
        }
    }

    private void log(int level, String line) {
        if (this.verbose >= level) {
            System.out.println(line);
        }
    }

    static {
        $assertionsDisabled = !MultiXML.class.desiredAssertionStatus();
    }
}

