/*
 * Decompiled with CFR 0.152.
 */
package org.la4j.decomposition;

import org.la4j.Matrix;
import org.la4j.decomposition.MatrixDecompositor;
import org.la4j.decomposition.RawLUDecompositor;

public class LUDecompositor
extends RawLUDecompositor
implements MatrixDecompositor {
    public LUDecompositor(Matrix matrix) {
        super(matrix);
    }

    @Override
    public Matrix[] decompose() {
        Matrix[] lup = super.decompose();
        Matrix lu = lup[0];
        Matrix p = lup[1];
        Matrix l = this.matrix.blankOfShape(lu.rows(), lu.columns());
        for (int i = 0; i < l.rows(); ++i) {
            for (int j = 0; j <= i; ++j) {
                if (i > j) {
                    l.set(i, j, lu.get(i, j));
                    continue;
                }
                l.set(i, j, 1.0);
            }
        }
        Matrix u = this.matrix.blankOfShape(lu.columns(), lu.columns());
        for (int i = 0; i < u.rows(); ++i) {
            for (int j = i; j < u.columns(); ++j) {
                u.set(i, j, lu.get(i, j));
            }
        }
        return new Matrix[]{l, u, p};
    }
}

