/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.logging.client;

import com.cosylab.logging.engine.log.LogTypeHelper;
import javax.swing.ImageIcon;

public enum EntryTypeIcon {
    TRACE_ICON(LogTypeHelper.TRACE, "/trace.gif"),
    DELOUSE_ICON(LogTypeHelper.DELOUSE, "/delouse.png"),
    DEBUG_ICON(LogTypeHelper.DEBUG, "/debug.gif"),
    INFO_ICON(LogTypeHelper.INFO, "/information.gif"),
    NOTICE_ICON(LogTypeHelper.NOTICE, "/notice.gif"),
    WARNING_ICON(LogTypeHelper.WARNING, "/warning.gif"),
    ERROR_ICON(LogTypeHelper.ERROR, "/error.gif"),
    CRITICAL_ICON(LogTypeHelper.CRITICAL, "/critical.gif"),
    ALERT_ICON(LogTypeHelper.ALERT, "/alert.gif"),
    EMERGENCY_ICON(LogTypeHelper.EMERGENCY, "/emergency.gif"),
    OFF_ICON(LogTypeHelper.OFF, "/off.png");

    public final ImageIcon icon;
    public final LogTypeHelper logLevel;

    private EntryTypeIcon(LogTypeHelper logLevel, String fileName) {
        if (logLevel == null) {
            throw new IllegalArgumentException("The log type can't be null");
        }
        if (fileName == null || fileName.isEmpty()) {
            throw new IllegalArgumentException("Invalid file name");
        }
        this.icon = new ImageIcon(((Object)((Object)this)).getClass().getResource(fileName));
        this.logLevel = logLevel;
    }

    public static int getIconsVSize() {
        int vDim = 0;
        for (EntryTypeIcon typeIcon : EntryTypeIcon.values()) {
            int height;
            int n = height = typeIcon.icon == null ? 10 : typeIcon.icon.getIconHeight();
            if (height <= vDim) continue;
            vDim = height;
        }
        return vDim;
    }

    public static ImageIcon getIcon(LogTypeHelper logLevel) {
        if (logLevel == null) {
            throw new IllegalArgumentException("The log type can't be null");
        }
        for (EntryTypeIcon typeIcon : EntryTypeIcon.values()) {
            if (typeIcon.logLevel != logLevel) continue;
            return typeIcon.icon;
        }
        throw new IllegalStateException("No icon found for type " + logLevel);
    }
}

