/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.components;

import alma.ACS.OffShoot;
import alma.ACS.OffShootOperations;
import alma.JavaContainerError.wrappers.AcsJContainerServicesEx;
import alma.acs.container.ContainerServices;
import alma.acs.exceptions.AcsJException;
import alma.acs.nc.AcsEventPublisher;
import alma.archive.components.CursorImpl;
import alma.archive.database.helpers.DBConfiguration;
import alma.archive.database.interfaces.DBCursor;
import alma.archive.database.interfaces.InternalIF;
import alma.archive.database.interfaces.InternalIFFactory;
import alma.archive.database.interfaces.SchemaManager;
import alma.archive.exceptions.ArchiveException;
import alma.archive.exceptions.ModuleCriticalException;
import alma.archive.exceptions.access.EntityDirtyException;
import alma.archive.exceptions.access.PermissionDeniedException;
import alma.archive.exceptions.general.ArchiveCommunicationException;
import alma.archive.exceptions.general.DatabaseException;
import alma.archive.exceptions.general.EntityDoesNotExistException;
import alma.archive.exceptions.general.HistoryInconsistencyException;
import alma.archive.exceptions.general.NotImplementedException;
import alma.archive.exceptions.general.UnknownSchemaException;
import alma.archive.exceptions.syntax.MalformedURIException;
import alma.archive.exceptions.syntax.MalformedXMLException;
import alma.archive.exceptions.user.UserDoesNotExistException;
import alma.archive.helpers.InternalCommunicationHelper;
import alma.archive.wrappers.ArchiveTimeStamp;
import alma.archive.wrappers.DocumentData;
import alma.archive.wrappers.Permissions;
import alma.archive.wrappers.ResultStruct;
import alma.xmlentity.XmlEntityStruct;
import alma.xmlstore.ArchiveInternalError;
import alma.xmlstore.Cursor;
import alma.xmlstore.CursorHelper;
import alma.xmlstore.OperationalOperations;
import alma.xmlstore.OperationalPackage.DirtyEntity;
import alma.xmlstore.OperationalPackage.IllegalEntity;
import alma.xmlstore.OperationalPackage.MalformedURI;
import alma.xmlstore.OperationalPackage.NotFound;
import alma.xmlstore.OperationalPackage.NotImplemented;
import alma.xmlstore.OperationalPackage.NotYetThere;
import alma.xmlstore.OperationalPackage.StatusStruct;
import alma.xmlstore.OperationalPackage.TimestampInconsistency;
import alma.xmlstore.XmlStoreNotificationEvent;
import alma.xmlstore.operationType;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.omg.CORBA.Object;
import org.omg.PortableServer.Servant;

public class OperationalImpl
implements OffShootOperations,
OperationalOperations {
    private Logger logger;
    private String user;
    private ContainerServices containerServices;
    protected final AcsEventPublisher<XmlStoreNotificationEvent> xmlNotifyChannel;
    private InternalIF internal;
    private SchemaManager schemaManager;
    protected String myName;
    private String m_password = "almabtrieb";

    private void connect() {
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(this.getClass().getName(), "connect");
        }
        if (this.internal == null) {
            try {
                this.internal = InternalIFFactory.getInternalIF((Logger)this.logger);
                this.logger.log(Level.INFO, "ARCHIVE: Connected to the Internal Interface");
                this.schemaManager = this.internal.getSchemaManager(this.user);
                this.logger.log(Level.INFO, "ARCHIVE: Connected to the Schema Manager");
            }
            catch (DatabaseException e) {
                this.logger.log(Level.SEVERE, e.getMessage());
            }
            catch (PermissionDeniedException e) {
                this.logger.log(Level.SEVERE, e.getMessage());
            }
            catch (UserDoesNotExistException e) {
                this.logger.log(Level.SEVERE, e.getMessage());
            }
            catch (ModuleCriticalException e) {
                this.logger.log(Level.SEVERE, e.getCause().getMessage());
                this.notifyMaster(e);
            }
            catch (ArchiveException e) {
                this.logger.log(Level.SEVERE, e.getMessage());
            }
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(this.getClass().getName(), "connect");
        }
    }

    public OperationalImpl(String user, Logger logger, ContainerServices containerServices, AcsEventPublisher<XmlStoreNotificationEvent> channel) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "constructor1");
        }
        this.myName = containerServices == null ? "corba-less" : containerServices.getName();
        this.logger = logger;
        this.user = user;
        this.containerServices = containerServices;
        this.xmlNotifyChannel = channel;
        this.connect();
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "constructor1");
        }
    }

    public OperationalImpl(String user, Logger logger) {
        this(user, logger, null, null);
    }

    public void close(String password) throws ArchiveInternalError {
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(this.getClass().getName(), "close");
        }
        if (!password.equals(this.m_password)) {
            throw new ArchiveInternalError("Uncorrect password provided to call this method.");
        }
        if (this.internal != null) {
            try {
                this.schemaManager.close();
                this.internal.close();
                this.logger.log(Level.INFO, "ARCHIVE: Disconnected from the internal interface");
            }
            catch (ModuleCriticalException e) {
                this.notifyMaster(e);
                this.logger.log(Level.INFO, "ARCHIVE: Unable to disconnect from the internal interface");
                throw new ArchiveInternalError(e.toString());
            }
            catch (ArchiveException e) {
                this.logger.log(Level.INFO, "ARCHIVE: Unable to disconnect from the internal interface");
                throw new ArchiveInternalError(e.toString());
            }
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(this.getClass().getName(), "close");
        }
    }

    private void checkEntityValid(XmlEntityStruct entity) throws IllegalEntity {
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(this.getClass().getName(), "checkEntityValid");
        }
        if (entity.entityId == null || entity.entityId.trim().isEmpty()) {
            this.logger.severe("ARCHIVE: Entity did not have a valid ID");
            throw new IllegalEntity("Entity ID must have a value");
        }
        SAXBuilder builder = new SAXBuilder();
        builder.setIgnoringElementContentWhitespace(true);
        try {
            Document document = builder.build((Reader)new StringReader(entity.xmlString));
        }
        catch (JDOMException e) {
            this.logger.severe("ARCHIVE: Entity URI: " + entity.entityId + " Does not contain vaild XML");
            throw new IllegalEntity(e.getMessage());
        }
        catch (IOException e) {
            this.logger.severe("ARCHIVE: Entity URI: " + entity.entityId + " Does not contain vaild XML");
            throw new IllegalEntity(e.getMessage());
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(this.getClass().getName(), "checkEntityValid");
        }
    }

    public void store(XmlEntityStruct entity) throws IllegalEntity, ArchiveInternalError {
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(this.getClass().getName(), "store");
        }
        try {
            URI uri = new URI(entity.entityId);
            Permissions permissions = new Permissions();
            URI schema = this.schemaManager.getSchemaURI(entity.entityTypeName);
            this.logger.log(Level.FINER, "ARCHIVE: Schema Location for Type " + entity.entityTypeName + " is " + schema.toASCIIString());
            this.internal.store(uri, entity.xmlString, schema, entity.entityTypeName, this.user, permissions, this.user, true);
            this.logger.log(Level.FINER, "ARCHIVE: Stored: " + entity.entityId + " successfully");
            this.publishEvent(uri, operationType.STORED_XML);
        }
        catch (URISyntaxException e) {
            throw new IllegalEntity(e.getMessage());
        }
        catch (UnknownSchemaException e) {
            throw new IllegalEntity(e.getMessage());
        }
        catch (ModuleCriticalException e) {
            this.logger.severe("Could not store entity " + entity.entityId);
            this.notifyMaster(e);
            throw new ArchiveInternalError(e.getCause().toString());
        }
        catch (ArchiveException e) {
            this.logger.severe("Could not store entity " + entity.entityId);
            this.logger.severe("Exception while store: " + String.valueOf((java.lang.Object)e));
            throw new ArchiveInternalError(e.getMessage());
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(this.getClass().getName(), "store");
        }
    }

    private void publishEvent(URI uri, operationType eventType) {
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(this.getClass().getName(), "publishEvent");
        }
        XmlStoreNotificationEvent successEvent = new XmlStoreNotificationEvent(uri.toString(), eventType);
        if (this.xmlNotifyChannel != null) {
            try {
                this.xmlNotifyChannel.publishEvent((java.lang.Object)successEvent);
            }
            catch (AcsJException e1) {
                this.logger.warning("ARCHIVE: Could not publish on NC xmlstore.");
            }
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(this.getClass().getName(), "publishEvent");
        }
    }

    public void update(XmlEntityStruct entity) throws IllegalEntity, ArchiveInternalError, TimestampInconsistency {
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(this.getClass().getName(), "update");
        }
        this.update(entity, false);
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(this.getClass().getName(), "update");
        }
    }

    public void forceUpdate(XmlEntityStruct entity) throws IllegalEntity, ArchiveInternalError, TimestampInconsistency {
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(this.getClass().getName(), "forceUpdate");
        }
        this.update(entity, true);
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(this.getClass().getName(), "forceUpdate");
        }
    }

    private void update(XmlEntityStruct entity, boolean force) throws IllegalEntity, ArchiveInternalError, TimestampInconsistency {
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(this.getClass().getName(), "update", new java.lang.Object[]{entity.entityId, entity.entityTypeName, entity.schemaVersion, entity.timeStamp});
        }
        this.checkEntityValid(entity);
        try {
            URI uri = new URI(entity.entityId);
            URI schema = this.schemaManager.getSchemaURI(entity.entityTypeName);
            ArchiveTimeStamp timeStamp = new ArchiveTimeStamp(entity.timeStamp);
            this.logger.log(Level.FINER, "ARCHIVE: Schema Location for Type " + entity.entityTypeName + " is " + schema.toASCIIString());
            this.internal.clean(uri, this.user);
            try {
                this.internal.update(uri, timeStamp, entity.xmlString, schema, force, this.user);
            }
            catch (HistoryInconsistencyException e) {
                throw new TimestampInconsistency(e.toString());
            }
            this.logger.log(Level.FINER, "ARCHIVE: Updated: " + entity.entityId + " successfully");
            this.publishEvent(uri, operationType.UPDATED_XML);
        }
        catch (URISyntaxException e) {
            throw new IllegalEntity(e.getMessage());
        }
        catch (UnknownSchemaException e) {
            throw new IllegalEntity(e.getMessage());
        }
        catch (ModuleCriticalException e) {
            this.logger.severe("Exception while update: " + String.valueOf((java.lang.Object)e));
            this.notifyMaster(e);
            throw new ArchiveInternalError(e.getCause().toString());
        }
        catch (ArchiveException e) {
            this.logger.severe("Exception while update: " + String.valueOf((java.lang.Object)e));
            throw new ArchiveInternalError(e.toString());
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(this.getClass().getName(), "update");
        }
    }

    public void updateXML(String uid, String schema, String newChild) throws ArchiveInternalError, IllegalEntity, NotYetThere, MalformedURI {
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(this.getClass().getName(), "updateXml");
        }
        try {
            this.internal.updateXML(new URI(uid), schema, newChild);
        }
        catch (MalformedXMLException e) {
            throw new IllegalEntity(e.toString());
        }
        catch (ModuleCriticalException e) {
            this.notifyMaster(e);
            throw new ArchiveInternalError(e.getCause().toString());
        }
        catch (EntityDoesNotExistException e) {
            throw new NotYetThere(uid);
        }
        catch (URISyntaxException e) {
            throw new MalformedURI(uid);
        }
        catch (ArchiveException e) {
            throw new ArchiveInternalError(e.toString());
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(this.getClass().getName(), "updateXml");
        }
    }

    private XmlEntityStruct retrieve(String uid, boolean update) throws MalformedURI, ArchiveInternalError, NotFound, DirtyEntity {
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(this.getClass().getName(), "retrieve");
        }
        XmlEntityStruct result = null;
        try {
            URI uri = new URI(uid);
            DocumentData dd = this.internal.status(uri, this.user);
            result = new XmlEntityStruct();
            result.xmlString = this.internal.get(uri, this.schemaManager.getSchemaName(dd.getSchema()), this.user);
            result.entityId = uid;
            result.entityTypeName = this.schemaManager.getSchemaName(dd.getSchema());
            result.schemaVersion = Integer.toString(this.schemaManager.getSchemaVersion(dd.getSchema()));
            result.timeStamp = dd.getTimestamp().toISOString();
            if (update) {
                this.internal.dirty(uri, this.user);
            }
        }
        catch (EntityDirtyException e) {
            throw new DirtyEntity(e.getMessage());
        }
        catch (URISyntaxException e) {
            throw new MalformedURI(e.getMessage());
        }
        catch (EntityDoesNotExistException e) {
            throw new NotFound("Document " + uid + " not found in Archive.");
        }
        catch (MalformedURIException e) {
            throw new MalformedURI(e.getMessage());
        }
        catch (ModuleCriticalException e) {
            this.notifyMaster(e);
            throw new ArchiveInternalError(e.getCause().toString());
        }
        catch (ArchiveException e) {
            throw new ArchiveInternalError(e.toString());
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(this.getClass().getName(), "retrieve");
        }
        return result;
    }

    private void notifyMaster(ModuleCriticalException e) {
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(this.getClass().getName(), "notifyMaster");
        }
        try {
            InternalCommunicationHelper.notifyMaster(e, this.containerServices, this.myName, this.logger);
        }
        catch (ArchiveCommunicationException e1) {
            this.logger.warning("ARCHIVE: Cannot connect to Archive subsystem master");
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(this.getClass().getName(), "notifyMaster");
        }
    }

    public XmlEntityStruct retrieve(String uri) throws MalformedURI, ArchiveInternalError, NotFound, DirtyEntity {
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(this.getClass().getName(), "retrieve");
        }
        XmlEntityStruct xmlEntityStruct = this.retrieve(uri, false);
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(this.getClass().getName(), "retrieve");
        }
        return xmlEntityStruct;
    }

    public boolean exists(String uid) throws DirtyEntity, MalformedURI, NotFound, ArchiveInternalError {
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(this.getClass().getName(), "exists");
        }
        boolean exists = false;
        try {
            this.retrieve(uid, false);
            exists = true;
        }
        catch (DirtyEntity e) {
            exists = true;
        }
        catch (NotFound notFound) {
            // empty catch block
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(this.getClass().getName(), "exists");
        }
        return exists;
    }

    public XmlEntityStruct updateRetrieve(String uri) throws MalformedURI, ArchiveInternalError, NotFound, DirtyEntity {
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(this.getClass().getName(), "updateRetrieve");
        }
        XmlEntityStruct xmlEntityStruct = this.retrieve(uri, true);
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(this.getClass().getName(), "updateRetrieve");
        }
        return xmlEntityStruct;
    }

    public XmlEntityStruct retrieveDirty(String uid) throws MalformedURI, ArchiveInternalError, NotFound {
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(this.getClass().getName(), "retrieveDirty");
        }
        XmlEntityStruct result = new XmlEntityStruct();
        try {
            URI uri = new URI(uid);
            DocumentData dd = this.internal.status(uri, this.user);
            result.xmlString = this.internal.get(uri, this.user);
            result.entityId = uid;
            result.entityTypeName = this.schemaManager.getSchemaName(dd.getSchema());
            result.schemaVersion = Integer.toString(this.schemaManager.getSchemaVersion(dd.getSchema()));
            result.timeStamp = dd.getTimestamp().toISOString();
        }
        catch (URISyntaxException e) {
            throw new MalformedURI(e.getMessage());
        }
        catch (EntityDoesNotExistException e) {
            throw new NotFound(e.getMessage());
        }
        catch (MalformedURIException e) {
            throw new MalformedURI(e.getMessage());
        }
        catch (ModuleCriticalException e) {
            this.notifyMaster(e);
            throw new ArchiveInternalError(e.getCause().toString());
        }
        catch (ArchiveException e) {
            throw new ArchiveInternalError(e.toString());
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(this.getClass().getName(), "retrieveDirty");
        }
        return result;
    }

    public String[] retrieveFragment(String uri, String id) throws MalformedURI, ArchiveInternalError, NotFound, DirtyEntity {
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(this.getClass().getName(), "retrieveFragment");
        }
        this.logger.log(Level.FINER, "ARCHIVE: Getting URI: " + uri);
        String[] fragment = new String[]{};
        try {
            String xpath = "//*[@id=\"" + id + "\"]";
            Map namespaces = this.schemaManager.getSchemaNamespaces(new URI(uri));
            fragment = this.internal.get(new URI(uri), xpath, namespaces, this.user);
        }
        catch (EntityDirtyException e) {
            throw new DirtyEntity(e.getMessage());
        }
        catch (URISyntaxException e) {
            throw new MalformedURI(e.getMessage());
        }
        catch (EntityDoesNotExistException e) {
            throw new NotFound(e.getMessage());
        }
        catch (MalformedURIException e) {
            throw new MalformedURI(e.getMessage());
        }
        catch (ModuleCriticalException e) {
            this.notifyMaster(e);
            throw new ArchiveInternalError(e.getCause().toString());
        }
        catch (ArchiveException e) {
            throw new ArchiveInternalError(e.toString());
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(this.getClass().getName(), "retrieveFragment");
        }
        return fragment;
    }

    public void delete(String uriString) throws MalformedURI, NotFound, ArchiveInternalError {
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(this.getClass().getName(), "delete");
        }
        try {
            URI uri = new URI(uriString);
            this.internal.delete(uri, this.user);
            this.publishEvent(uri, operationType.DELETED_XML);
        }
        catch (URISyntaxException e) {
            throw new MalformedURI(e.getMessage());
        }
        catch (EntityDoesNotExistException e) {
            throw new NotFound(e.getMessage());
        }
        catch (ModuleCriticalException e) {
            this.notifyMaster(e);
            throw new ArchiveInternalError(e.getCause().toString());
        }
        catch (ArchiveException e) {
            throw new ArchiveInternalError(e.toString());
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(this.getClass().getName(), "delete");
        }
    }

    public void undelete(String uri) throws ArchiveInternalError, NotFound, MalformedURI {
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(this.getClass().getName(), "undelete");
        }
        try {
            this.internal.undelete(new URI(uri), this.user);
        }
        catch (URISyntaxException e) {
            throw new MalformedURI(e.getMessage());
        }
        catch (ArchiveException e) {
            throw new ArchiveInternalError(e.toString());
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(this.getClass().getName(), "undelete");
        }
    }

    public StatusStruct status(String uri) throws MalformedURI, NotFound, ArchiveInternalError {
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(this.getClass().getName(), "status");
        }
        StatusStruct result = new StatusStruct();
        try {
            DocumentData dd = this.internal.status(new URI(uri), this.user);
            result.deleted = dd.getDeleted();
            result.dirty = dd.getDirty();
            result.locks = dd.getAdmin();
            result.owner = dd.getOwner();
            result.schema = dd.getSchema().toASCIIString();
            result.hidden = dd.getHidden();
        }
        catch (URISyntaxException e) {
            throw new MalformedURI(e.getMessage());
        }
        catch (ModuleCriticalException e) {
            this.notifyMaster(e);
            throw new ArchiveInternalError(e.getCause().toString());
        }
        catch (ArchiveException e) {
            throw new ArchiveInternalError(e.toString());
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(this.getClass().getName(), "status");
        }
        return result;
    }

    public String[] queryRecent(String schema, String timestamp) throws ArchiveInternalError {
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(this.getClass().getName(), "queryRecent");
        }
        String[] out = new String[]{};
        try {
            URI[] result = null;
            try {
                result = this.internal.queryRecent(new ArchiveTimeStamp(timestamp), schema, this.user);
            }
            catch (NullPointerException e) {
                throw new ArchiveInternalError("Unknown schema: " + schema);
            }
            if (result == null) {
                throw new ArchiveInternalError("Unknown schema: " + schema);
            }
            out = new String[result.length];
            for (int i = 0; i < result.length; ++i) {
                out[i] = result[i].toString();
            }
        }
        catch (ModuleCriticalException e) {
            this.notifyMaster(e);
            throw new ArchiveInternalError(e.getCause().toString());
        }
        catch (ArchiveException e) {
            throw new ArchiveInternalError(e.toString());
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(this.getClass().getName(), "queryRecent");
        }
        return out;
    }

    public Cursor query(String query, String schema) throws ArchiveInternalError {
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(this.getClass().getName(), "query", new java.lang.Object[]{query, schema});
        }
        Cursor cursor = this.genericQuery(query, schema, false);
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(this.getClass().getName(), "query");
        }
        return cursor;
    }

    private Cursor genericQuery(String query, String schema, boolean dirtyRead) throws ArchiveInternalError {
        Cursor cursor = null;
        try {
            URI schemaURI = this.schemaManager.getSchemaURI(schema);
            Map namespaces = this.schemaManager.getSchemaNamespaces(schemaURI);
            this.logger.log(Level.FINER, "ARCHIVE: Schema location for " + schema + " is " + schemaURI.toASCIIString());
            DBCursor internalCursor = this.internal.query(query, schema, namespaces, dirtyRead, this.user);
            CursorImpl externalCursor = new CursorImpl(internalCursor, this.containerServices);
            this.logger.log(Level.FINE, "ARCHIVE: Returning cursor to user");
            OffShoot offshoot = this.containerServices.activateOffShoot((Servant)externalCursor);
            cursor = CursorHelper.narrow((Object)offshoot);
        }
        catch (AcsJContainerServicesEx e) {
            this.logger.log(Level.INFO, "Query failed.", e);
            throw new ArchiveInternalError(e.getContextInfo());
        }
        catch (ModuleCriticalException e) {
            this.notifyMaster(e);
            throw new ArchiveInternalError(e.getCause().toString());
        }
        catch (ArchiveException e) {
            this.logger.log(Level.INFO, "Query failed.", e);
            throw new ArchiveInternalError(e.toString());
        }
        return cursor;
    }

    public Cursor queryContent(String query, String schema) throws ArchiveInternalError {
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(this.getClass().getName(), "queryContent", new java.lang.Object[]{query, schema});
        }
        Cursor cursor = this.genericQuery(query, schema, false);
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(this.getClass().getName(), "queryContent");
        }
        return cursor;
    }

    public Cursor queryDirty(String query, String schema) throws ArchiveInternalError {
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(this.getClass().getName(), "queryDirty", new java.lang.Object[]{query, schema});
        }
        Cursor cursor = this.genericQuery(query, schema, true);
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(this.getClass().getName(), "queryDirty");
        }
        return cursor;
    }

    public String[] queryUIDs(String query, String schema) throws ArchiveInternalError {
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(this.getClass().getName(), "queryUIDs", new java.lang.Object[]{query, schema});
        }
        String[] uids = this.genericQueryUIDs(query, schema, false);
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(this.getClass().getName(), "queryUIDs");
        }
        return uids;
    }

    private String[] genericQueryUIDs(String query, String schema, boolean readDirty) throws ArchiveInternalError {
        try {
            URI schemaURI = this.schemaManager.getSchemaURI(schema);
            Map namespaces = this.schemaManager.getSchemaNamespaces(schemaURI);
            DBCursor internalCursor = this.internal.query(query, schema, namespaces, readDirty, this.user);
            Vector<String> vector = new Vector<String>();
            while (internalCursor.hasNext()) {
                ResultStruct res = internalCursor.next();
                vector.add(res.getUri().toASCIIString());
            }
            ListIterator iter = vector.listIterator();
            String[] result = new String[vector.size()];
            while (iter.hasNext()) {
                result[iter.nextIndex()] = (String)iter.next();
            }
            return result;
        }
        catch (ModuleCriticalException e) {
            this.notifyMaster(e);
            throw new ArchiveInternalError(e.getCause().toString());
        }
        catch (ArchiveException e) {
            throw new ArchiveInternalError(e.toString());
        }
    }

    public String[] queryUIDsDirty(String query, String schema) throws ArchiveInternalError {
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(this.getClass().getName(), "queryUIDsDirty", new java.lang.Object[]{query, schema});
        }
        String[] uids = this.genericQueryUIDs(query, schema, true);
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(this.getClass().getName(), "queryUIDsDirty");
        }
        return uids;
    }

    public String[][] querySubmissions(short fieldID, String searchString, boolean caseSensitive, boolean containsQuery, String PiCoIfilter) throws ArchiveInternalError, NotImplemented {
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(this.getClass().getName(), "querySubmissions", new java.lang.Object[]{fieldID, searchString, caseSensitive, containsQuery, PiCoIfilter});
        }
        try {
            ArrayList res = this.internal.querySubmissions(fieldID, searchString, caseSensitive, containsQuery, PiCoIfilter);
            String[][] stringArray = (String[][])res.toArray((T[])new String[0][0]);
            return stringArray;
        }
        catch (NotImplementedException e) {
            throw new NotImplemented(e.toString());
        }
        catch (ModuleCriticalException e) {
            this.notifyMaster(e);
            throw new ArchiveInternalError(e.getCause().toString());
        }
        catch (ArchiveException e) {
            throw new ArchiveInternalError(e.toString());
        }
        finally {
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.exiting(this.getClass().getName(), "querySubmissions");
            }
        }
    }

    public void addElement(String uid, String schema, String xPath, String xmlElement) throws ArchiveInternalError, IllegalEntity, MalformedURI, NotYetThere {
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(this.getClass().getName(), "addElement");
        }
        try {
            this.internal.addElement(new URI(uid), schema, xPath, xmlElement, this.user);
        }
        catch (URISyntaxException e) {
            throw new IllegalEntity(uid);
        }
        catch (EntityDoesNotExistException e) {
            throw new NotYetThere(uid);
        }
        catch (ModuleCriticalException e) {
            this.notifyMaster(e);
            throw new ArchiveInternalError(e.getCause().toString());
        }
        catch (PermissionDeniedException e) {
            throw new ArchiveInternalError("Permission denied to modify document " + uid);
        }
        catch (ArchiveException e) {
            throw new ArchiveInternalError(e.toString());
        }
        finally {
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.exiting(this.getClass().getName(), "addElement");
            }
        }
    }

    public void updateElement(String uid, String schema, String xPath, String xmlElement) throws ArchiveInternalError, IllegalEntity, MalformedURI, NotYetThere {
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(this.getClass().getName(), "updateElement");
        }
        try {
            this.internal.updateElement(new URI(uid), schema, xPath, xmlElement, this.user);
        }
        catch (URISyntaxException e) {
            throw new IllegalEntity(uid);
        }
        catch (EntityDoesNotExistException e) {
            throw new NotYetThere(uid);
        }
        catch (ModuleCriticalException e) {
            this.notifyMaster(e);
            throw new ArchiveInternalError(e.getCause().toString());
        }
        catch (PermissionDeniedException e) {
            throw new ArchiveInternalError("Permission denied to modify document " + uid);
        }
        catch (ArchiveException e) {
            throw new ArchiveInternalError(e.toString());
        }
        finally {
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.exiting(this.getClass().getName(), "updateElement");
            }
        }
    }

    public void deleteElement(String uid, String schema, String xPath) throws ArchiveInternalError, IllegalEntity, MalformedURI, NotYetThere {
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(this.getClass().getName(), "deleteElement", new java.lang.Object[]{uid, schema, xPath});
        }
        try {
            this.internal.deleteElement(new URI(uid), schema, xPath, this.user);
        }
        catch (URISyntaxException e) {
            throw new IllegalEntity(uid);
        }
        catch (EntityDoesNotExistException e) {
            throw new NotYetThere(uid);
        }
        catch (ModuleCriticalException e) {
            this.notifyMaster(e);
            throw new ArchiveInternalError(e.getCause().toString());
        }
        catch (PermissionDeniedException e) {
            throw new ArchiveInternalError("Permission denied to modify document " + uid);
        }
        catch (ArchiveException e) {
            throw new ArchiveInternalError(e.toString());
        }
        finally {
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.exiting(this.getClass().getName(), "deleteElement");
            }
        }
    }

    @Deprecated
    public int getConnectionNumber() throws ArchiveInternalError {
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(this.getClass().getName(), "getConnectionNumber");
        }
        try {
            if (!DBConfiguration.instance((Logger)this.logger).dbBackend.equalsIgnoreCase("oracle")) {
                int n = 0;
                return n;
            }
            int n = -1;
            return n;
        }
        catch (DatabaseException e) {
            throw new ArchiveInternalError(e.toString());
        }
        finally {
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.exiting(this.getClass().getName(), "getConnectionNumber");
            }
        }
    }
}

