/*
 * Decompiled with CFR 0.152.
 */
package jsky.catalog.skycat;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import jsky.catalog.BasicQueryArgs;
import jsky.catalog.Catalog;
import jsky.catalog.CatalogDirectory;
import jsky.catalog.FieldDesc;
import jsky.catalog.MemoryCatalog;
import jsky.catalog.PlotableCatalog;
import jsky.catalog.QueryArgs;
import jsky.catalog.QueryResult;
import jsky.catalog.RangeSearchCondition;
import jsky.catalog.RowCoordinates;
import jsky.catalog.SearchCondition;
import jsky.catalog.TablePlotSymbol;
import jsky.catalog.TableQueryResult;
import jsky.catalog.URLQueryResult;
import jsky.catalog.skycat.SkycatConfigEntry;
import jsky.catalog.skycat.SkycatConfigFile;
import jsky.catalog.skycat.SkycatTable;
import jsky.coords.CoordinateRadius;
import jsky.coords.Coordinates;
import jsky.coords.ImageCoords;
import jsky.coords.WorldCoords;
import jsky.util.StringUtil;
import jsky.util.gui.ProgressBarFilterInputStream;
import jsky.util.gui.ProgressPanel;

public class SkycatCatalog
implements PlotableCatalog {
    private static final Logger LOG = Logger.getLogger(SkycatCatalog.class.getName());
    private SkycatConfigEntry _entry;
    private ProgressPanel _progressPanel;
    private SkycatTable _table;
    private int _queryCount = 0;

    public SkycatCatalog(SkycatConfigEntry entry) {
        this._entry = entry;
    }

    public SkycatCatalog(SkycatConfigEntry entry, SkycatTable table) {
        this(entry);
        this._table = table;
    }

    public SkycatCatalog(SkycatTable table) {
        this(table.getConfigEntry());
        this._table = table;
        this._table.setCatalog(this);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public void setName(String name) {
        this._entry.setName(name);
    }

    @Override
    public String getName() {
        return this._entry.getName();
    }

    public SkycatConfigEntry getConfigEntry() {
        return this._entry;
    }

    public int getQueryCount() {
        return this._queryCount;
    }

    public void setConfigEntry(SkycatConfigEntry entry) {
        this._entry = entry;
    }

    public SkycatTable getTable() {
        return this._table;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public String getId() {
        return this._entry.getShortName();
    }

    @Override
    public String getTitle() {
        return this._entry.getName();
    }

    @Override
    public String getDescription() {
        return this._entry.getProperty("copyright");
    }

    @Override
    public URL getDocURL() {
        return this._entry.getDocURL();
    }

    @Override
    public int getNumParams() {
        return this._entry.getNumParams();
    }

    @Override
    public FieldDesc getParamDesc(int i) {
        return this._entry.getParamDesc(i);
    }

    @Override
    public FieldDesc getParamDesc(String name) {
        return this._entry.getParamDesc(name);
    }

    @Override
    public int getNumSymbols() {
        return this._entry.getNumSymbols();
    }

    @Override
    public TablePlotSymbol getSymbolDesc(int i) {
        return this._entry.getSymbolDesc(i);
    }

    @Override
    public TablePlotSymbol[] getSymbols() {
        return this._entry.getSymbols();
    }

    @Override
    public void setSymbols(TablePlotSymbol[] symbols) {
        this._entry.setSymbols(symbols);
    }

    @Override
    public void setSymbolsEdited(boolean edited) {
        this._entry.setSymbolsEdited(edited);
    }

    @Override
    public boolean isSymbolsEdited() {
        return this._entry.isSymbolsEdited();
    }

    @Override
    public void saveSymbolConfig() {
        SkycatConfigFile.getConfigFile().save();
    }

    public String getShortName() {
        return this._entry.getShortName();
    }

    public boolean isWCS() {
        return this._entry.getRowCoordinates().isWCS();
    }

    public double getEquinox() {
        return this._entry.getRowCoordinates().getEquinox();
    }

    public boolean isPix() {
        return this._entry.getRowCoordinates().isPix();
    }

    @Override
    public boolean isLocal() {
        return this._entry.getServType().equals("local");
    }

    @Override
    public boolean isImageServer() {
        return this._entry.getServType().equals("imagesvr");
    }

    @Override
    public String getType() {
        return this._entry.getServType();
    }

    @Override
    public void setParent(CatalogDirectory catDir) {
        this._entry.setConfigFile(catDir);
    }

    @Override
    public CatalogDirectory getParent() {
        return this._entry.getConfigFile();
    }

    @Override
    public Catalog[] getPath() {
        CatalogDirectory parent = this.getParent();
        if (parent == null) {
            return null;
        }
        return parent.getPath(this);
    }

    @Override
    public QueryResult query(QueryArgs queryArgs) throws IOException {
        ++this._queryCount;
        String servType = this._entry.getServType();
        if (servType.equals("local")) {
            return this._queryLocalCatalog(queryArgs);
        }
        if (servType.equals("catalog") || servType.equals("archive") || servType.equals("namesvr")) {
            return this._queryCatalog(queryArgs);
        }
        if (servType.equals("imagesvr")) {
            return this._queryImageServer(queryArgs);
        }
        if (servType.equals("directory")) {
            return this._queryCatalogDirectory();
        }
        throw new RuntimeException("Query not supported for this catalog type: " + servType);
    }

    private QueryResult _queryLocalCatalog(QueryArgs queryArgs) throws IOException {
        QueryResult result;
        String urlStr = this._entry.getURL(0);
        if (urlStr != null && urlStr.startsWith("java://")) {
            return this._queryJavaCatalog(queryArgs);
        }
        SearchCondition[] sc = queryArgs.getConditions();
        this._setQueryRegion(queryArgs, sc);
        this._setMaxRows(queryArgs, sc);
        SkycatTable cat = this._table;
        if (cat == null) {
            if (urlStr != null) {
                try {
                    cat = new SkycatTable(this, urlStr);
                }
                catch (Exception e) {
                    InputStream is;
                    try {
                        is = Thread.currentThread().getContextClassLoader().getResourceAsStream(urlStr);
                    }
                    catch (Exception ee) {
                        ee.printStackTrace();
                        return null;
                    }
                    cat = new SkycatTable(this, is);
                }
            } else {
                return null;
            }
        }
        if ((result = cat.query(queryArgs)) instanceof SkycatTable) {
            ((SkycatTable)result).setCatalog(this);
        }
        return result;
    }

    protected ProgressPanel _getProgressPanel(String title) {
        if (this._progressPanel == null) {
            this._progressPanel = ProgressPanel.makeProgressPanel((String)title);
        } else {
            this._progressPanel.setTitle(title);
        }
        return this._progressPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueryResult _queryCatalog(QueryArgs queryArgs) throws IOException {
        int n = this._entry.getNumURLs();
        for (int i = 0; i < n; ++i) {
            SkycatTable skycatTable;
            block10: {
                URLConnection connection;
                ProgressBarFilterInputStream in;
                block8: {
                    URLQueryResult uRLQueryResult;
                    block9: {
                        String urlStr = this._entry.getURL(i);
                        if (urlStr == null) continue;
                        if ((urlStr = this._getQueryUrl(urlStr, queryArgs)).startsWith(File.separator) || urlStr.length() > 2 && urlStr.charAt(1) == ':') {
                            CatalogDirectory catDir = this._entry.getConfigFile();
                            if (catDir != null && !catDir.isLocal()) {
                                throw new RuntimeException("Invalid catalog URL: " + urlStr + ", in remote config file");
                            }
                            Process process = Runtime.getRuntime().exec(urlStr);
                            InputStream stdout = process.getInputStream();
                            SkycatTable cat = new SkycatTable(this, stdout, queryArgs);
                            cat.setConfigEntry(this._entry);
                            return cat;
                        }
                        if (urlStr.startsWith("java://")) {
                            return this._queryJavaCatalog(queryArgs);
                        }
                        urlStr = StringUtil.replace((String)urlStr, (String)" ", (String)"%20");
                        URL queryUrl = new URL(urlStr);
                        this._progressPanel = this._getProgressPanel("Downloading query results");
                        in = null;
                        try {
                            connection = this._progressPanel.openConnection(queryUrl);
                            String contentType = connection.getContentType();
                            if (contentType == null || !contentType.equals("text/html")) break block8;
                            uRLQueryResult = new URLQueryResult(queryUrl);
                            if (in == null) break block9;
                        }
                        catch (Throwable throwable) {
                            if (in != null) {
                                this._progressPanel.stopLoggingInputStream(in);
                            }
                            this._progressPanel.stop();
                            throw throwable;
                        }
                        this._progressPanel.stopLoggingInputStream(in);
                    }
                    this._progressPanel.stop();
                    return uRLQueryResult;
                }
                InputStream ins = connection.getInputStream();
                in = this._progressPanel.getLoggedInputStream(ins, connection.getContentLength());
                SkycatTable cat = new SkycatTable(this, (InputStream)in, queryArgs);
                cat.setConfigEntry(this._entry);
                skycatTable = cat;
                if (in == null) break block10;
                this._progressPanel.stopLoggingInputStream(in);
            }
            this._progressPanel.stop();
            return skycatTable;
        }
        throw new RuntimeException("No query URL was specified in the config file.");
    }

    private QueryResult _queryImageServer(QueryArgs queryArgs) throws IOException {
        int n = this._entry.getNumURLs();
        for (int i = 0; i < n; ++i) {
            String urlStr = this._entry.getURL(i);
            if (urlStr == null) continue;
            if ((urlStr = this._getQueryUrl(urlStr, queryArgs)).startsWith(File.separator)) {
                throw new RuntimeException("Local commands not supported for image server (yet)");
            }
            return new URLQueryResult(new URL(urlStr));
        }
        throw new RuntimeException("No query URL was specified in the config file.");
    }

    private QueryResult _queryCatalogDirectory() {
        int numURLs = this._entry.getNumURLs();
        for (int i = 0; i < numURLs; ++i) {
            try {
                return new URLQueryResult(new URL(this._entry.getURL(0)));
            }
            catch (Exception e) {
                if (i != numURLs - 1) continue;
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException("No URL was specified in the config file.");
    }

    private QueryResult _queryJavaCatalog(QueryArgs queryArgs) throws IOException {
        QueryResult result = null;
        SearchCondition[] sc = queryArgs.getConditions();
        this._setQueryRegion(queryArgs, sc);
        this._setMaxRows(queryArgs, sc);
        String urlStr = this._entry.getURL(0);
        if (urlStr != null) {
            urlStr = this._getQueryUrl(urlStr, queryArgs);
            StringTokenizer token = new StringTokenizer(urlStr.substring(7), "?\t");
            String className = token.nextToken();
            try {
                Class<?> catalogClass = Class.forName(className);
                Catalog catalog = (Catalog)catalogClass.newInstance();
                result = catalog.query(queryArgs);
                if (result instanceof MemoryCatalog && !(result instanceof SkycatTable)) {
                    MemoryCatalog mcat = (MemoryCatalog)result;
                    result = new SkycatTable(this._entry, mcat.getDataVector(), mcat.getFields());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new RuntimeException(e);
            }
        }
        if (result instanceof SkycatTable) {
            ((SkycatTable)result).setCatalog(this);
        }
        return result;
    }

    private String _getQueryUrl(String urlStr, QueryArgs queryArgs) throws IOException {
        if (this._entry.getNumParams() == 0) {
            return urlStr;
        }
        int n = urlStr.length();
        StringBuffer buf = new StringBuffer(n * 2);
        boolean urlHasId = false;
        boolean urlHasRaDec = false;
        boolean urlHasXy = false;
        SearchCondition[] sc = queryArgs.getConditions();
        this._setQueryRegion(queryArgs, sc);
        this._setMaxRows(queryArgs, sc);
        int c = 0;
        while (c < n) {
            if (urlStr.charAt(c) == '%') {
                String id;
                FieldDesc p;
                SearchCondition aSc;
                int n2;
                if (urlStr.charAt(++c) == '%') {
                    buf.append('%');
                    ++c;
                    continue;
                }
                if (urlStr.startsWith("id", c)) {
                    String id2 = queryArgs.getId();
                    if (id2 == null) {
                        id2 = queryArgs.getParamValueAsString("id", null);
                    }
                    if (id2 != null) {
                        buf.append(id2);
                    }
                    c += 2;
                    urlHasId = true;
                    continue;
                }
                if (urlStr.startsWith("ra", c)) {
                    CoordinateRadius region = queryArgs.getRegion();
                    if (region != null) {
                        WorldCoords pos = (WorldCoords)region.getCenterPosition();
                        buf.append(pos.getRA().toString());
                    }
                    c += 2;
                    urlHasRaDec = true;
                    continue;
                }
                if (urlStr.startsWith("dec", c)) {
                    CoordinateRadius region = queryArgs.getRegion();
                    if (region != null) {
                        WorldCoords pos = (WorldCoords)region.getCenterPosition();
                        buf.append(pos.getDec().toString());
                    }
                    c += 3;
                    urlHasRaDec = true;
                    continue;
                }
                if (urlStr.charAt(c) == 'x') {
                    CoordinateRadius region = queryArgs.getRegion();
                    if (region != null) {
                        ImageCoords pos = (ImageCoords)region.getCenterPosition();
                        buf.append(pos.getX());
                    }
                    ++c;
                    urlHasXy = true;
                    continue;
                }
                if (urlStr.charAt(c) == 'y') {
                    CoordinateRadius region = queryArgs.getRegion();
                    if (region != null) {
                        ImageCoords pos = (ImageCoords)region.getCenterPosition();
                        buf.append(pos.getY());
                    }
                    ++c;
                    urlHasXy = true;
                    continue;
                }
                if (urlStr.startsWith("r1", c)) {
                    CoordinateRadius region = queryArgs.getRegion();
                    if (region != null && (region.getMinRadius() != 0.0 || region.getMaxRadius() != 0.0)) {
                        buf.append(region.getMinRadius());
                    }
                    c += 2;
                    continue;
                }
                if (urlStr.startsWith("r2", c)) {
                    CoordinateRadius region = queryArgs.getRegion();
                    if (region != null && (region.getMinRadius() != 0.0 || region.getMaxRadius() != 0.0)) {
                        buf.append(region.getMaxRadius());
                    }
                    c += 2;
                    continue;
                }
                if (urlStr.charAt(c) == 'w') {
                    if (sc != null && sc.length > 0) {
                        SearchCondition[] region = sc;
                        int pos = region.length;
                        for (n2 = 0; n2 < pos; ++n2) {
                            SearchCondition aSc2 = region[n2];
                            if (!aSc2.getName().equals("Width")) continue;
                            buf.append(aSc2.getValueAsString());
                            break;
                        }
                    }
                    ++c;
                    continue;
                }
                if (urlStr.charAt(c) == 'h') {
                    if (sc != null && sc.length > 0) {
                        SearchCondition[] region = sc;
                        int pos = region.length;
                        for (n2 = 0; n2 < pos; ++n2) {
                            SearchCondition aSc3 = region[n2];
                            if (!aSc3.getName().equals("Height")) continue;
                            buf.append(aSc3.getValueAsString());
                            break;
                        }
                    }
                    ++c;
                    continue;
                }
                if (urlStr.startsWith("m1", c)) {
                    if (sc != null && sc.length > 0) {
                        String m1 = "0";
                        SearchCondition[] pos = sc;
                        n2 = pos.length;
                        for (int i = 0; i < n2; ++i) {
                            aSc = pos[i];
                            p = aSc.getFieldDesc();
                            if (!p.isMin() || (id = p.getId()) == null || !id.equalsIgnoreCase("mag")) continue;
                            m1 = aSc.getValueAsString();
                            break;
                        }
                        buf.append(m1);
                    }
                    c += 2;
                    continue;
                }
                if (urlStr.startsWith("m2", c)) {
                    if (sc != null && sc.length > 0) {
                        String m2 = "0";
                        SearchCondition[] pos = sc;
                        n2 = pos.length;
                        for (int i = 0; i < n2; ++i) {
                            aSc = pos[i];
                            p = aSc.getFieldDesc();
                            if (!p.isMax() || (id = p.getId()) == null || !id.equalsIgnoreCase("mag")) continue;
                            m2 = aSc.getValueAsString();
                            break;
                        }
                        buf.append(m2);
                    }
                    c += 2;
                    continue;
                }
                if (urlStr.charAt(c) == 'n') {
                    if (queryArgs.getMaxRows() > 0) {
                        buf.append(queryArgs.getMaxRows());
                    }
                    ++c;
                    continue;
                }
                if (urlStr.startsWith("cond", c)) {
                    if (sc != null && sc.length > 0) {
                        for (int i = 0; i < sc.length; ++i) {
                            String name = sc[i].getName();
                            if (this.isWCS() && (name.equalsIgnoreCase("Object") || name.equalsIgnoreCase("RA") || name.equalsIgnoreCase("Dec") || name.equalsIgnoreCase("Equinox")) || this.isPix() && (name.equalsIgnoreCase("X") || name.equalsIgnoreCase("Y")) || name.equalsIgnoreCase("Min Radius") || name.equalsIgnoreCase("Max Radius") || name.equalsIgnoreCase("Width") || name.equalsIgnoreCase("Height") || name.equalsIgnoreCase("Max Objects")) continue;
                            buf.append(sc[i].toString());
                            if (sc.length - i <= 1) continue;
                            buf.append('&');
                        }
                    }
                    c += 4;
                    continue;
                }
                if (!urlStr.startsWith("mime-type", c)) continue;
                buf.append("application/x-fits");
                c += 9;
                continue;
            }
            buf.append(urlStr.charAt(c++));
        }
        if (!urlHasId && queryArgs.getId() != null && queryArgs.getId().length() != 0) {
            throw new RuntimeException(this._entry.getName() + " does not support search by id");
        }
        if (queryArgs.getRegion() != null) {
            if (queryArgs.getRegion().getCenterPosition() instanceof WorldCoords && !urlHasRaDec) {
                throw new RuntimeException(this._entry.getName() + " does not support search by World Coordinates");
            }
            if (queryArgs.getRegion().getCenterPosition() instanceof ImageCoords && !urlHasXy) {
                throw new RuntimeException(this._entry.getName() + " does not support search by image coordinates");
            }
        }
        LOG.info("URL = " + buf.toString());
        return buf.toString();
    }

    private double _getEquinox(QueryArgs queryArgs) {
        String equinoxStr = (String)queryArgs.getParamValue("Equinox");
        double equinox = 2000.0;
        if (equinoxStr != null && equinoxStr.endsWith("1950")) {
            equinox = 1950.0;
        }
        return equinox;
    }

    protected void _setQueryRegion(QueryArgs queryArgs, SearchCondition[] sc) throws IOException {
        Double r2;
        Double r1;
        block14: {
            block12: {
                block13: {
                    if (queryArgs.getRegion() != null || sc == null || sc.length == 0) {
                        return;
                    }
                    r1 = (Double)queryArgs.getParamValue("Min Radius");
                    r2 = (Double)queryArgs.getParamValue("Max Radius");
                    if (r1 == null && r2 == null) break block12;
                    if (r1 == null) break block13;
                    if (r2 != null) break block14;
                    r2 = r1;
                    r1 = 0.0;
                    break block14;
                }
                r1 = 0.0;
                break block14;
            }
            for (SearchCondition aSc : sc) {
                String name = aSc.getName();
                if (!name.equalsIgnoreCase("radius") || !(aSc instanceof RangeSearchCondition)) continue;
                RangeSearchCondition rsc = (RangeSearchCondition)aSc;
                r1 = (Double)rsc.getMinVal();
                r2 = (Double)rsc.getMaxVal();
                break;
            }
        }
        if (r1 == null && r2 == null) {
            r1 = 0.0;
            r2 = 10.0;
        }
        if (r1 == null) {
            r1 = 0.0;
        }
        if (this.isWCS()) {
            WorldCoords wcs;
            String objectName = (String)queryArgs.getParamValue("Object");
            if (objectName == null || objectName.length() == 0) {
                String raStr = (String)queryArgs.getParamValue("RA");
                String decStr = (String)queryArgs.getParamValue("Dec");
                if (raStr == null || decStr == null) {
                    return;
                }
                double equinox = this._getEquinox(queryArgs);
                wcs = new WorldCoords(raStr, decStr, equinox, true);
            } else {
                Object o = queryArgs.getParamValue("Name Server");
                if (!(o instanceof Catalog)) {
                    throw new RuntimeException("No name server was specified");
                }
                wcs = this._resolveObjectName(objectName, (Catalog)o);
                queryArgs.setParamValue("RA", (Object)wcs.getRA().toString());
                queryArgs.setParamValue("Dec", (Object)wcs.getDec().toString());
                queryArgs.setParamValue("Equinox", (Object)"2000");
            }
            queryArgs.setRegion(new CoordinateRadius((Coordinates)wcs, r1.doubleValue(), r2.doubleValue()));
        } else if (this.isPix()) {
            Double x = (Double)queryArgs.getParamValue("X");
            Double y = (Double)queryArgs.getParamValue("Y");
            if (x == null || y == null) {
                return;
            }
            ImageCoords ic = new ImageCoords((double)x.intValue(), (double)y.intValue());
            queryArgs.setRegion(new CoordinateRadius((Coordinates)ic, r1.doubleValue(), r2.doubleValue()));
        }
    }

    private WorldCoords _resolveObjectName(String objectName, Catalog cat) throws IOException {
        Coordinates coords;
        BasicQueryArgs queryArgs = new BasicQueryArgs(cat);
        queryArgs.setId(objectName);
        QueryResult r = cat.query(queryArgs);
        if (r instanceof TableQueryResult && (coords = ((TableQueryResult)r).getCoordinates(0)) instanceof WorldCoords) {
            return (WorldCoords)coords;
        }
        throw new RuntimeException("Unexpected result from " + cat.toString());
    }

    protected void _setMaxRows(QueryArgs queryArgs, SearchCondition[] sc) {
        if (queryArgs.getMaxRows() != 0 || sc == null || sc.length == 0) {
            return;
        }
        Integer maxObjects = (Integer)queryArgs.getParamValue("Max Objects");
        if (maxObjects != null) {
            queryArgs.setMaxRows(maxObjects);
        }
    }

    @Override
    public Catalog reload() {
        return this;
    }

    @Override
    public void setRegionArgs(QueryArgs queryArgs, CoordinateRadius region) {
        Coordinates coords = region.getCenterPosition();
        RowCoordinates rowCoordinates = this._entry.getRowCoordinates();
        String equinoxStr = (String)queryArgs.getParamValue("Equinox");
        double equinox = this._getEquinox(queryArgs);
        if (rowCoordinates.isWCS()) {
            WorldCoords pos = (WorldCoords)coords;
            String[] radec = pos.format(equinox);
            queryArgs.setParamValue("RA", (Object)radec[0]);
            queryArgs.setParamValue("Dec", (Object)radec[1]);
            queryArgs.setParamValue("Equinox", (Object)equinoxStr);
            queryArgs.setParamValue("Min Radius", region.getMinRadius());
            queryArgs.setParamValue("Max Radius", region.getMaxRadius());
            queryArgs.setParamValue("Width", region.getWidth());
            queryArgs.setParamValue("Height", region.getHeight());
        } else if (rowCoordinates.isPix()) {
            ImageCoords pos = (ImageCoords)coords;
            queryArgs.setParamValue("X", pos.getX());
            queryArgs.setParamValue("Y", pos.getY());
            queryArgs.setParamValue("Min Radius", region.getMinRadius());
            queryArgs.setParamValue("Max Radius", region.getMaxRadius());
            queryArgs.setParamValue("Width", region.getWidth());
            queryArgs.setParamValue("Height", region.getHeight());
        }
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("usage: java -classpath ... SkycatCatalog catalogName");
            System.exit(1);
        }
        String catalogName = args[0];
        SkycatConfigFile configFile = SkycatConfigFile.getConfigFile();
        Catalog cat = configFile.getCatalog(catalogName);
        if (cat == null) {
            System.out.println("Can't find entry for catalog: " + catalogName);
            System.exit(1);
        }
        try {
            BasicQueryArgs q1 = new BasicQueryArgs(cat);
            q1.setId("GSC0285601186");
            QueryResult r1 = cat.query(q1);
            System.out.println("result: " + r1);
            System.out.println("");
            System.out.println("test query: at center position/radius: ");
            BasicQueryArgs q2 = new BasicQueryArgs(cat);
            q2.setRegion(new CoordinateRadius((Coordinates)new WorldCoords("03:19:44.44", "+41:30:58.21"), 2.0));
            QueryResult r2 = cat.query(q2);
            System.out.println("result: " + r2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

