/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.filter.ProcessingStep;
import uk.ac.starlink.ttools.mode.ProcessingMode;
import uk.ac.starlink.ttools.task.FilterParameter;
import uk.ac.starlink.ttools.task.InputTableSpec;
import uk.ac.starlink.ttools.task.InputTablesParameter;
import uk.ac.starlink.ttools.task.MapperTask;
import uk.ac.starlink.ttools.task.TableMapper;
import uk.ac.starlink.ttools.task.TableProducer;

public class HomogeneousMapperTask
extends MapperTask {
    public InputTablesParameter inTablesParam_;
    public FilterParameter inFilterParam_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.task");

    public HomogeneousMapperTask(String purpose, ProcessingMode outMode, boolean useOutFilter, TableMapper mapper, boolean useInFilter) {
        super(purpose, outMode, useOutFilter, mapper);
        ArrayList<Object> paramList = new ArrayList<Object>();
        this.inTablesParam_ = new InputTablesParameter("in");
        this.inTablesParam_.setUsage("<table> [<table> ...]");
        this.inTablesParam_.setPrompt("Location of input table(s)");
        paramList.add((Object)this.inTablesParam_);
        paramList.add(this.inTablesParam_.getFormatParameter());
        paramList.add(this.inTablesParam_.getStreamParameter());
        if (useInFilter) {
            this.inFilterParam_ = new FilterParameter("icmd");
            this.inFilterParam_.setPrompt("Processing command(s) for each input table");
            this.inFilterParam_.setDescription(new String[]{"<p>Commands which will operate on each of the input tables,", "before any other processing takes place.", "</p>", this.inFilterParam_.getDescription()});
            paramList.add(this.inFilterParam_);
        } else {
            this.inFilterParam_ = null;
        }
        this.getParameterList().addAll(0, paramList);
    }

    public InputTableSpec[] getInputSpecs(Environment env) throws TaskException {
        ProcessingStep[] steps = this.inFilterParam_ == null ? null : this.inFilterParam_.stepsValue(env);
        String[] locs = this.inTablesParam_.stringsValue(env);
        TableProducer[] tprods = this.inTablesParam_.tablesValue(env);
        final int nIn = tprods.length;
        InputTableSpec[] specs = new InputTableSpec[nIn];
        for (int i = 0; i < nIn; ++i) {
            final int index = i;
            final TableProducer tprod = tprods[i];
            specs[i] = new InputTableSpec(locs[i], steps){

                public StarTable getInputTable() throws TaskException {
                    try {
                        logger_.config("Input table " + (index + 1) + "/" + nIn);
                        return tprod.getTable();
                    }
                    catch (IOException e) {
                        throw new TaskException(e.getMessage(), (Throwable)e);
                    }
                }
            };
        }
        return specs;
    }
}

