/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.build;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.Type;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.StringTokenizer;
import uk.ac.starlink.ttools.build.Heading;
import uk.ac.starlink.ttools.build.MemberDoclet;

public class HtmlDoclet
extends MemberDoclet {
    private Writer out_;
    private File baseDir_;
    static /* synthetic */ Class class$uk$ac$starlink$ttools$build$Heading;

    public static boolean start(RootDoc root) throws IOException {
        return new HtmlDoclet(root).process();
    }

    public static int optionLength(String option) {
        if (option.equals("-d")) {
            return 2;
        }
        if (option.equals("-headings")) {
            return 1;
        }
        return 0;
    }

    public HtmlDoclet(RootDoc root) throws IOException {
        super(root);
        String[][] options = root.options();
        boolean headings = false;
        for (int i = 0; i < options.length; ++i) {
            if (options[i][0].equals("-d")) {
                this.baseDir_ = new File(options[i][1]);
            }
            if (!options[i][0].equals("-headings")) continue;
            headings = true;
        }
        if (this.baseDir_ == null) {
            this.baseDir_ = new File(".");
        }
        if (headings) {
            this.writeHeadingFiles();
        }
    }

    protected void startClass(ClassDoc clazz) throws IOException {
        this.startOutFile(HtmlDoclet.classDocFile(this.baseDir_, clazz));
        this.outHeader("Class", clazz.name());
        this.outDescription(clazz.commentText());
        this.outFooter();
        this.endOutFile();
    }

    protected void endClass() throws IOException {
    }

    protected void startMember(MemberDoc mem, String memType, String memName) throws IOException {
        File file;
        if (mem instanceof FieldDoc) {
            file = HtmlDoclet.fieldDocFile(this.baseDir_, (FieldDoc)mem);
        } else if (mem instanceof MethodDoc) {
            file = HtmlDoclet.methodDocFile(this.baseDir_, (MethodDoc)mem);
        } else {
            throw new AssertionError();
        }
        this.startOutFile(file);
        this.outHeader(memType, memName);
    }

    protected void endMember() throws IOException {
        this.outFooter();
        this.endOutFile();
    }

    protected void outItem(String name, String val) throws IOException {
        this.out(new String[]{"<dl>", "<dt><strong>" + name + ":</strong></dt>", "<dd>" + val + "</dd>", "</dl>"});
    }

    protected void outParameters(Parameter[] params, String[] comments) throws IOException {
        this.out(new String[]{"<dl>", "<dt><strong>Parameters:</strong></dt>", "<dd>", "<dl>"});
        for (int i = 0; i < params.length; ++i) {
            Parameter param = params[i];
            this.out(new String[]{"<dt><strong><font color='blue'><tt>" + param.name() + " </tt></font></strong> " + "<em>(" + HtmlDoclet.typeString(param.type()) + ")</em>" + "</dt>"});
            if (comments[i] == null) continue;
            this.out(new String[]{"<dd>" + comments[i] + "</dd>"});
        }
        this.out("</dl></dd></dl>");
    }

    protected void outReturn(Type rtype, String rdesc) throws IOException {
        if (rdesc != null) {
            this.outItem("Return Value (" + HtmlDoclet.typeString(rtype) + ")", rdesc);
        } else {
            this.outItem("Return Type", HtmlDoclet.typeString(rtype));
        }
    }

    protected void outDescription(String descrip) throws IOException {
        this.out(new String[]{"<dl>", "<dt><strong>Description:</strong></dt>", "<dd>", descrip, "</dd>", "</dl>"});
    }

    protected void outExamples(String[] examples) throws IOException {
        if (examples.length == 1) {
            this.out(new String[]{"<dl>", "<dt><strong>Example:</strong></dt>", "<dd>" + examples[0] + "</dd>", "</dl>"});
        } else if (examples.length > 1) {
            this.out(new String[]{"<dl>", "<dt><strong>Examples:</strong></dt>", "<dd><ul>"});
            for (int i = 0; i < examples.length; ++i) {
                this.out("<li>" + examples[i] + "</li>");
            }
            this.out(new String[]{"</ul></dd>", "</dl>"});
        }
    }

    private static File docFile(File baseDir, ClassDoc clazz, String suffix) {
        return HtmlDoclet.docFile(baseDir, clazz.qualifiedName(), suffix);
    }

    private static File docFile(File baseDir, String className, String suffix) {
        File file = baseDir;
        StringTokenizer st = new StringTokenizer(className, ".");
        while (st.hasMoreTokens()) {
            file = new File(file, st.nextToken());
        }
        return new File(file.getPath() + suffix);
    }

    public static File classDocFile(File baseDir, ClassDoc clazz) {
        return HtmlDoclet.docFile(baseDir, clazz, ".html");
    }

    public static File fieldDocFile(File baseDir, FieldDoc field) {
        return HtmlDoclet.docFile(baseDir, field.containingClass(), "-" + field.name() + ".html");
    }

    public static File methodDocFile(File baseDir, MethodDoc method) {
        StringBuffer mangle = new StringBuffer();
        Parameter[] params = method.parameters();
        for (int i = 0; i < params.length; ++i) {
            mangle.append("-");
            Type type = params[i].type();
            mangle.append(type.typeName());
            String dim = type.dimension();
            if (dim == null) continue;
            mangle.append(dim.replaceAll("\\[\\]", ","));
        }
        return HtmlDoclet.docFile(baseDir, method.containingClass(), "-" + method.name() + mangle.toString() + ".html");
    }

    private void writeHeadingFiles() throws IOException {
        Heading[] headings = Heading.ALL_HEADINGS;
        for (int i = 0; i < headings.length; ++i) {
            Heading heading = headings[i];
            File file = HtmlDoclet.docFile(this.baseDir_, (class$uk$ac$starlink$ttools$build$Heading == null ? HtmlDoclet.class$("uk.ac.starlink.ttools.build.Heading") : class$uk$ac$starlink$ttools$build$Heading).getName(), heading.getDocSuffix());
            this.startOutFile(file);
            this.outHeader("", heading.getUserString());
            this.out(heading.getDescription());
            this.outFooter();
            this.endOutFile();
        }
    }

    private void outHeader(String memType, String memName) throws IOException {
        this.out(new String[]{"<html>", "<head><title>" + memName + "</title></head>", "<body bgcolor='white'>", "<h2>" + memType + " <font color='blue'><tt>" + memName + "</tt></font></h2>"});
    }

    private void outFooter() throws IOException {
        this.out(new String[]{"</body>", "</html>"});
    }

    private void startOutFile(File file) throws IOException {
        File parent = file.getParentFile();
        if (parent != null && !parent.exists() && !parent.mkdirs()) {
            throw new IOException("Can't create directory " + parent);
        }
        this.out_ = new BufferedWriter(new FileWriter(file));
    }

    private void endOutFile() throws IOException {
        this.out_.close();
        this.out_ = null;
    }

    private void out(String[] lines) throws IOException {
        for (int i = 0; i < lines.length; ++i) {
            this.out(lines[i]);
        }
    }

    private void out(String line) throws IOException {
        this.out_.write(line);
        this.out_.write(10);
    }
}

