/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.entityutil;

import alma.acs.entityutil.EntityException;
import alma.acs.entityutil.EntityTFinder;
import alma.entities.commonentity.EntityT;
import alma.xmlentity.XmlEntityStruct;
import java.io.Reader;
import java.io.StringReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.exolab.castor.xml.Unmarshaller;

public class EntityDeserializer {
    private Logger m_logger;
    private static EntityDeserializer s_entityDeserializer;
    private EntityTFinder m_finder;

    public static EntityDeserializer getEntityDeserializer(Logger logger) {
        if (s_entityDeserializer == null) {
            s_entityDeserializer = new EntityDeserializer(logger);
        }
        return s_entityDeserializer;
    }

    private EntityDeserializer(Logger logger) {
        this.m_logger = logger;
        this.m_finder = new EntityTFinder(this.m_logger);
    }

    private Object deserializeEntity(String xmlString, Class entityClass, String timestamp) throws EntityException {
        EntityT entityMeta;
        Object entity;
        if (xmlString == null) {
            throw new EntityException("xmlString was null.");
        }
        if (entityClass == null) {
            throw new EntityException("entityClass was null.");
        }
        if (timestamp == null) {
            timestamp = "";
        }
        try {
            Unmarshaller unmarsh = new Unmarshaller(entityClass);
            unmarsh.setValidation(false);
            unmarsh.setWhitespacePreserve(true);
            entity = unmarsh.unmarshal((Reader)new StringReader(xmlString));
        }
        catch (Exception e) {
            String xmlStringStart = xmlString.substring(0, Math.min(512, xmlString.length()));
            String msg = "Failed to parse xml into entity binding class '" + entityClass.getName() + "'. The xml data was " + xmlStringStart;
            this.m_logger.log(Level.FINER, msg, e);
            throw new EntityException(msg, e);
        }
        if (entity != null && (entityMeta = this.m_finder.extractEntityT(entity)) != null) {
            entityMeta.setTimestamp(timestamp);
        }
        return entity;
    }

    public Object deserializeEntity(XmlEntityStruct xes, Class entityClass) throws EntityException {
        String xml = xes.xmlString;
        String timestamp = xes.timeStamp;
        return this.deserializeEntity(xml, entityClass, timestamp);
    }
}

