/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.component.dynwrapper;

import alma.acs.component.dynwrapper.ComponentInvocationHandler;
import alma.acs.component.dynwrapper.DynWrapperException;
import alma.acs.component.dynwrapper.TypeMapper;
import alma.acs.entityutil.EntityException;
import alma.acs.entityutil.EntityTFinder;
import alma.entities.commonentity.EntityT;
import alma.xmlentity.XmlEntityStruct;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Logger;
import org.exolab.castor.xml.Marshaller;

public class CastorMarshalMapper
extends TypeMapper {
    private EntityTFinder m_entityTFinder;

    public CastorMarshalMapper(Object delegate, Logger logger) {
        super(delegate, logger);
        this.m_entityTFinder = new EntityTFinder(logger);
        this.m_entityTFinder.setVerbose(this.m_verbose);
    }

    @Override
    public boolean canTranslate(Class<?> oldObjClass, Class<?> newObjClass, ComponentInvocationHandler invHandler) {
        boolean canTranslate = true;
        try {
            this.m_entityTFinder.getEntityTMethod(oldObjClass);
            if (!XmlEntityStruct.class.isAssignableFrom(newObjClass)) {
                throw new DynWrapperException();
            }
        }
        catch (Exception ex) {
            canTranslate = false;
        }
        if (this.m_verbose) {
            this.m_logger.finest("can " + (canTranslate ? "" : "not ") + "translate from class '" + oldObjClass.getName() + "' to class '" + newObjClass.getName());
        }
        return canTranslate;
    }

    public Object translate(Object oldObject, Object newObjectTemplate, Class newObjectClass, ComponentInvocationHandler invHandler) throws DynWrapperException {
        EntityT entityMeta;
        if (oldObject == null) {
            return null;
        }
        try {
            entityMeta = this.m_entityTFinder.extractEntityT(oldObject);
        }
        catch (EntityException e) {
            String extractionErrMsg = "failed to extract EntityT object from " + oldObject.getClass().getName();
            throw new DynWrapperException(extractionErrMsg, e);
        }
        if (entityMeta == null) {
            String extractionNullErrMsg = "entity object of type " + oldObject.getClass().getName() + " must have a non-null child assignable to " + EntityT.class.getName() + " to be serialized.";
            throw new DynWrapperException(extractionNullErrMsg);
        }
        XmlEntityStruct entStruct = null;
        if (newObjectTemplate != null) {
            if (!XmlEntityStruct.class.isInstance(newObjectTemplate)) {
                throw new DynWrapperException("invalid template for XmlEntityStruct object");
            }
            entStruct = (XmlEntityStruct)newObjectTemplate;
        } else {
            entStruct = new XmlEntityStruct();
        }
        entStruct.entityId = entityMeta.getEntityId();
        entStruct.entityTypeName = entityMeta.getEntityTypeName();
        entStruct.schemaVersion = entityMeta.getSchemaVersion() != null ? entityMeta.getSchemaVersion() : "";
        try {
            StringWriter wr = new StringWriter();
            Marshaller marsh = new Marshaller((Writer)wr);
            marsh.setValidation(false);
            marsh.marshal(oldObject);
            entStruct.xmlString = wr.toString();
        }
        catch (Exception e) {
            String msg = "failed to marshal entity object with id='" + entityMeta.getEntityId() + "' using the Castor Marshaller without validation.";
            throw new DynWrapperException(msg);
        }
        if (this.m_verbose) {
            this.m_logger.finer("successfully translated from '" + oldObject.getClass().getName() + "' to '" + entStruct.getClass().getName() + "'.");
        }
        return entStruct;
    }
}

