/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.arch.io;

import ca.nrc.cadc.arch.io.BadMagicNumberException;
import ca.nrc.cadc.arch.io.hcompress.HCompressInputStream;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;

public class FitsFilterInputStream
extends InputStream {
    private int FITS_BLOCK_SIZE = 2880;
    private InputStream istream;
    private boolean foundEnd = false;
    private boolean eof = false;
    private int avail = 0;
    private int start = 0;
    private byte[] singleton = new byte[1];
    private byte[] buf = new byte[this.FITS_BLOCK_SIZE];
    private boolean isCompressed = true;
    private int imgPix = 0;
    private int bpp = 16;
    private Object img = null;
    private boolean debug = false;

    public FitsFilterInputStream(BufferedInputStream bufferedInputStream) throws IOException {
        this.istream = bufferedInputStream;
        this.checkGZIP();
    }

    public int read() throws IOException {
        int n = this.read(this.singleton, 0, 1);
        if (n == 1) {
            return this.singleton[0];
        }
        return -1;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.eof) {
            return -1;
        }
        this.readBlock();
        int n3 = n2 < this.avail ? n2 : this.avail;
        System.arraycopy(this.buf, this.start, byArray, n, n3);
        this.start += n3;
        this.avail -= n3;
        return n3;
    }

    private void checkGZIP() throws IOException {
        this.msg("checkGZIP");
        this.istream.mark(2);
        try {
            GZIPInputStream gZIPInputStream = new GZIPInputStream(this.istream);
            this.msg("checkGZIP: success");
            this.istream = new BufferedInputStream(gZIPInputStream, 2880);
        }
        catch (IOException iOException) {
            this.istream.reset();
            this.msg("checkGZIP: failure");
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void readBlock() throws IOException {
        if (this.avail > 0) {
            return;
        }
        this.start = 0;
        while (!this.foundEnd && this.avail < this.FITS_BLOCK_SIZE) {
            var1_1 /* !! */  = new byte[80];
            var2_3 = this.istream.read(var1_1 /* !! */ , 0, 80);
            if (var2_3 != 80) {
                throw new IOException("header line had " + var2_3 + " chars");
            }
            System.arraycopy(var1_1 /* !! */ , 0, this.buf, this.avail, var2_3);
            this.avail += var2_3;
            var3_5 = new String(var1_1 /* !! */ , 0, 80);
            if (var3_5.startsWith("BITPIX")) {
                this.bpp = Integer.parseInt(var3_5.substring(10, 30).trim());
                this.msg("readBlock: found BITPIX=" + this.bpp);
            }
            this.foundEnd = var3_5.startsWith("END");
        }
        if (this.avail == this.FITS_BLOCK_SIZE) {
            return;
        }
        if (this.img == null && this.isCompressed) {
            this.istream.mark(2);
            try {
                var1_1 /* !! */  = (byte[])new HCompressInputStream(this.istream);
                this.msg("readBlock: HCompress: success");
                var2_3 = var1_1 /* !! */ .getWidth();
                var3_6 = var1_1 /* !! */ .getHeight();
                var4_8 = var2_3 * var3_6;
                var5_11 = -1;
                switch (this.bpp) {
                    case 16: {
                        var6_13 = new short[var4_8];
                        this.img = var6_13;
                        var5_11 = var1_1 /* !! */ .readShort(var6_13, 0, var6_13.length);
                        break;
                    }
                    default: {
                        throw new IOException("unsupported pixel format");
                    }
                }
                this.imgPix = 0;
                var7_14 = " ";
                var8_15 = var7_14.getBytes();
                while (this.avail < this.FITS_BLOCK_SIZE) {
                    this.buf[this.avail++] = var8_15[0];
                }
                return;
            }
            catch (BadMagicNumberException var1_2) {
                this.msg("readBlock: HCompresss failed!");
                this.isCompressed = false;
                this.istream.reset();
            }
        }
        if (this.img == null) ** GOTO lbl89
        switch (this.bpp) {
            case 8: {
                var1_1 /* !! */  = (byte[])this.img;
                while (this.avail < this.FITS_BLOCK_SIZE && this.imgPix < var1_1 /* !! */ .length) {
                    this.buf[this.avail++] = (byte)var1_1 /* !! */ [this.imgPix++];
                }
                break;
            }
            case 16: {
                var2_4 = (short[])this.img;
                while (this.avail < this.FITS_BLOCK_SIZE && this.imgPix < var2_4.length) {
                    var3_7 = var2_4[this.imgPix++];
                    this.buf[this.avail++] = (byte)(var3_7 >>> 8 & 255);
                    this.buf[this.avail++] = (byte)(var3_7 >>> 0 & 255);
                }
                break;
            }
            case 32: {
                var3_5 = (int[])this.img;
                while (this.avail < this.FITS_BLOCK_SIZE && this.imgPix < ((int[])var3_5).length) {
                    var4_9 = var3_5[this.imgPix++];
                    this.buf[this.avail++] = (byte)(var4_9 >>> 24 & 255);
                    this.buf[this.avail++] = (byte)(var4_9 >>> 16 & 255);
                    this.buf[this.avail++] = (byte)(var4_9 >>> 8 & 255);
                    this.buf[this.avail++] = (byte)(var4_9 >>> 0 & 255);
                }
                break;
            }
            default: {
                throw new IOException("unsupported pixel format");
            }
        }
        if (this.avail < this.FITS_BLOCK_SIZE) {
            var4_10 = " ";
            var5_12 = var4_10.getBytes();
            while (this.avail < this.FITS_BLOCK_SIZE) {
                this.buf[this.avail++] = var5_12[0];
            }
            this.eof = true;
        }
        return;
lbl-1000:
        // 1 sources

        {
            var1_1 /* !! */  = new byte[80];
            var2_3 = this.istream.read(var1_1 /* !! */ , 0, 80);
            if (var2_3 != 80) {
                throw new IOException("header line had " + var2_3 + " chars");
            }
            System.arraycopy(var1_1 /* !! */ , 0, this.buf, this.avail, var2_3);
            this.avail += var2_3;
lbl89:
            // 2 sources

            ** while (this.avail < this.FITS_BLOCK_SIZE)
        }
lbl90:
        // 1 sources

    }

    private void msg(String string) {
        if (this.debug) {
            System.out.println("FitsFilterInputStream." + string);
        }
    }
}

