/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.config.validators;

import alma.acs.config.validators.ConfigFileRedeemer;
import alma.acs.config.validators.ConfigFileRedeemerFilepath;
import alma.acs.config.validators.ConfigFileRedeemerTestDir;
import alma.acs.config.validators.ConfigFileRedeemerXml;
import alma.acs.testsupport.TestLogger;
import alma.acs.util.CmdLineArgs;
import alma.acs.util.CmdLineRegisteredOption;
import com.cosylab.util.FileHelper;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConfigFileFinder {
    private Logger logger;
    private File baseDir;
    private File targetDir;
    private Set<String> fileEndings = new HashSet<String>();
    private boolean targetFilesFlat = false;
    private List<ConfigFileRedeemer> redeemers = new ArrayList<ConfigFileRedeemer>();

    public ConfigFileFinder() throws Exception {
        this.logger = TestLogger.getLogger(this.getClass().getName());
        this.addFileEndings(new String[]{".properties", ".config"});
    }

    public void configureRedeemers() throws Exception {
        this.addRedeemer(new ConfigFileRedeemerFilepath(this.logger, this.baseDir));
        this.addRedeemer(new ConfigFileRedeemerTestDir(this.logger));
        this.addRedeemer(new ConfigFileRedeemerXml(this.logger));
    }

    public void addRedeemer(ConfigFileRedeemer redeemer) {
        this.redeemers.add(redeemer);
        this.addFileEndings(redeemer.getFileEndings());
    }

    public void configureFromArgs(String[] args) {
        CmdLineArgs cmdArgs = new CmdLineArgs();
        CmdLineRegisteredOption optBaseDir = new CmdLineRegisteredOption("-baseDir", 1);
        cmdArgs.registerOption(optBaseDir);
        CmdLineRegisteredOption optTargetDir = new CmdLineRegisteredOption("-targetDir", 1);
        cmdArgs.registerOption(optTargetDir);
        CmdLineRegisteredOption optTargetFilesFlat = new CmdLineRegisteredOption("-targetFilesFlat", 0);
        cmdArgs.registerOption(optTargetFilesFlat);
        CmdLineRegisteredOption optFileEndings = new CmdLineRegisteredOption("-fileEndings", 1);
        cmdArgs.registerOption(optFileEndings);
        cmdArgs.parseArgs(args);
        if (cmdArgs.isSpecified(optBaseDir)) {
            String baseDirName = cmdArgs.getValues(optBaseDir)[0].trim();
            this.setBaseDir(new File(baseDirName));
        }
        if (cmdArgs.isSpecified(optTargetDir)) {
            String targetDirName = cmdArgs.getValues(optTargetDir)[0].trim();
            this.setTargetDir(new File(targetDirName));
        }
        this.targetFilesFlat = cmdArgs.isSpecified(optTargetFilesFlat);
        if (cmdArgs.isSpecified(optFileEndings)) {
            this.addFileEndings(cmdArgs.getValues(optFileEndings));
        }
    }

    public void checkConfiguration() throws IllegalStateException {
        Object err = "";
        Object warn = "";
        if (this.baseDir == null || !this.baseDir.exists()) {
            err = (String)err + "baseDir '" + this.baseDir + "' does not exist. ";
        }
        if (this.targetDir == null) {
            warn = (String)warn + "targetDir not specified. No files will be copied. ";
        }
        if (this.fileEndings.isEmpty()) {
            err = (String)err + "no files can be selected. Specify option \"-fileEndings\". ";
        }
        if (((String)err).length() > 0) {
            throw new IllegalStateException("Bad configuration: " + (String)err);
        }
        if (((String)warn).length() > 0) {
            System.err.println("Configuration warning: " + (String)warn);
        }
    }

    private void run() {
        String msg = "Tool " + this.getClass().getSimpleName() + " will search for configuration files in '" + this.baseDir + "' and below, suspecting all files ending with ";
        Iterator<Object> iter = this.fileEndings.iterator();
        while (iter.hasNext()) {
            msg = msg + "'" + iter.next() + "'";
            if (!iter.hasNext()) continue;
            msg = msg + ", ";
        }
        msg = msg + " and will then prune those files recognized by any of the filters ";
        iter = this.redeemers.iterator();
        while (iter.hasNext()) {
            msg = msg + ((ConfigFileRedeemer)iter.next()).getName();
            if (!iter.hasNext()) continue;
            msg = msg + ", ";
        }
        msg = msg + ". ";
        if (this.targetDir != null) {
            msg = msg + "The remaining potential config files are copied to '" + this.targetDir + "' with their original directory structure ";
            msg = this.targetFilesFlat ? msg + "flattened." : msg + "maintained.";
        }
        this.logger.info(msg);
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (pathname.isDirectory()) {
                    return true;
                }
                String name = pathname.getName();
                for (String fnEnding : ConfigFileFinder.this.fileEndings) {
                    if (!name.endsWith(fnEnding)) continue;
                    return true;
                }
                return false;
            }
        };
        this.runRecursive(this.baseDir, fileFilter);
    }

    private void runRecursive(File currentDir, FileFilter fileFilter) {
        if (currentDir == null || !currentDir.exists() || !currentDir.isDirectory()) {
            return;
        }
        if (!currentDir.canRead()) {
            this.logger.warning("failed to read from directory " + currentDir.getAbsolutePath());
            return;
        }
        File[] allFiles = currentDir.listFiles(fileFilter);
        for (int i = 0; i < allFiles.length; ++i) {
            if (allFiles[i].isFile()) {
                boolean redeemed = false;
                if (allFiles[i].canRead()) {
                    for (ConfigFileRedeemer filter : this.redeemers) {
                        if (!filter.isNotAConfigFile(allFiles[i])) continue;
                        redeemed = true;
                        break;
                    }
                } else {
                    this.logger.severe("Failed to read file " + allFiles[i]);
                }
                if (redeemed) continue;
                this.handleConfigFile(allFiles[i]);
                continue;
            }
            if (!allFiles[i].isDirectory()) continue;
            this.runRecursive(allFiles[i], fileFilter);
        }
    }

    protected void handleConfigFile(File configFile) {
        try {
            if (this.targetDir != null) {
                try {
                    if (this.targetFilesFlat) {
                        File targetFile = new File(this.targetDir, configFile.getName());
                        FileHelper.copy(configFile, targetFile, true);
                    } else {
                        Object relPathName = configFile.getAbsolutePath().substring(this.baseDir.getAbsolutePath().length());
                        if (!((String)relPathName).startsWith(File.separator)) {
                            relPathName = File.separator + (String)relPathName;
                        }
                        File targetFile = new File(this.targetDir, (String)relPathName);
                        FileHelper.copy(configFile, targetFile, true);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            System.out.println("Potential config file: " + configFile.getAbsolutePath());
        }
        catch (Throwable thr) {
            this.logger.log(Level.SEVERE, "Failed to handle file " + configFile.getAbsolutePath(), thr);
        }
    }

    protected void setBaseDir(File baseDir) {
        this.baseDir = baseDir;
    }

    protected void setTargetDir(File targetDir) {
        this.targetDir = targetDir;
    }

    protected void addFileEndings(String[] moreFileEndings) {
        if (moreFileEndings != null) {
            for (int i = 0; i < moreFileEndings.length; ++i) {
                if (moreFileEndings[i] == null || moreFileEndings[i].trim().length() == 0) {
                    throw new IllegalArgumentException("illegal empty file ending.");
                }
                this.fileEndings.add(moreFileEndings[i].trim());
            }
        }
    }

    public static void main(String[] args) {
        try {
            ConfigFileFinder configFinder = new ConfigFileFinder();
            configFinder.configureFromArgs(args);
            configFinder.configureRedeemers();
            configFinder.checkConfiguration();
            configFinder.run();
            System.out.println("done.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

