/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.algorithms;

import alma.acs.algorithms.Vertex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class TopologicalSort {
    private Collection<Vertex> m_vertices;
    private LinkedList<Vertex> m_sortedVertices;
    private Map<Vertex, List<Vertex>> m_cyclicVertices;

    public TopologicalSort(Collection<Vertex> vertices) {
        this.m_vertices = vertices;
        this.m_sortedVertices = new LinkedList();
    }

    public List sort() {
        Iterator<Vertex> iter = this.m_vertices.iterator();
        while (iter.hasNext()) {
            iter.next().setColor(1);
        }
        for (Vertex vertex : this.m_vertices) {
            if (vertex.getColor() != 1) continue;
            this.dfsVisit(vertex);
        }
        return this.m_sortedVertices;
    }

    private void dfsVisit(Vertex vertex) {
        vertex.setColor(2);
        for (Vertex descendant : vertex.getAdjacencyList()) {
            if (descendant.getColor() == 1) {
                this.dfsVisit(descendant);
                continue;
            }
            if (descendant.getColor() != 2) continue;
            if (this.m_cyclicVertices == null) {
                this.m_cyclicVertices = new HashMap<Vertex, List<Vertex>>();
            }
            if (this.m_cyclicVertices.get(vertex) == null) {
                this.m_cyclicVertices.put(vertex, new ArrayList());
            }
            this.m_cyclicVertices.get(vertex).add(descendant);
        }
        vertex.setColor(3);
        this.m_sortedVertices.addFirst(vertex);
    }

    public boolean hasCycles() {
        return this.m_cyclicVertices != null;
    }

    public Map getCyclicVertices() {
        return this.m_cyclicVertices;
    }
}

