/*
 * Decompiled with CFR 0.152.
 */
package skyview.process;

import java.util.ArrayList;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import skyview.executive.Settings;
import skyview.geometry.DepthSampler;
import skyview.geometry.Position;
import skyview.geometry.Sampler;
import skyview.geometry.Util;
import skyview.process.ImageFinder;
import skyview.process.Mosaicker;
import skyview.process.Processor;
import skyview.survey.Image;
import skyview.survey.Survey;
import skyview.survey.SurveyFinder;
import skyview.util.Utilities;

public class BackupMosaicker
extends Mosaicker {
    private ArrayList<String> usedImageNames = new ArrayList();
    static final double BLANK = -1.0E20;
    private Position pos;
    private double maxSize;
    private ArrayList<Processor> mosaickers = new ArrayList();

    @Override
    public String getName() {
        return "BackupMosaicker";
    }

    @Override
    public String getDescription() {
        return "Create a new image by putting together resampled pixels from multiple surveys";
    }

    @Override
    public void process(Image[] input, Image output, int[] osource, Sampler samp, DepthSampler dSampler) {
        int[] source = (int[])osource.clone();
        double[] data = output.getDataArray();
        for (int i = 0; i < data.length; ++i) {
            data[i] = -1.0E20;
        }
        Mosaicker m = new Mosaicker();
        int wid = output.getWidth();
        m.process(input, output, source, samp, dSampler);
        String[] backups = Settings.getArray("BackupSurvey");
        block1: for (int i = 0; i < backups.length; ++i) {
            for (int j = 0; j < data.length; ++j) {
                double datum = data[j];
                if (!(datum < 0.0) && !Double.isNaN(datum)) continue;
                this.reprocess(output, source, samp, dSampler, backups[i]);
                continue block1;
            }
        }
    }

    public void reprocess(Image output, int[] source, Sampler samp, DepthSampler dSampler, String survey) {
        try {
            System.err.println("  Backup survey:" + survey);
            SurveyFinder finder = (SurveyFinder)Utilities.newInstance(Settings.get("surveyfinder"), "skyview.survey");
            Survey surv = finder.find(survey);
            if (this.pos == null) {
                int width = output.getWidth();
                int height = output.getHeight();
                double[] cpix = new double[]{(double)width / 2.0, (double)height / 2.0};
                double[] cunit = new double[3];
                output.getWCS().inverse().transform(cpix, cunit);
                cpix = Util.coord(cunit);
                cpix[0] = Math.toDegrees(cpix[0]);
                cpix[1] = Math.toDegrees(cpix[1]);
                this.pos = new Position(cpix[0], cpix[1], "J2000");
                this.maxSize = (double)Math.max(width, height) * output.getWCS().getScale() * 180.0 / Math.PI;
            }
            Image[] cand = surv.getImages(this.pos, this.maxSize);
            ImageFinder imFin = ImageFinder.factory(Settings.get("imagefinder"));
            int[] match = imFin.findImages(cand, output);
            double[] data = output.getDataArray();
            for (int i = 0; i < data.length; ++i) {
                if (!(data[i] >= 0.0)) continue;
                match[i] = -4;
            }
            Mosaicker m = new Mosaicker();
            m.process(cand, output, match, samp, dSampler);
            this.mosaickers.add(m);
        }
        catch (Exception e) {
            System.err.println("Backup survey error:" + e);
        }
    }

    @Override
    public void updateHeader(Header h) {
        try {
            h.insertHistory("");
            h.insertHistory("Image mosaicking using skyview.process.BackupMosaicker");
            h.insertHistory("");
            for (Processor p : this.mosaickers) {
                p.updateHeader(h);
            }
        }
        catch (FitsException e) {
            System.err.println("Error updating FITS header:\n   " + e);
        }
    }
}

