/*
 * Decompiled with CFR 0.152.
 */
package skyview.geometry.sampler;

import skyview.executive.Settings;
import skyview.geometry.Sampler;
import skyview.geometry.Transformer;
import skyview.survey.Image;

public class Combo
extends Sampler {
    protected Sampler primary;
    protected Sampler backup;
    protected String combo = Settings.get("ComboSamplers");

    public Combo() {
        String[] samplers = this.combo.split(",");
        this.primary = Sampler.factory(samplers[0]);
        this.backup = Sampler.factory(samplers[1]);
    }

    @Override
    public String getName() {
        return "ComboSampler";
    }

    @Override
    public String getDescription() {
        return "A combination sampler with a primary and backup:" + this.combo;
    }

    @Override
    public void sample(int index) {
        this.primary.sample(index);
        if (Double.isNaN(this.outImage.getData(index))) {
            this.backup.sample(index);
        }
    }

    @Override
    public void setInput(Image inImage) {
        this.primary.setInput(inImage);
        this.backup.setInput(inImage);
    }

    @Override
    public void setBounds(int[] bounds) {
        this.primary.setBounds(bounds);
        this.backup.setBounds(bounds);
    }

    @Override
    public void setOutput(Image outImage) {
        this.outImage = outImage;
        this.primary.setOutput(outImage);
        this.backup.setOutput(outImage);
    }

    @Override
    public void setTransform(Transformer transform) {
        this.primary.setTransform(transform);
        this.backup.setTransform(transform);
    }
}

