/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.Fits;
import org.junit.Assert;
import org.junit.Test;

public class CompressTester {
    @Test
    public void testgz() throws Exception {
        Fits f = new Fits("http://heasarc.gsfc.nasa.gov/FTP/asca/data/rev2/43021000/images/ad43021000gis25670_lo.totsky.gz");
        BasicHDU h = f.readHDU();
        int[][] data = (int[][])h.getKernel();
        double sum = 0.0;
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[i].length; ++j) {
                sum += (double)data[i][j];
            }
        }
        Assert.assertEquals((String)"ZCompress", (Object)sum, (Object)296915.0);
    }

    @Test
    public void testZ() throws Exception {
        Fits f = new Fits("http://heasarc.gsfc.nasa.gov/FTP/rosat/data/pspc/processed_data/600000/rp600245n00/rp600245n00_im1.fits.Z");
        BasicHDU h = f.readHDU();
        short[][] data = (short[][])h.getKernel();
        double sum = 0.0;
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[i].length; ++j) {
                sum += (double)data[i][j];
            }
        }
        Assert.assertEquals((String)"ZCompress", (Object)sum, (Object)91806.0);
    }

    @Test
    public void testStream() throws Exception {
        FileInputStream is = new FileInputStream("test.fits");
        Assert.assertEquals((String)"Stream1", (Object)300, (Object)this.streamRead(is, false, false));
        is = new FileInputStream("test.fits.Z");
        Assert.assertEquals((String)"Stream2", (Object)300, (Object)this.streamRead(is, false, false));
        is = new FileInputStream("test.fits.gz");
        Assert.assertEquals((String)"Stream3", (Object)300, (Object)this.streamRead(is, false, false));
        is = new FileInputStream("test.fits");
        Assert.assertEquals((String)"Stream4", (Object)300, (Object)this.streamRead(is, false, true));
        is = new FileInputStream("test.fits.Z");
        Assert.assertEquals((String)"Stream5", (Object)300, (Object)this.streamRead(is, false, true));
        is = new FileInputStream("test.fits.gz");
        Assert.assertEquals((String)"Stream6", (Object)300, (Object)this.streamRead(is, false, true));
        is = new FileInputStream("test.fits.Z");
        Assert.assertEquals((String)"Stream7", (Object)300, (Object)this.streamRead(is, true, true));
        is = new FileInputStream("test.fits.gz");
        Assert.assertEquals((String)"Stream8", (Object)300, (Object)this.streamRead(is, true, true));
    }

    @Test
    public void testFile() throws Exception {
        File is = new File("test.fits");
        Assert.assertEquals((String)"File1", (Object)300, (Object)this.fileRead(is, false, false));
        is = new File("test.fits.Z");
        Assert.assertEquals((String)"File2", (Object)300, (Object)this.fileRead(is, false, false));
        is = new File("test.fits.gz");
        Assert.assertEquals((String)"File3", (Object)300, (Object)this.fileRead(is, false, false));
        is = new File("test.fits");
        Assert.assertEquals((String)"File4", (Object)300, (Object)this.fileRead(is, false, true));
        is = new File("test.fits.Z");
        Assert.assertEquals((String)"File7", (Object)300, (Object)this.fileRead(is, true, true));
        is = new File("test.fits.gz");
        Assert.assertEquals((String)"File8", (Object)300, (Object)this.fileRead(is, true, true));
    }

    @Test
    public void testString() throws Exception {
        String is = new String("test.fits");
        Assert.assertEquals((String)"String1", (Object)300, (Object)this.stringRead(is, false, false));
        is = new String("test.fits.Z");
        Assert.assertEquals((String)"String2", (Object)300, (Object)this.stringRead(is, false, false));
        is = new String("test.fits.gz");
        Assert.assertEquals((String)"String3", (Object)300, (Object)this.stringRead(is, false, false));
        is = new String("test.fits");
        Assert.assertEquals((String)"String4", (Object)300, (Object)this.stringRead(is, false, true));
        is = new String("test.fits.Z");
        Assert.assertEquals((String)"String7", (Object)300, (Object)this.stringRead(is, true, true));
        is = new String("test.fits.gz");
        Assert.assertEquals((String)"String8", (Object)300, (Object)this.stringRead(is, true, true));
    }

    @Test
    public void testURL() throws Exception {
        String is = new String("test.fits");
        Assert.assertEquals((String)"String1", (Object)300, (Object)this.urlRead(is, false, false));
        is = new String("test.fits.Z");
        Assert.assertEquals((String)"String2", (Object)300, (Object)this.urlRead(is, false, false));
        is = new String("test.fits.gz");
        Assert.assertEquals((String)"String3", (Object)300, (Object)this.urlRead(is, false, false));
        is = new String("test.fits");
        Assert.assertEquals((String)"String4", (Object)300, (Object)this.urlRead(is, false, true));
        is = new String("test.fits.Z");
        Assert.assertEquals((String)"String7", (Object)300, (Object)this.urlRead(is, true, true));
        is = new String("test.fits.gz");
        Assert.assertEquals((String)"String8", (Object)300, (Object)this.urlRead(is, true, true));
    }

    int urlRead(String is, boolean comp, boolean useComp) throws Exception {
        File fil = new File(is);
        String path = fil.getCanonicalPath();
        URL u = new URL("file://" + path);
        Fits f = useComp ? new Fits(u, comp) : new Fits(u);
        short[][] data = (short[][])f.readHDU().getKernel();
        return this.total(data);
    }

    int streamRead(InputStream is, boolean comp, boolean useComp) throws Exception {
        Fits f = useComp ? new Fits(is, comp) : new Fits(is);
        short[][] data = (short[][])f.readHDU().getKernel();
        is.close();
        return this.total(data);
    }

    int fileRead(File is, boolean comp, boolean useComp) throws Exception {
        Fits f = useComp ? new Fits(is, comp) : new Fits(is);
        short[][] data = (short[][])f.readHDU().getKernel();
        return this.total(data);
    }

    int stringRead(String is, boolean comp, boolean useComp) throws Exception {
        Fits f = useComp ? new Fits(is, comp) : new Fits(is);
        short[][] data = (short[][])f.readHDU().getKernel();
        return this.total(data);
    }

    int total(short[][] data) {
        int total = 0;
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[i].length; ++j) {
                total += data[i][j];
            }
        }
        return total;
    }
}

