/*
 * Decompiled with CFR 0.152.
 */
package com.apporiented.algorithm.clustering;

import com.apporiented.algorithm.clustering.Cluster;
import com.apporiented.algorithm.clustering.ClusterPair;
import com.apporiented.algorithm.clustering.ClusteringAlgorithm;
import com.apporiented.algorithm.clustering.Distance;
import com.apporiented.algorithm.clustering.DistanceMap;
import com.apporiented.algorithm.clustering.HierarchyBuilder;
import com.apporiented.algorithm.clustering.LinkageStrategy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class DefaultClusteringAlgorithm
implements ClusteringAlgorithm {
    @Override
    public Cluster performClustering(double[][] dArray, String[] stringArray, LinkageStrategy linkageStrategy) {
        this.checkArguments(dArray, stringArray, linkageStrategy);
        List<Cluster> list = this.createClusters(stringArray);
        DistanceMap distanceMap = this.createLinkages(dArray, list);
        HierarchyBuilder hierarchyBuilder = new HierarchyBuilder(list, distanceMap);
        while (!hierarchyBuilder.isTreeComplete()) {
            hierarchyBuilder.agglomerate(linkageStrategy);
        }
        return hierarchyBuilder.getRootCluster();
    }

    private void checkArguments(double[][] dArray, String[] stringArray, LinkageStrategy linkageStrategy) {
        if (dArray == null || dArray.length == 0 || dArray[0].length != dArray.length) {
            throw new IllegalArgumentException("Invalid distance matrix");
        }
        if (dArray.length != stringArray.length) {
            throw new IllegalArgumentException("Invalid cluster name array");
        }
        if (linkageStrategy == null) {
            throw new IllegalArgumentException("Undefined linkage strategy");
        }
        int n = new HashSet<String>(Arrays.asList(stringArray)).size();
        if (n != stringArray.length) {
            throw new IllegalArgumentException("Duplicate source names found");
        }
    }

    @Override
    public Cluster performWeightedClustering(double[][] dArray, String[] stringArray, double[] dArray2, LinkageStrategy linkageStrategy) {
        this.checkArguments(dArray, stringArray, linkageStrategy);
        if (dArray2.length != stringArray.length) {
            throw new IllegalArgumentException("Invalid weights array");
        }
        List<Cluster> list = this.createClusters(stringArray, dArray2);
        DistanceMap distanceMap = this.createLinkages(dArray, list);
        HierarchyBuilder hierarchyBuilder = new HierarchyBuilder(list, distanceMap);
        while (!hierarchyBuilder.isTreeComplete()) {
            hierarchyBuilder.agglomerate(linkageStrategy);
        }
        return hierarchyBuilder.getRootCluster();
    }

    private DistanceMap createLinkages(double[][] dArray, List<Cluster> list) {
        DistanceMap distanceMap = new DistanceMap();
        for (int i = 0; i < list.size(); ++i) {
            for (int j = i + 1; j < list.size(); ++j) {
                ClusterPair clusterPair = new ClusterPair();
                Cluster cluster = list.get(i);
                Cluster cluster2 = list.get(j);
                clusterPair.setLinkageDistance(dArray[i][j]);
                clusterPair.setlCluster(cluster);
                clusterPair.setrCluster(cluster2);
                distanceMap.add(clusterPair);
            }
        }
        return distanceMap;
    }

    private List<Cluster> createClusters(String[] stringArray) {
        ArrayList<Cluster> arrayList = new ArrayList<Cluster>();
        for (String string : stringArray) {
            Cluster cluster = new Cluster(string);
            arrayList.add(cluster);
        }
        return arrayList;
    }

    private List<Cluster> createClusters(String[] stringArray, double[] dArray) {
        ArrayList<Cluster> arrayList = new ArrayList<Cluster>();
        for (int i = 0; i < dArray.length; ++i) {
            Cluster cluster = new Cluster(stringArray[i]);
            cluster.setDistance(new Distance(0.0, dArray[i]));
            arrayList.add(cluster);
        }
        return arrayList;
    }
}

