/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.obsparams;

import alma.hla.runtime.obsprep.util.Log;
import alma.observatorycharacteristics.capabilities.AlmaCapabilities;
import alma.observatorycharacteristics.capabilities.calibrationconfigurationbindings.CalibrationConfiguration;
import alma.observatorycharacteristics.capabilities.calibrationconfigurationbindings.CalibrationType;
import alma.observatorycharacteristics.capabilities.calibrationconfigurationbindings.ConfigurationBound;
import alma.observatorycharacteristics.capabilities.calibrationconfigurationbindings.CorrelatorType;
import alma.observatorycharacteristics.capabilities.calibrationconfigurationbindings.OTTime;
import alma.observatorycharacteristics.capabilities.calibrationconfigurationbindings.ObjectFactory;
import alma.observatorycharacteristics.capabilities.calibrationconfigurationbindings.ReceiverCalibrationParameters;
import alma.observatorycharacteristics.configuration.OTConfiguration;
import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.generator.refactored.ObsType;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.obsparams.CalibrationTimeQueryInterface;
import alma.obsprep.services.generator.refactored.obsparams.UnableToDetermineCalibrationParametersException;
import alma.obsprep.util.MiscUtils;
import alma.valuetypes.Angle;
import alma.valuetypes.Time;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.List;
import java.util.logging.Level;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.util.ValidationEventCollector;
import lombok.NonNull;

public class CalibrationConfigurationHelper
implements CalibrationTimeQueryInterface {
    private CalibrationConfiguration calibrationConfiguration = null;
    private static CalibrationConfigurationHelper instance;

    private CalibrationConfigurationHelper() throws FileNotFoundException, JAXBException {
        JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
        Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
        ValidationEventCollector validationEventCollector = new ValidationEventCollector();
        unmarshaller.setEventHandler((ValidationEventHandler)validationEventCollector);
        InputStream inputStream = null;
        String string = System.getProperty("Telescope", "Cycle12");
        String string2 = string + "CalibrationConfiguration.xml";
        Log.logger(CalibrationConfigurationHelper.class).fine("Loading CALIBRATIONCONFIGURATIONFILE: " + string2);
        try {
            ValidationEvent[] validationEventArray = MiscUtils.findResource(AlmaPolicies.ALMA_POLICIES_PROPERTIES_FOLDER, string2);
            inputStream = validationEventArray.openStream();
        }
        catch (Exception exception) {
            Log.logger(AlmaCapabilities.class).log(Level.WARNING, "Error accessing " + string2 + " file: " + exception.getMessage(), (Throwable)exception);
        }
        assert (inputStream != null);
        this.calibrationConfiguration = (CalibrationConfiguration)unmarshaller.unmarshal(inputStream);
        if (validationEventCollector.hasEvents()) {
            for (ValidationEvent validationEvent : validationEventCollector.getEvents()) {
                Log.logger(CalibrationConfigurationHelper.class).warning(validationEvent.getMessage());
            }
            throw new JAXBException("Unable to unmarshall calibration configuration XML");
        }
    }

    public static CalibrationConfigurationHelper getInstance() throws FileNotFoundException, JAXBException {
        if (null == instance) {
            instance = new CalibrationConfigurationHelper();
        }
        return instance;
    }

    @Override
    public ReceiverCalibrationParameters getCalibrationParameters(@NonNull Configuration configuration, @NonNull ObsType obsType, @NonNull alma.obsprep.bo.enumerations.CorrelatorType correlatorType, int n, boolean bl) throws UnableToDetermineCalibrationParametersException {
        if (configuration == null) {
            throw new NullPointerException("configuration is marked non-null but is null");
        }
        if (obsType == null) {
            throw new NullPointerException("calibrationType is marked non-null but is null");
        }
        if (correlatorType == null) {
            throw new NullPointerException("correlatorType is marked non-null but is null");
        }
        if (this.calibrationConfiguration == null) {
            throw new UnableToDetermineCalibrationParametersException("Unable to process calibration time configuration XML file: processing of the calibration configuration file failed.");
        }
        for (CalibrationConfiguration.Calibration calibration : this.calibrationConfiguration.getCalibration()) {
            if (!calibration.getCorrelator().name().equals(correlatorType.toString()) || !calibration.getType().toString().equals(obsType.toString())) continue;
            for (ConfigurationBound configurationBound : calibration.getConfiguration()) {
                if (!configurationBound.getName().equals(configuration.getName())) continue;
                for (ReceiverCalibrationParameters receiverCalibrationParameters : configurationBound.getReceiverParameters()) {
                    if (receiverCalibrationParameters.getReceiverBand() != n || receiverCalibrationParameters.isIsWithWalshSwitching() != bl) continue;
                    return receiverCalibrationParameters;
                }
            }
        }
        String string = "Unable to find record for configuration calibration " + String.valueOf((Object)obsType) + " for receiver " + n + " for correlator type " + String.valueOf((Object)correlatorType) + " where the configuration is " + configuration.getName();
        Log.logger(CalibrationConfigurationHelper.class).warning(string);
        throw new UnableToDetermineCalibrationParametersException(string);
    }

    /*
     * WARNING - void declaration
     */
    public static void main(String[] stringArray) {
        for (UIManager.LookAndFeelInfo object2 : UIManager.getInstalledLookAndFeels()) {
            if (!"Metal".equals(object2.getName())) continue;
            try {
                UIManager.setLookAndFeel(object2.getClassName());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException exception) {
                exception.printStackTrace();
            }
            break;
        }
        System.setProperty("otData.dir", "config\\otData");
        InitServices.initModelSupportClasses();
        Object object = null;
        try {
            object = CalibrationConfigurationHelper.getInstance();
        }
        catch (FileNotFoundException | JAXBException throwable) {
            throwable.printStackTrace();
            System.exit(-1);
        }
        assert (object != null);
        for (Configuration configuration : Configuration.getKnownConfigurations(RequestedArray.TWELVE_M)) {
            void var4_11;
            Object var4_9 = null;
            try {
                ReceiverCalibrationParameters receiverCalibrationParameters = ((CalibrationConfigurationHelper)object).getCalibrationParameters(configuration, ObsType.PHASE, alma.obsprep.bo.enumerations.CorrelatorType.BL, 2, false);
            }
            catch (UnableToDetermineCalibrationParametersException unableToDetermineCalibrationParametersException) {
                // empty catch block
            }
            if (var4_11 == null) continue;
            System.out.println("Time is: " + String.valueOf(var4_11));
        }
    }

    public static Time getTime(@NonNull OTTime oTTime) {
        if (oTTime == null) {
            throw new NullPointerException("otTime is marked non-null but is null");
        }
        return Time.createTime((double)oTTime.getValue(), (String)oTTime.getUnit().value());
    }

    public static Angle getAngle(@NonNull alma.observatorycharacteristics.capabilities.calibrationconfigurationbindings.Angle angle) {
        if (angle == null) {
            throw new NullPointerException("angle is marked non-null but is null");
        }
        return Angle.createAngle((double)angle.getValue(), (String)angle.getUnit().value());
    }

    public static Angle getSeparationAngle(@NonNull ReceiverCalibrationParameters receiverCalibrationParameters) {
        if (receiverCalibrationParameters == null) {
            throw new NullPointerException("calibrationParameters is marked non-null but is null");
        }
        return CalibrationConfigurationHelper.getAngle(receiverCalibrationParameters.getSeparationAngle());
    }

    public static Time getTime(@NonNull CalibrationTimeQueryInterface.CalibrationTimeType calibrationTimeType, @NonNull ReceiverCalibrationParameters receiverCalibrationParameters) throws UnableToDetermineCalibrationParametersException {
        if (calibrationTimeType == null) {
            throw new NullPointerException("calibrationTimeRequired is marked non-null but is null");
        }
        if (receiverCalibrationParameters == null) {
            throw new NullPointerException("calibrationParameters is marked non-null but is null");
        }
        switch (calibrationTimeType) {
            case CYCLETIME: {
                return CalibrationConfigurationHelper.getTime(receiverCalibrationParameters.getCycleTime());
            }
            case DEFAULTINTEGRATIONTIME: {
                return CalibrationConfigurationHelper.getTime(receiverCalibrationParameters.getIntegrationDuration());
            }
            case SUBSCANTIME: {
                return CalibrationConfigurationHelper.getTime(receiverCalibrationParameters.getSubscanDuration());
            }
        }
        throw new UnableToDetermineCalibrationParametersException("Unknown time type requested " + String.valueOf((Object)calibrationTimeType));
    }

    public List<ReceiverCalibrationParameters> getCalibrationParameters(@NonNull OTConfiguration.ArrayConfigurations.ArrayConfiguration arrayConfiguration, @NonNull CalibrationType calibrationType, @NonNull CorrelatorType correlatorType) throws UnableToFindCalibrationParametersException {
        if (arrayConfiguration == null) {
            throw new NullPointerException("configuration is marked non-null but is null");
        }
        if (calibrationType == null) {
            throw new NullPointerException("calibratorType is marked non-null but is null");
        }
        if (correlatorType == null) {
            throw new NullPointerException("correlatorType is marked non-null but is null");
        }
        for (CalibrationConfiguration.Calibration calibration : this.calibrationConfiguration.getCalibration()) {
            if (!calibration.getCorrelator().equals((Object)correlatorType) || !calibration.getType().equals((Object)calibrationType)) continue;
            for (ConfigurationBound configurationBound : calibration.getConfiguration()) {
                if (!configurationBound.getName().equals(arrayConfiguration.getConfigurationName())) continue;
                return configurationBound.getReceiverParameters();
            }
        }
        throw new UnableToFindCalibrationParametersException("Cannot find calibration parameters for " + arrayConfiguration.getConfigurationName() + " " + String.valueOf((Object)calibrationType) + " " + String.valueOf((Object)correlatorType));
    }

    public CalibrationConfiguration getCalibrationConfiguration() {
        return this.calibrationConfiguration;
    }

    public class UnableToFindCalibrationParametersException
    extends Exception {
        public UnableToFindCalibrationParametersException(String string) {
            super(string);
        }
    }
}

