/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored;

import alma.common.sourcecatalog.CatalogQueryParameters;
import alma.common.sourcecatalog.Measurement;
import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.observatorycharacteristics.capabilities.AlmaCapabilities;
import alma.obsprep.bo.obsproject.CalibrationSetupParameters;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SpectralScan;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.UnableToFindSolutionException;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.services.etc.ClusterGeometricMeanCalculator;
import alma.obsprep.services.etc.SourceNeverVisibleException;
import alma.obsprep.services.experts.BackgroundCalibratorDatabaseInteractor;
import alma.obsprep.services.experts.CalibratorExpert;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.experts.ConfigurationHelper;
import alma.obsprep.services.experts.ConfigurationSet;
import alma.obsprep.services.experts.InvalidConfigurationParametersException;
import alma.obsprep.services.experts.InvalidFrequencyException;
import alma.obsprep.services.experts.RequiredConfigurations;
import alma.obsprep.services.experts.SchedBlockExpert;
import alma.obsprep.services.experts.ScienceGoalConfigurations;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.DGCExpert;
import alma.obsprep.services.generator.refactored.ObsType;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.obsparams.UnableToDetermineCalibrationParametersException;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGeneratorTemplate;
import alma.obsprep.services.generator.refactored.spectralspec.SpectralSpecFactory;
import alma.obsprep.services.sfi.SingleFieldScienceGoalModel;
import alma.obsprep.util.MiscUtils;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.Velocity;
import com.google.common.collect.Sets;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import lombok.NonNull;
import org.apache.commons.jcs3.JCS;
import org.apache.commons.jcs3.access.CacheAccess;
import org.python.google.common.base.Objects;

public class DGCOnlineCalibratorExpert
extends DGCExpert {
    private static Optional<DGCCalibratorType> testBWSWCalibrator = Optional.empty();
    private static Optional<DGCCalibratorType> testB2BCalibrator = Optional.empty();
    private static final long maxAgeOfBWSWCalibrator_s = 63072000L;
    private static final String unableToDetermineCalibratorFluxAtRFWarning = "Unable to determine calibrator flux at reference frequency ";
    private static final String unableToGetTMConfigurationsWarning = "Unable to get the 12-m configurations: ";
    private static final CacheAccess<Double, List<Measurement>> calibratorMeasurementResultsCache = JCS.getInstance((String)"calibratorResults");
    private static final CacheAccess<Integer, DGCExpert.BWSWSchedulingOutcome> bwswRequiredCache = JCS.getInstance((String)"bwswRequiredCache");
    private static final CacheAccess<Integer, DGCExpert.B2BSchedulingOutcome> b2bRequiredCache = JCS.getInstance((String)"b2bRequiredCache");
    public static final Supplier<? extends Exception> UnableToQueryCatalogueException = () -> new UnableToQueryCatalogueException("Unable query online calibrator catalogue");
    private boolean isTM2 = false;

    public DGCOnlineCalibratorExpert(boolean bl) {
        this.isTM2 = bl;
    }

    @Override
    public boolean isDGCScheduled(@NonNull ScienceGoal scienceGoal, boolean bl) {
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        return !Sets.intersection(this.dgcObservingStrategiesRequired(scienceGoal, true), DGCExpert.allDGCStrategies).isEmpty();
    }

    @Override
    public Set<DGCExpert.DGCTypeEnum> resolveWhichDGCStrategyToUse(@NonNull ScienceGoal scienceGoal, @NonNull RequestedArray requestedArray, @NonNull Optional<SBGeneratorTemplate.SchedBlockType> optional, Set<DGCExpert.DGCTypeEnum> set, Optional<EnumSet<SBGeneratorTemplate.SBGenerationSchema>> optional2) {
        if (scienceGoal == null) {
            throw new NullPointerException("userDefinedScienceGoal is marked non-null but is null");
        }
        if (requestedArray == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (optional == null) {
            throw new NullPointerException("sbType is marked non-null but is null");
        }
        if (!set.containsAll(DGCExpert.allDGCStrategies)) {
            return set;
        }
        EnumSet<DGCExpert.DGCTypeEnum> enumSet = EnumSet.noneOf(DGCExpert.DGCTypeEnum.class);
        if (!this.isB2BScienceGoalSetupPreconditionsForDGCSatisfied(scienceGoal)) {
            return enumSet;
        }
        return EnumSet.of(this.isB2BScheduled(scienceGoal, false).isB2BToBeScheduled() ? DGCExpert.DGCTypeEnum.DGCBandToBand : DGCExpert.DGCTypeEnum.DGCBandwidthSwitching);
    }

    private SBGenerationContext createSBGenerationContext(@NonNull ScienceGoal scienceGoal, @NonNull RequestedArray requestedArray, @NonNull Optional<SBGeneratorTemplate.SchedBlockType> optional, @NonNull Optional<EnumSet<SBGeneratorTemplate.SBGenerationSchema>> optional2) {
        if (scienceGoal == null) {
            throw new NullPointerException("userDefinedScienceGoal is marked non-null but is null");
        }
        if (requestedArray == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (optional == null) {
            throw new NullPointerException("sbType is marked non-null but is null");
        }
        if (optional2 == null) {
            throw new NullPointerException("sbGenerationContext is marked non-null but is null");
        }
        SBGenerationContext sBGenerationContext = new SBGenerationContext();
        try {
            sBGenerationContext.setArray(requestedArray).setScienceGoal(scienceGoal).setSB(SchedBlock.createSchedBlock()).setSBType(optional.orElse(SBGeneratorTemplate.SchedBlockType.TWELVEMEXTENDEDCONFIGURATION)).setConfiguration(Configuration.getMostCompactConfiguration(RequestedArray.TWELVE_M)).setSBGenerationSchema(optional2.orElseGet(() -> EnumSet.noneOf(SBGeneratorTemplate.SBGenerationSchema.class)));
        }
        catch (Configuration.UnableToDetermineConfigurationException unableToDetermineConfigurationException) {
            throw new WizardSBGenerationException("Unable to create SB generation context");
        }
        return sBGenerationContext;
    }

    @Override
    public DGCExpert.B2BSchedulingOutcome isB2BScheduled(@NonNull ScienceGoal scienceGoal, boolean bl) {
        if (scienceGoal == null) {
            throw new NullPointerException("clusteredScienceGoal is marked non-null but is null");
        }
        if (bl && scienceGoal.getCalibrationSetupParameters().getIsDGCOverride()) {
            return DGCExpert.B2BSchedulingOutcome.NotScheduled;
        }
        return this.isB2BRequirementsMet(scienceGoal);
    }

    @Override
    public DGCExpert.BWSWSchedulingOutcome isBWSWScheduled(@NonNull ScienceGoal scienceGoal, boolean bl) {
        if (scienceGoal == null) {
            throw new NullPointerException("clusteredScienceGoal is marked non-null but is null");
        }
        if (bl && scienceGoal.getCalibrationSetupParameters().getIsDGCOverride()) {
            return DGCExpert.BWSWSchedulingOutcome.NotScheduled;
        }
        return this.isBWSWRequirementsMet(scienceGoal);
    }

    @Override
    protected DGCExpert.B2BSchedulingOutcome isB2BRequirementsMet(@NonNull ScienceGoal scienceGoal) {
        Optional<AdjustedFluxValue> optional;
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        if (!this.isB2BScienceGoalSetupPreconditionsForDGCSatisfied(scienceGoal)) {
            return DGCExpert.B2BSchedulingOutcome.ScienceGoalConfigurationIncompatible;
        }
        if (MiscUtils.isForceB2B() || scienceGoal.getCalibrationSetupParameters().isForcedB2BDGC()) {
            return DGCExpert.B2BSchedulingOutcome.Scheduled;
        }
        if (MiscUtils.isForceBWSW() || scienceGoal.getCalibrationSetupParameters().isForcedDGCBWSW()) {
            return DGCExpert.B2BSchedulingOutcome.UseBWSW;
        }
        Integer n = MiscUtils.getCacheHashcode(false, new BusinessObject[]{scienceGoal});
        DGCExpert.B2BSchedulingOutcome b2BSchedulingOutcome = (DGCExpert.B2BSchedulingOutcome)((Object)b2bRequiredCache.get((Object)n));
        if (b2BSchedulingOutcome != null) {
            return b2BSchedulingOutcome;
        }
        Configuration configuration = null;
        try {
            configuration = scienceGoal.isStandAloneACA() ? Configuration.getACAConfiguration() : this.getConfigurationFromWhichToInformDGC(scienceGoal);
        }
        catch (Configuration.UnableToDetermineConfigurationException | InvalidConfigurationParametersException | SchedBlockExpert.UnableToDetermine12mCompactConfiguration exception) {
            Log.logger(DGCExpert.class).warning("Unable to get the array configuration: " + exception.getMessage());
            b2bRequiredCache.put((Object)n, (Object)DGCExpert.B2BSchedulingOutcome.ScienceGoalConfigurationIncompatible);
            return DGCExpert.B2BSchedulingOutcome.ScienceGoalConfigurationIncompatible;
        }
        if (!Configuration.isDGCConfiguration(configuration)) {
            b2bRequiredCache.put((Object)n, (Object)DGCExpert.B2BSchedulingOutcome.NotScheduled);
            return DGCExpert.B2BSchedulingOutcome.NotScheduled;
        }
        Optional<Object> optional2 = Optional.empty();
        Frequency frequency = scienceGoal.getSpectralSetupParameters().getRepresentativeFrequencyWithSkyOffset().deepCopy();
        try {
            optional2 = this.searchOnlineCalibratorCatalogueForInBandCalibrator(scienceGoal, frequency, Optional.empty(), Optional.empty());
        }
        catch (UnableToQueryCatalogueException unableToQueryCatalogueException) {
            Log.logger(DGCOnlineCalibratorExpert.class).warning("Unable to query calibrator catalogue : " + unableToQueryCatalogueException.getMessage());
            Log.logger(DGCOnlineCalibratorExpert.class).warning("Defaulting to B2B : " + unableToQueryCatalogueException.getMessage());
            return DGCExpert.B2BSchedulingOutcome.FailedToCommunicateWithCalibratorServer;
        }
        if (optional2.isEmpty()) {
            b2bRequiredCache.put((Object)n, (Object)DGCExpert.B2BSchedulingOutcome.NoCalibratorFoundInCatalogue);
            return DGCExpert.B2BSchedulingOutcome.NoCalibratorFoundInCatalogue;
        }
        SingleFieldScienceGoalModel.ExtrapolatedFluxValues extrapolatedFluxValues = null;
        try {
            extrapolatedFluxValues = SingleFieldScienceGoalModel.getExtrapolatedFluxValues(configuration, scienceGoal, Optional.empty(), (AdjustedFluxValue)optional2.get(), frequency, SingleFieldScienceGoalModel::getS_Antenna);
        }
        catch (SourceNeverVisibleException | InvalidFrequencyException | UnableToDetermineCalibrationParametersException exception) {
            Log.logger(DGCOnlineCalibratorExpert.class).warning("Unable to determine s_rf and s_antenna: " + exception.getMessage());
            b2bRequiredCache.put((Object)n, (Object)DGCExpert.B2BSchedulingOutcome.ScienceGoalConfigurationIncompatible);
            return DGCExpert.B2BSchedulingOutcome.ScienceGoalConfigurationIncompatible;
        }
        if (((AdjustedFluxValue)optional2.get()).getTimeAdjustedFlux() >= extrapolatedFluxValues.getS_antenna()) {
            b2bRequiredCache.put((Object)n, (Object)DGCExpert.B2BSchedulingOutcome.SuitableInBandCalibratorFound);
            return DGCExpert.B2BSchedulingOutcome.SuitableInBandCalibratorFound;
        }
        if (this.findInBandCalibratorWithMaxBandwidth(scienceGoal, this.getMaxOverlappingBW(scienceGoal))) {
            b2bRequiredCache.put((Object)n, (Object)DGCExpert.B2BSchedulingOutcome.UseBWSW);
            return DGCExpert.B2BSchedulingOutcome.UseBWSW;
        }
        try {
            optional = this.getCalibratorFluxAtReferenceFrequency(scienceGoal, Optional.empty(), Optional.empty(), DGCExpert.DGCTypeEnum.DGCBandToBand);
        }
        catch (UnableToQueryCatalogueException unableToQueryCatalogueException) {
            Log.logger(DGCOnlineCalibratorExpert.class).warning(unableToDetermineCalibratorFluxAtRFWarning + unableToQueryCatalogueException.getMessage());
            b2bRequiredCache.put((Object)n, (Object)DGCExpert.B2BSchedulingOutcome.Scheduled);
            return DGCExpert.B2BSchedulingOutcome.Scheduled;
        }
        if (optional.isEmpty()) {
            b2bRequiredCache.put((Object)n, (Object)DGCExpert.B2BSchedulingOutcome.NoCalibratorFoundInCatalogue);
            return DGCExpert.B2BSchedulingOutcome.NoCalibratorFoundInCatalogue;
        }
        AdjustedFluxValue adjustedFluxValue = optional.get();
        try {
            extrapolatedFluxValues = SingleFieldScienceGoalModel.getExtrapolatedFluxValues(configuration, scienceGoal, Optional.empty(), adjustedFluxValue, adjustedFluxValue.getRf(), SingleFieldScienceGoalModel::getS_Antenna_ref);
        }
        catch (SourceNeverVisibleException | InvalidFrequencyException | UnableToDetermineCalibrationParametersException exception) {
            Log.logger(DGCOnlineCalibratorExpert.class).warning(unableToDetermineCalibratorFluxAtRFWarning + exception.getMessage());
            b2bRequiredCache.put((Object)n, (Object)DGCExpert.B2BSchedulingOutcome.Scheduled);
            return DGCExpert.B2BSchedulingOutcome.Scheduled;
        }
        Double d = adjustedFluxValue.getTimeAdjustedFlux();
        double d2 = d / extrapolatedFluxValues.getS_antenna();
        if (10.0 <= d2 && d2 < 30.0) {
            b2bRequiredCache.put((Object)n, (Object)DGCExpert.B2BSchedulingOutcome.B2BWeakCalibratorFound);
            return DGCExpert.B2BSchedulingOutcome.B2BWeakCalibratorFound;
        }
        if (d2 < 10.0) {
            b2bRequiredCache.put((Object)n, (Object)DGCExpert.B2BSchedulingOutcome.UnuseableB2BCalibratorFound);
            return DGCExpert.B2BSchedulingOutcome.UnuseableB2BCalibratorFound;
        }
        b2bRequiredCache.put((Object)n, (Object)DGCExpert.B2BSchedulingOutcome.Scheduled);
        return DGCExpert.B2BSchedulingOutcome.Scheduled;
    }

    private boolean isB2BScienceGoalSetupPreconditionsForDGCSatisfied(@NonNull ScienceGoal scienceGoal) {
        boolean bl;
        ScienceGoalConfigurations<ConfigurationSet> scienceGoalConfigurations;
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        if (this.isVLBIorPhasedArray()) {
            return false;
        }
        if (scienceGoal.isSpectralScan()) {
            return false;
        }
        ReceiverBand receiverBand = scienceGoal.getReceiverBand();
        if (receiverBand == null) {
            return false;
        }
        if (!this.dgcB2BLegalBands.contains(receiverBand)) {
            return false;
        }
        if (scienceGoal.isFullPolarization()) {
            return false;
        }
        if (this.isForcedDGCPreconditionsMet(scienceGoal)) {
            return true;
        }
        try {
            scienceGoalConfigurations = Configuration.getConfigurationsToBeScheduled(scienceGoal);
        }
        catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
            return false;
        }
        boolean bl2 = bl = scienceGoal.isStandAloneACA() || !Sets.intersection(Configuration.getDGCConfigurations(), Set.copyOf(scienceGoalConfigurations.getExtendedConfigurations())).isEmpty();
        if (bl) {
            Log.logger(DGCOnlineCalibratorExpert.class).fine("ScienceGoal " + scienceGoal.getName() + " satisfies DGC pre-conditions");
        } else {
            Log.logger(DGCOnlineCalibratorExpert.class).fine("ScienceGoal " + scienceGoal.getName() + " does not satisfy DGC pre-conditions");
        }
        return bl;
    }

    private boolean isForcedDGCPreconditionsMet(@NonNull ScienceGoal scienceGoal) {
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        String string = scienceGoal.getCalibrationSetupParameters().getForcedDGCStrategy();
        return string != null && !CalibrationSetupParameters.FORCEDDGCSTRATEGY_NONE.equals(string) && this.dgcB2BLegalBands.contains(scienceGoal.getReceiverBand());
    }

    private Optional<AdjustedFluxValue> getCalibratorFluxAtReferenceFrequency(@NonNull ScienceGoal scienceGoal, Optional<Date> optional, Optional<Frequency> optional2, @NonNull DGCExpert.DGCTypeEnum dGCTypeEnum) throws UnableToQueryCatalogueException {
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        if (dGCTypeEnum == null) {
            throw new NullPointerException("dgcType is marked non-null but is null");
        }
        Frequency frequency = Frequency.createFrequency((double)this.getAverageSPWFrequencyForReferenceSpectralSpec(scienceGoal, dGCTypeEnum).orElseThrow(), (String)Frequency.UNIT_GHZ);
        Log.logger(DGCOnlineCalibratorExpert.class).fine("averageFrequency: " + String.valueOf((Object)frequency));
        Optional<AdjustedFluxValue> optional3 = this.searchOnlineCalibratorCatalogueForInBandCalibrator(scienceGoal, frequency, optional, optional2);
        optional3.ifPresent(adjustedFluxValue -> adjustedFluxValue.setRf(frequency));
        return optional3;
    }

    private OptionalDouble getAverageSPWFrequencyForReferenceSpectralSpec(@NonNull ScienceGoal scienceGoal, @NonNull DGCExpert.DGCTypeEnum dGCTypeEnum) {
        Object object;
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        if (dGCTypeEnum == null) {
            throw new NullPointerException("dgcType is marked non-null but is null");
        }
        SBGenerationContext sBGenerationContext = this.createSBGenerationContext(scienceGoal, RequestedArray.TWELVE_M, Optional.empty(), Optional.empty());
        SpectralSetupParameters spectralSetupParameters = scienceGoal.getSpectralSetupParameters();
        Velocity velocity = spectralSetupParameters.getSourceVelocity().deepCopy();
        if (scienceGoal.isSpectralScan()) {
            try {
                object = spectralSetupParameters.getSpectralScan().getTunings();
            }
            catch (UnableToFindSolutionException unableToFindSolutionException) {
                return OptionalDouble.empty();
            }
            try {
                spectralSetupParameters = SpectralScan.createSPWBasedSSPFromSpectralScanTuning(spectralSetupParameters, ((SpectralScan.SpectralScanTunings)object).getTuning(0));
            }
            catch (SpectralScan.SpectralScanTunings.SpectralScanTuningException | UnableToFindSolutionException exception) {
                return OptionalDouble.empty();
            }
        }
        object = new SpectralSpecFactory(sBGenerationContext);
        ((SpectralSpecFactory)object).setDGCCalibratorReturnType(dGCTypeEnum);
        SpectralSpec spectralSpec = ((SpectralSpecFactory)object).getSpectralSpec(spectralSetupParameters, velocity, ObsType.DGCREFERENCE, Optional.empty());
        return Arrays.stream(spectralSpec.getBaseBand()).mapToDouble(baseBand -> baseBand.getCenterFrequencySky().getContentInGHz()).average();
    }

    private Optional<AdjustedFluxValue> searchOnlineCalibratorCatalogueForInBandCalibrator(@NonNull ScienceGoal scienceGoal, @NonNull Frequency frequency, Optional<Date> optional, Optional<Frequency> optional2) throws UnableToQueryCatalogueException {
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        if (frequency == null) {
            throw new NullPointerException("referenceFrequency is marked non-null but is null");
        }
        List<Measurement> list = this.queryCalibratorCatalogue(scienceGoal, optional2);
        Integer n = null;
        HashMap<Integer, AdjustedFluxValue> hashMap = new HashMap<Integer, AdjustedFluxValue>(100);
        for (Measurement measurement : list) {
            AdjustedFluxValue adjustedFluxValue;
            if (measurement.getUvMax() != null && measurement.getUvMax() > 0.0 || !measurement.getCatalogueId().equals(5) || optional.isPresent() && measurement.getDateObserved().before(optional.get())) continue;
            Integer n2 = measurement.getSourceId();
            if (n == null) {
                adjustedFluxValue = new AdjustedFluxValue(this);
                adjustedFluxValue.setMeasurement(measurement);
                hashMap.put(n2, adjustedFluxValue);
                n = n2;
                continue;
            }
            if (n.equals(n2)) {
                adjustedFluxValue = (AdjustedFluxValue)hashMap.get(n2);
                if (measurement.getFrequency().compareTo(adjustedFluxValue.getMeasurement().getFrequency()) <= 0) continue;
                adjustedFluxValue.setMeasurement(measurement);
                continue;
            }
            n = null;
        }
        double d = frequency.getContentInUnits(Frequency.UNIT_HZ);
        double d2 = (double)Instant.now().getEpochSecond() / 86400.0;
        hashMap.entrySet().forEach(entry -> {
            AdjustedFluxValue adjustedFluxValue = (AdjustedFluxValue)entry.getValue();
            Measurement measurement = adjustedFluxValue.getMeasurement();
            Double d3 = measurement.getFlux();
            Double d4 = measurement.getFrequency();
            adjustedFluxValue.setFluxAtRF(d3 * Math.pow(d / d4, -0.7));
            double d5 = (double)measurement.getDateObserved().getTime() / 1000.0 / 86400.0;
            double d6 = d2 - d5;
            adjustedFluxValue.setNoDaysAgoCalibratorWasObserved(d6);
            double d7 = adjustedFluxValue.getFluxAtRF() * Math.pow(0.99, d6 / 10.0);
            double d8 = adjustedFluxValue.getFluxAtRF() / 3.0;
            adjustedFluxValue.setTimeAdjustedFlux(d7 < d8 ? d8 : d7);
        });
        Optional optional3 = hashMap.entrySet().stream().max((entry, entry2) -> ((AdjustedFluxValue)entry.getValue()).getTimeAdjustedFlux() > ((AdjustedFluxValue)entry2.getValue()).getTimeAdjustedFlux() ? 1 : -1);
        return optional3.map(Map.Entry::getValue);
    }

    private List<Measurement> queryCalibratorCatalogue(@NonNull ScienceGoal scienceGoal, @NonNull Optional<Frequency> optional) throws UnableToQueryCatalogueException {
        List<Measurement> list;
        Configuration configuration;
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        if (optional == null) {
            throw new NullPointerException("maxFrequencyForCalibrator is marked non-null but is null");
        }
        BackgroundCalibratorDatabaseInteractor backgroundCalibratorDatabaseInteractor = BackgroundCalibratorDatabaseInteractor.getInstance();
        backgroundCalibratorDatabaseInteractor.setCatalogueAccess(CalibratorExpert.SourceCatalog.byName(CalibratorExpert.SourceCatalog.ALMA.getName()));
        backgroundCalibratorDatabaseInteractor.setCatalogsToQuery(List.of(CalibratorExpert.ALMACalibratorCatalogue));
        SkyCoordinates skyCoordinates = null;
        try {
            skyCoordinates = new ClusterGeometricMeanCalculator().getGeometricMeanOfCluster(scienceGoal);
        }
        catch (ClusterGeometricMeanCalculator.UnableToCalculateGeometricMeanException unableToCalculateGeometricMeanException) {
            Log.logger(DGCOnlineCalibratorExpert.class).warning("Unable to calculate the geometric mean of the cluster");
            throw new UnableToQueryCatalogueException(unableToCalculateGeometricMeanException);
        }
        CatalogQueryParameters catalogQueryParameters = new CatalogQueryParameters();
        catalogQueryParameters.setMinFrequency(84.0);
        optional.ifPresent(frequency -> catalogQueryParameters.setMaxFrequency(frequency.getContentInGHz()));
        catalogQueryParameters.setMaxSources(Integer.valueOf(100));
        try {
            configuration = scienceGoal.isStandAloneACA() ? Configuration.getACAConfiguration() : this.getConfigurationFromWhichToInformDGC(scienceGoal);
        }
        catch (Configuration.UnableToDetermineConfigurationException | InvalidConfigurationParametersException | SchedBlockExpert.UnableToDetermine12mCompactConfiguration exception) {
            Log.logger(DGCExpert.class).warning(unableToGetTMConfigurationsWarning + exception.getMessage());
            throw new UnableToQueryCatalogueException("Unable to get 12-m configuration");
        }
        ReceiverBand receiverBand = scienceGoal.getReceiverBand();
        try {
            Angle angle = configuration.getPhaseCalConeSeparation(receiverBand.getNumber());
            catalogQueryParameters.setRadius(angle.getDegs());
            Log.logger(DGCOnlineCalibratorExpert.class).fine("Calibrator search radius for " + configuration.getName() + " in band " + receiverBand.getNumber() + " is " + angle.getDegs() + " degrees");
        }
        catch (NoSuchElementException noSuchElementException) {
            String string = "Unable to find search radius for " + configuration.getName() + " with rxb " + String.valueOf(receiverBand);
            Log.logger(DGCOnlineCalibratorExpert.class).warning(string);
            throw new RuntimeException(string);
        }
        double d = skyCoordinates.getLatitude().getDegs();
        double d2 = skyCoordinates.getLongitude().getDegs();
        catalogQueryParameters.setDeclination(d);
        catalogQueryParameters.setRightAscension(d2);
        catalogQueryParameters.setSortBy("source_id");
        Log.logger(DGCOnlineCalibratorExpert.class).fine("calibrator search : Declination " + d + " and Right ascension " + d2);
        Double d3 = Objects.hashCode((Object[])new Object[]{optional, catalogQueryParameters.getDeclination(), catalogQueryParameters.getRightAscension(), catalogQueryParameters.getRadius()});
        List list2 = (List)calibratorMeasurementResultsCache.get((Object)d3);
        if (list2 != null) {
            return Collections.unmodifiableList(list2);
        }
        try {
            list = backgroundCalibratorDatabaseInteractor.query(catalogQueryParameters);
        }
        catch (Exception exception) {
            throw new UnableToQueryCatalogueException(exception);
        }
        if (optional.isPresent()) {
            double d4 = optional.get().getContentInUnits(Frequency.UNIT_HZ);
            list = list.stream().filter(measurement -> measurement.getFrequency() == null || measurement.getFrequency() < d4).toList();
        }
        calibratorMeasurementResultsCache.put((Object)d3, list);
        return Collections.unmodifiableList(list);
    }

    @Override
    public DGCExpert.BWSWSchedulingOutcome isBWSWRequirementsMet(@NonNull ScienceGoal scienceGoal) {
        boolean bl;
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        if (MiscUtils.isForceBWSW() || scienceGoal.getCalibrationSetupParameters().isForcedDGCBWSW()) {
            return DGCExpert.BWSWSchedulingOutcome.Scheduled;
        }
        List<ReceiverBand> list = AlmaCapabilities.getInstance().getDGCB2BReceiverBands();
        boolean bl2 = list.contains(scienceGoal.getReceiverBand());
        if (bl2) {
            return DGCExpert.BWSWSchedulingOutcome.NotScheduled;
        }
        ReceiverBand receiverBand = scienceGoal.getReceiverBand();
        boolean bl3 = bl = receiverBand == null || scienceGoal.isFullPolarization() && bl2;
        if (scienceGoal.isStandAloneACA() || scienceGoal.isSpectralScan() || bl) {
            return DGCExpert.BWSWSchedulingOutcome.ScienceGoalConfigurationIncompatible;
        }
        if (this.isVLBIorPhasedArray()) {
            return DGCExpert.BWSWSchedulingOutcome.NotScheduled;
        }
        if (!this.isNonOverlappingBandwidthBWSWCompliant(scienceGoal)) {
            return DGCExpert.BWSWSchedulingOutcome.NotScheduled;
        }
        Integer n = MiscUtils.getCacheHashcode(false, new BusinessObject[]{scienceGoal});
        DGCExpert.BWSWSchedulingOutcome bWSWSchedulingOutcome = (DGCExpert.BWSWSchedulingOutcome)((Object)bwswRequiredCache.get((Object)n));
        if (bWSWSchedulingOutcome != null) {
            return bWSWSchedulingOutcome;
        }
        DGCExpert.B2BSchedulingOutcome b2BSchedulingOutcome = this.isB2BRequirementsMet(scienceGoal);
        if (b2BSchedulingOutcome.equals((Object)DGCExpert.B2BSchedulingOutcome.SuitableInBandCalibratorFound)) {
            bwswRequiredCache.put((Object)n, (Object)DGCExpert.BWSWSchedulingOutcome.NotScheduled);
            return DGCExpert.BWSWSchedulingOutcome.NotScheduled;
        }
        if (b2BSchedulingOutcome.equals((Object)DGCExpert.B2BSchedulingOutcome.UseBWSW)) {
            bwswRequiredCache.put((Object)n, (Object)DGCExpert.BWSWSchedulingOutcome.Scheduled);
            return DGCExpert.BWSWSchedulingOutcome.Scheduled;
        }
        DGCExpert.BWSWSchedulingOutcome bWSWSchedulingOutcome2 = this.isBWSWPhaseCalibratorSearchPreconditionsMet(scienceGoal);
        bwswRequiredCache.put((Object)n, (Object)bWSWSchedulingOutcome2);
        return bWSWSchedulingOutcome2;
    }

    private boolean isVLBIorPhasedArray() {
        try {
            if (ObsProposal.isVLBIRelated()) {
                return true;
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            return false;
        }
        return false;
    }

    private DGCExpert.BWSWSchedulingOutcome isBWSWPhaseCalibratorSearchPreconditionsMet(@NonNull ScienceGoal scienceGoal) {
        Optional<AdjustedFluxValue> optional;
        Object object;
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        Optional<Object> optional2 = Optional.empty();
        Frequency frequency = scienceGoal.getSpectralSetupParameters().getRepresentativeFrequencyWithSkyOffset();
        Optional<Frequency> optional3 = Optional.of(Frequency.createFrequencyGHZ(ReceiverBand.getReceiverBand(7).getRFMax()));
        Optional<Date> optional4 = Optional.of(new Date(Instant.now().minusSeconds(63072000L).getEpochSecond() * 1000L));
        try {
            optional2 = this.searchOnlineCalibratorCatalogueForInBandCalibrator(scienceGoal, frequency, optional4, optional3);
        }
        catch (UnableToQueryCatalogueException unableToQueryCatalogueException) {
            Log.logger(DGCOnlineCalibratorExpert.class).warning("Unable to query calibrator catalogue : " + unableToQueryCatalogueException.getMessage());
            return DGCExpert.BWSWSchedulingOutcome.FailedToCommunicateWithCalibratorServer;
        }
        if (optional2.isEmpty()) {
            return DGCExpert.BWSWSchedulingOutcome.NoCalibratorFoundInCatalogue;
        }
        RequiredConfigurations requiredConfigurations = null;
        try {
            object = scienceGoal.getPerformanceParameters();
            requiredConfigurations = ConfigurationHelper.getRecommended12mConfigurations(scienceGoal, object.getRepresentativeFrequency());
        }
        catch (InvalidConfigurationParametersException invalidConfigurationParametersException) {
            Log.logger(DGCExpert.class).warning(unableToGetTMConfigurationsWarning + invalidConfigurationParametersException.getMessage());
            return DGCExpert.BWSWSchedulingOutcome.ScienceGoalConfigurationIncompatible;
        }
        object = requiredConfigurations.getBest12mExtConfig();
        try {
            optional = this.getCalibratorFluxAtReferenceFrequency(scienceGoal, optional4, optional3, DGCExpert.DGCTypeEnum.DGCBandwidthSwitching);
        }
        catch (UnableToQueryCatalogueException unableToQueryCatalogueException) {
            Log.logger(DGCOnlineCalibratorExpert.class).warning(unableToDetermineCalibratorFluxAtRFWarning + unableToQueryCatalogueException.getMessage());
            return DGCExpert.BWSWSchedulingOutcome.Scheduled;
        }
        if (optional.isEmpty()) {
            return DGCExpert.BWSWSchedulingOutcome.NoCalibratorFoundInCatalogue;
        }
        AdjustedFluxValue adjustedFluxValue = optional.get();
        SingleFieldScienceGoalModel.ExtrapolatedFluxValues extrapolatedFluxValues = null;
        try {
            extrapolatedFluxValues = SingleFieldScienceGoalModel.getExtrapolatedFluxValues((Configuration)object, scienceGoal, Optional.empty(), adjustedFluxValue, adjustedFluxValue.getRf(), SingleFieldScienceGoalModel::getS_Antenna_ref);
        }
        catch (SourceNeverVisibleException | InvalidFrequencyException | UnableToDetermineCalibrationParametersException exception) {
            Log.logger(DGCOnlineCalibratorExpert.class).warning(unableToDetermineCalibratorFluxAtRFWarning + exception.getMessage());
            return DGCExpert.BWSWSchedulingOutcome.Scheduled;
        }
        Double d = adjustedFluxValue.getTimeAdjustedFlux();
        double d2 = d / extrapolatedFluxValues.getS_antenna();
        Optional<Object> optional5 = Optional.empty();
        if (scienceGoal.getExpertParametersCount() > 0) {
            optional5 = Stream.of(scienceGoal.getExpertParameters()).filter(keywordValue -> keywordValue.getKeyword().equals("BWSW")).map(keywordValue -> keywordValue.getValue()).findFirst();
        }
        if (testBWSWCalibrator.isPresent()) {
            switch (testBWSWCalibrator.get().ordinal()) {
                case 2: {
                    return DGCExpert.BWSWSchedulingOutcome.NotScheduled;
                }
                case 0: {
                    return DGCExpert.BWSWSchedulingOutcome.Scheduled;
                }
                case 1: {
                    return DGCExpert.BWSWSchedulingOutcome.BWSWWeakCalibratorFound;
                }
            }
            return DGCExpert.BWSWSchedulingOutcome.NotScheduled;
        }
        if (optional5.isPresent()) {
            switch (((String)optional5.get()).toLowerCase()) {
                case "nocalibrator": {
                    return DGCExpert.BWSWSchedulingOutcome.Scheduled;
                }
                case "weakcalibrator": {
                    return DGCExpert.BWSWSchedulingOutcome.BWSWWeakCalibratorFound;
                }
                case "strongcalibrator": {
                    return DGCExpert.BWSWSchedulingOutcome.NotScheduled;
                }
            }
            return DGCExpert.BWSWSchedulingOutcome.NotScheduled;
        }
        if (d2 < 15.0) {
            return DGCExpert.BWSWSchedulingOutcome.Scheduled;
        }
        if (15.0 <= d2 && d2 < 30.0) {
            return DGCExpert.BWSWSchedulingOutcome.BWSWWeakCalibratorFound;
        }
        return DGCExpert.BWSWSchedulingOutcome.NotScheduled;
    }

    private boolean findInBandCalibratorWithMaxBandwidth(@NonNull ScienceGoal scienceGoal, @NonNull Frequency frequency) {
        Configuration configuration;
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        if (frequency == null) {
            throw new NullPointerException("nonOverlappingBWOverride is marked non-null but is null");
        }
        if (MiscUtils.isForceBWSW()) {
            return true;
        }
        ReceiverBand receiverBand = scienceGoal.getReceiverBand();
        if (receiverBand == null || scienceGoal.isStandAloneACA()) {
            return false;
        }
        try {
            configuration = this.getConfigurationFromWhichToInformDGC(scienceGoal);
        }
        catch (InvalidConfigurationParametersException | SchedBlockExpert.UnableToDetermine12mCompactConfiguration exception) {
            Log.logger(DGCExpert.class).warning(unableToGetTMConfigurationsWarning + exception.getMessage());
            return false;
        }
        Optional<Object> optional = Optional.empty();
        Frequency frequency2 = scienceGoal.getSpectralSetupParameters().getRepresentativeFrequencyWithSkyOffset();
        try {
            optional = this.searchOnlineCalibratorCatalogueForInBandCalibrator(scienceGoal, frequency2, Optional.empty(), Optional.empty());
        }
        catch (UnableToQueryCatalogueException unableToQueryCatalogueException) {
            Log.logger(DGCOnlineCalibratorExpert.class).warning("Unable to query calibrator catalogue : " + unableToQueryCatalogueException.getMessage());
            return false;
        }
        if (optional.isEmpty()) {
            return false;
        }
        try {
            SingleFieldScienceGoalModel.ExtrapolatedFluxValues extrapolatedFluxValues = SingleFieldScienceGoalModel.getExtrapolatedFluxValues(configuration, scienceGoal, Optional.of(frequency), (AdjustedFluxValue)optional.get(), frequency2, SingleFieldScienceGoalModel::getS_Antenna);
            return ((AdjustedFluxValue)optional.get()).getTimeAdjustedFlux() >= extrapolatedFluxValues.getS_antenna();
        }
        catch (SourceNeverVisibleException | InvalidFrequencyException | UnableToDetermineCalibrationParametersException exception) {
            Log.logger(DGCOnlineCalibratorExpert.class).warning("Unable to determine s_rf and s_antenna: " + exception.getMessage());
            return false;
        }
    }

    private Frequency getMaxOverlappingBW(@NonNull ScienceGoal scienceGoal) {
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        ReceiverBand receiverBand = scienceGoal.getReceiverBand();
        if (receiverBand != null && ReceiverBand.isReceiverBandInSet(receiverBand, 9, 10) && scienceGoal.getSpectralSetupParameters().isWalshSwitching()) {
            return Frequency.createFrequencyGHZ(15.0);
        }
        return Frequency.createFrequencyGHZ(7.5);
    }

    private Configuration getConfigurationFromWhichToInformDGC(@NonNull ScienceGoal scienceGoal) throws InvalidConfigurationParametersException, SchedBlockExpert.UnableToDetermine12mCompactConfiguration {
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        RequiredConfigurations requiredConfigurations = null;
        PerformanceParameters performanceParameters = scienceGoal.getPerformanceParameters();
        requiredConfigurations = ConfigurationHelper.getRecommended12mConfigurations(scienceGoal, performanceParameters.getRepresentativeFrequency());
        return this.isTM2 ? requiredConfigurations.getTwelveMetreCompactConfig() : requiredConfigurations.getBest12mExtConfig();
    }

    public static void setTestBWSWCalibrator(Optional<DGCCalibratorType> optional) {
        testBWSWCalibrator = optional;
    }

    public static void setTestB2BCalibrator(Optional<DGCCalibratorType> optional) {
        testB2BCalibrator = optional;
    }

    public static class UnableToQueryCatalogueException
    extends Exception {
        public UnableToQueryCatalogueException(Exception exception) {
            super(exception);
        }

        public UnableToQueryCatalogueException(String string) {
            super(string);
        }
    }

    public class AdjustedFluxValue {
        private Measurement measurement;
        private Double fluxAtRF;
        private Double timeAdjustedFlux;
        private double noDaysAgoCalibratorWasObserved;
        private Frequency rf;

        public AdjustedFluxValue(DGCOnlineCalibratorExpert dGCOnlineCalibratorExpert) {
        }

        public Measurement getMeasurement() {
            return this.measurement;
        }

        public Double getFluxAtRF() {
            return this.fluxAtRF;
        }

        public Double getTimeAdjustedFlux() {
            return this.timeAdjustedFlux;
        }

        public double getNoDaysAgoCalibratorWasObserved() {
            return this.noDaysAgoCalibratorWasObserved;
        }

        public Frequency getRf() {
            return this.rf;
        }

        public void setMeasurement(Measurement measurement) {
            this.measurement = measurement;
        }

        public void setFluxAtRF(Double d) {
            this.fluxAtRF = d;
        }

        public void setTimeAdjustedFlux(Double d) {
            this.timeAdjustedFlux = d;
        }

        public void setNoDaysAgoCalibratorWasObserved(double d) {
            this.noDaysAgoCalibratorWasObserved = d;
        }

        public void setRf(Frequency frequency) {
            this.rf = frequency;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof AdjustedFluxValue)) {
                return false;
            }
            AdjustedFluxValue adjustedFluxValue = (AdjustedFluxValue)object;
            if (!adjustedFluxValue.canEqual(this)) {
                return false;
            }
            if (Double.compare(this.getNoDaysAgoCalibratorWasObserved(), adjustedFluxValue.getNoDaysAgoCalibratorWasObserved()) != 0) {
                return false;
            }
            Double d = this.getFluxAtRF();
            Double d2 = adjustedFluxValue.getFluxAtRF();
            if (d == null ? d2 != null : !((Object)d).equals(d2)) {
                return false;
            }
            Double d3 = this.getTimeAdjustedFlux();
            Double d4 = adjustedFluxValue.getTimeAdjustedFlux();
            if (d3 == null ? d4 != null : !((Object)d3).equals(d4)) {
                return false;
            }
            Measurement measurement = this.getMeasurement();
            Measurement measurement2 = adjustedFluxValue.getMeasurement();
            if (measurement == null ? measurement2 != null : !measurement.equals(measurement2)) {
                return false;
            }
            Frequency frequency = this.getRf();
            Frequency frequency2 = adjustedFluxValue.getRf();
            return !(frequency == null ? frequency2 != null : !((Object)((Object)frequency)).equals((Object)frequency2));
        }

        protected boolean canEqual(Object object) {
            return object instanceof AdjustedFluxValue;
        }

        public int hashCode() {
            int n = 1;
            long l = Double.doubleToLongBits(this.getNoDaysAgoCalibratorWasObserved());
            n = n * 59 + (int)(l >>> 32 ^ l);
            Double d = this.getFluxAtRF();
            n = n * 59 + (d == null ? 43 : ((Object)d).hashCode());
            Double d2 = this.getTimeAdjustedFlux();
            n = n * 59 + (d2 == null ? 43 : ((Object)d2).hashCode());
            Measurement measurement = this.getMeasurement();
            n = n * 59 + (measurement == null ? 43 : measurement.hashCode());
            Frequency frequency = this.getRf();
            n = n * 59 + (frequency == null ? 43 : ((Object)((Object)frequency)).hashCode());
            return n;
        }

        public String toString() {
            return "DGCOnlineCalibratorExpert.AdjustedFluxValue(measurement=" + String.valueOf(this.getMeasurement()) + ", fluxAtRF=" + this.getFluxAtRF() + ", timeAdjustedFlux=" + this.getTimeAdjustedFlux() + ", noDaysAgoCalibratorWasObserved=" + this.getNoDaysAgoCalibratorWasObserved() + ", rf=" + String.valueOf((Object)this.getRf()) + ")";
        }
    }

    public static enum DGCCalibratorType {
        NoCalibrator,
        WeakCalibrator,
        CalibratorStrong;

    }
}

