/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.calibration;

import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.services.calibration.BandpassCalObs;
import alma.obsprep.services.calibration.CalObs;
import alma.obsprep.services.calibration.CalType;
import alma.obsprep.services.calibration.PhaseCalObs;
import alma.obsprep.services.etc.SourceNeverVisibleException;
import alma.obsprep.services.experts.InvalidFrequencyException;
import alma.valuetypes.Flux;
import alma.valuetypes.Frequency;
import alma.valuetypes.Time;

public class PolarizationCalObs
extends CalObs {
    private PhaseCalObs phaseCalObs;
    private BandpassCalObs bandpassCalObs;
    private final Time TIME_INFINITY = Time.createTimeSec(Double.POSITIVE_INFINITY);

    public PolarizationCalObs() {
        this.setCalType(CalType.Polarization);
    }

    public PolarizationCalObs(ScienceGoal scienceGoal) {
        this();
        this.scienceGoal = scienceGoal;
        this.phaseCalObs = (PhaseCalObs)PolarizationCalObs.createCalObs(CalType.Phase, scienceGoal);
        this.phaseCalObs.setSNR(PolarizationCalObs.getCalObsProperties().getPolarizationCalSNR());
        this.bandpassCalObs = (BandpassCalObs)PolarizationCalObs.createCalObs(CalType.Bandpass, scienceGoal);
        this.configure();
    }

    private boolean isContinuumObs() {
        if (this.scienceGoal == null) {
            return true;
        }
        SpectralSetupParameters spectralSetupParameters = this.scienceGoal.getSpectralSetupParameters();
        if (spectralSetupParameters == null) {
            return true;
        }
        return spectralSetupParameters.isSingleContinuum();
    }

    @Override
    public boolean atmCalRequired(SchedBlock schedBlock) {
        return false;
    }

    @Override
    public Frequency getDefaultChannelWidth() {
        if (this.isContinuumObs()) {
            return this.phaseCalObs.getDefaultChannelWidth();
        }
        return this.bandpassCalObs.getDefaultChannelWidth();
    }

    @Override
    public double getDefaultSNR() {
        if (this.isContinuumObs()) {
            return this.phaseCalObs.getSNR();
        }
        return this.bandpassCalObs.getDefaultSNR();
    }

    @Override
    public Flux getDefaultFlux() {
        if (this.isContinuumObs()) {
            return this.phaseCalObs.getDefaultFlux();
        }
        return this.bandpassCalObs.getDefaultFlux();
    }

    @Override
    public Time calTime() throws InvalidFrequencyException, SourceNeverVisibleException {
        if (this.SBSuggestedCalibrationDefaultIntegrationTime != null) {
            return this.SBSuggestedCalibrationDefaultIntegrationTime;
        }
        if (this.isContinuumObs()) {
            return this.phaseCalObs.calTime();
        }
        return this.bandpassCalObs.calTime();
    }

    @Override
    public Time calTime(Time time) throws InvalidFrequencyException, SourceNeverVisibleException {
        if (this.isContinuumObs()) {
            this.phaseCalObs.setCalibratorFlux(this.getDefaultFlux());
            return this.phaseCalObs.calTime(time);
        }
        return this.bandpassCalObs.calTime(time);
    }

    @Override
    public boolean isExecutingRepeatedly() {
        return false;
    }

    @Override
    public Time cycleTime() {
        if (this.SBSuggestedCalibrationCycleTime != null) {
            return this.SBSuggestedCalibrationCycleTime;
        }
        return this.TIME_INFINITY;
    }
}

