/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.sciencegoals;

import alma.obsprep.bo.obsproject.OpticalPointingScienceGoal;
import alma.obsprep.bo.obsproject.OpticalPointingTargetParameters;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.editors.sciencegoals.TargetListEditor;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.swing.JTable;

public class TargetListModel
extends Model {
    private JTable opTable;

    public TargetListModel(Object object) {
        super(object);
    }

    public OpticalPointingScienceGoal getOpticalPointingScienceGoal() {
        return (OpticalPointingScienceGoal)this.getDocument();
    }

    public OpticalPointingScienceGoal getTableWidgetTableModel() {
        OpticalPointingScienceGoal opticalPointingScienceGoal = this.getOpticalPointingScienceGoal();
        if (opticalPointingScienceGoal == null) {
            opticalPointingScienceGoal = OpticalPointingScienceGoal.createOpticalPointingScienceGoal();
        }
        return opticalPointingScienceGoal;
    }

    @Override
    public void publish() {
        this.getTableWidgetTableModel().fireTableDataChanged();
        this.publish(TargetListEditor.opCountLabelFID, this.getOpticalPointingTargetParametersCount());
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        return object.toString();
    }

    @Override
    public void setDocument(Object object) {
        super.setDocument(object);
        if (object != null) {
            if (this.opTable != null) {
                this.opTable.setModel((OpticalPointingScienceGoal)object);
            }
            this.getTableWidgetTableModel().fireTableDataChanged();
        }
    }

    public void addOpticalPointingTargetParameters(int n) {
        OpticalPointingTargetParameters opticalPointingTargetParameters = OpticalPointingTargetParameters.createOpticalPointingTargetParameters();
        if (n == -1) {
            n = this.getOpticalPointingTargetParametersCount();
        }
        this.getOpticalPointingScienceGoal().addOpticalPointingTargetParameters(n, opticalPointingTargetParameters);
        this.getTableWidgetTableModel().fireTableRowsInserted(n, n);
    }

    public void deleteOpticalPointingTargetParameters(int n) {
        if (n != -1) {
            OpticalPointingTargetParameters opticalPointingTargetParameters = this.getOpticalPointingScienceGoal().getOpticalPointingTargetParameters(n);
            this.getOpticalPointingScienceGoal().removeOpticalPointingTargetParameters(opticalPointingTargetParameters);
            this.getTableWidgetTableModel().fireTableRowsDeleted(n, n);
        }
    }

    private void swapParams(int n, int n2) {
        OpticalPointingScienceGoal opticalPointingScienceGoal = this.getOpticalPointingScienceGoal();
        if (opticalPointingScienceGoal != null) {
            OpticalPointingTargetParameters opticalPointingTargetParameters = opticalPointingScienceGoal.getOpticalPointingTargetParameters(n2);
            opticalPointingScienceGoal.removeOpticalPointingTargetParameters(opticalPointingTargetParameters);
            opticalPointingScienceGoal.addOpticalPointingTargetParameters(n, opticalPointingTargetParameters);
            this.getTableWidgetTableModel().fireTableRowsUpdated(n, n2);
        }
    }

    public void upOpticalPointingTargetParameters(int n) {
        if (n > 0) {
            this.swapParams(n - 1, n);
        }
    }

    public void downOpticalPointingTargetParameters(int n) {
        if (n != -1 && n < this.getOpticalPointingTargetParametersCount() - 1) {
            this.swapParams(n, n + 1);
        }
    }

    public int getOpticalPointingTargetParametersCount() {
        return this.document == null ? 0 : this.getOpticalPointingScienceGoal().getOpticalPointingTargetParametersCount();
    }

    public void load(File file) throws IOException {
        this.getOpticalPointingScienceGoal().loadTargetList(file);
        this.publish();
    }

    public void loadFiltered(URL[] uRLArray) throws IOException {
        boolean bl = this.getOpticalPointingScienceGoal().loadFilteredTargetList(uRLArray);
        if (bl) {
            this.publish();
        }
    }

    public JTable getOpTable() {
        return this.opTable;
    }

    public void setOpTable(JTable jTable) {
        this.opTable = jTable;
    }
}

