/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.obsproject;

import alma.obsprep.bo.obsproject.Ellipse;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.boEditors.FieldIDs;
import alma.obsprep.ot.models.valuetypes.SkyCoordsModel;
import alma.obsprep.ot.models.valuetypes.ValueUnitPairModel;

public class EllipseModel
extends Model {
    private SkyCoordsModel centreModel = null;
    private ValueUnitPairModel semiMajorModel = null;
    private ValueUnitPairModel semiMinorModel = null;
    private ValueUnitPairModel paMajorModel = null;
    private ValueUnitPairModel spacingModel = null;
    public final FieldID semiMajorValueFID = new FieldID("Ellipse.semiMajor.value");
    public final FieldID semiMajorUnitFID = new FieldID("Ellipse.semiMajor.unit");
    public final FieldID semiMinorValueFID = new FieldID("Ellipse.semiMinor.value");
    public final FieldID semiMinorUnitFID = new FieldID("Ellipse.semiMinor.unit");
    public final FieldID paMajorValueFID = new FieldID("Ellipse.paMajor.value");
    public final FieldID paMajorUnitFID = new FieldID("Ellipse.paMajor.unit");
    public final FieldID spacingValueFID = new FieldID("Ellipse.spacing.value");
    public final FieldID spacingUnitFID = new FieldID("Ellipse.spacing.unit");

    public EllipseModel(Object object) {
        super(object);
        this.centreModel = new SkyCoordsModel(null);
        this.semiMajorModel = new ValueUnitPairModel(null, this.semiMajorValueFID, this.semiMajorUnitFID);
        this.semiMinorModel = new ValueUnitPairModel(null, this.semiMinorValueFID, this.semiMinorUnitFID);
        this.paMajorModel = new ValueUnitPairModel(null, this.paMajorValueFID, this.paMajorUnitFID);
        this.spacingModel = new ValueUnitPairModel(null, this.spacingValueFID, this.spacingUnitFID);
    }

    private Ellipse getShape() {
        return (Ellipse)((Object)this.getDocument());
    }

    public ValueUnitPairModel getPAMajorModel() {
        return this.paMajorModel;
    }

    @Override
    public void publish() {
        Ellipse ellipse = this.getShape();
        if (ellipse != null) {
            this.getCentreModel().publish();
            this.getSemiMajorModel().publish();
            this.getSemiMinorModel().publish();
            this.getPAMajorModel().publish();
            this.getSpacingModel().publish();
            this.publish(FieldIDs.nameFID, ellipse.getName());
        }
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        if (fieldID == FieldIDs.nameFID) {
            String string = (String)object;
            this.getShape().setName(string);
            return string;
        }
        return null;
    }

    @Override
    public void setDocument(Object object) {
        super.setDocument(object);
        Ellipse ellipse = this.getShape();
        this.getCentreModel().setDocument(ellipse.getCentre());
        this.getSemiMajorModel().setDocument((Object)ellipse.getSemiMajor());
        this.getSemiMinorModel().setDocument((Object)ellipse.getSemiMinor());
        this.getPAMajorModel().setDocument((Object)ellipse.getPAMajor());
        this.getSpacingModel().setDocument(ellipse.getSpacing());
    }

    public SkyCoordsModel getCentreModel() {
        return this.centreModel;
    }

    public ValueUnitPairModel getSemiMajorModel() {
        return this.semiMajorModel;
    }

    public ValueUnitPairModel getSemiMinorModel() {
        return this.semiMinorModel;
    }

    public ValueUnitPairModel getSpacingModel() {
        return this.spacingModel;
    }
}

