/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.gui.toplevel;

import alma.obsprep.ot.gui.factory.Table;
import alma.obsprep.ot.gui.feedback.ProblemTableModel;
import alma.obsprep.ot.gui.feedback.ProblemTableSelectionModel;
import alma.obsprep.ot.gui.resources.Icons;
import alma.obsprep.ot.gui.toplevel.GuiFactory;
import alma.obsprep.ot.valdef.ProblemListListener;
import alma.obsprep.problems.DefaultProblem;
import alma.obsprep.problems.Problem;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableRowSorter;
import lombok.NonNull;

class Problems
extends JPanel
implements ActionListener {
    private static final String COPYSINGLEROWCMD = "Copy Validation Issue";
    private static final String COPYALLROWSCMD = "Copy All Validation Issues";
    private final GuiFactory guiFactory;
    private ProblemTableModel model;
    private ProblemTableSelectionModel selectionModel;
    private final Table validationProblemTable;
    private final JLabel statusLabel;
    private final ProblemListListener titleMaker = problemListEvent -> {
        if (problemListEvent.getType() == 1064 || problemListEvent.getType() == 1065) {
            StringBuilder stringBuilder = new StringBuilder();
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < this.model.getSize(); ++i) {
                Problem problem = this.model.getProblemAt(i);
                if (problem.isError()) {
                    ++n;
                    continue;
                }
                if (!problem.isWarning()) continue;
                ++n2;
            }
            stringBuilder.append(n);
            stringBuilder.append(" error");
            if (n != 1) {
                stringBuilder.append('s');
            }
            stringBuilder.append(", ");
            stringBuilder.append(n2);
            stringBuilder.append(" warning");
            if (n2 != 1) {
                stringBuilder.append('s');
            }
            if (n2 > 0 || n > 0) {
                stringBuilder.append(" : double-click on each row to be taken to the problem");
            }
            this.setStatusText(stringBuilder.toString());
        }
    };
    private final TableCellRenderer htmlRenderer = new DefaultTableCellRenderer(){
        StringBuilder buffy = new StringBuilder(2048);

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.buffy.setLength(0);
            this.buffy.append("<html>");
            this.buffy.append(String.valueOf(object));
            this.buffy.append("</html>");
            String string = this.buffy.toString();
            Component component = super.getTableCellRendererComponent(jTable, string, bl, bl2, n, n2);
            ((JComponent)component).setToolTipText(string);
            return component;
        }
    };
    private final TableCellRenderer severityRenderer = new DefaultTableCellRenderer(){
        final String errorCaption = DefaultProblem.createError(null, null, null).getSeverity();
        final String warningCaption = DefaultProblem.createWarning(null, null, null).getSeverity();
        final String successCaption = DefaultProblem.createSuccess(null, null, null).getSeverity();
        final String infoCaption = DefaultProblem.createInfo(null, null, null).getSeverity();

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Icon icon = null;
            String string = String.valueOf(object);
            icon = string.equals(this.errorCaption) ? Icons.error : (string.equals(this.warningCaption) ? Icons.warning : (string.equals(this.infoCaption) ? Icons.info : (string.equals(this.successCaption) ? Icons.okay : null)));
            super.getTableCellRendererComponent(jTable, "", bl, bl2, n, n2);
            this.setIcon(icon);
            this.setToolTipText(string);
            return this;
        }
    };

    Problems(@NonNull GuiFactory guiFactory) {
        if (guiFactory == null) {
            throw new NullPointerException("guiFactory is marked non-null but is null");
        }
        this.guiFactory = guiFactory;
        this.setLayout(new BorderLayout());
        this.setOpaque(true);
        this.setBackground(new JEditorPane().getBackground());
        this.statusLabel = new JLabel(" ");
        this.add((Component)this.statusLabel, "North");
        this.model = new ProblemTableModel();
        this.validationProblemTable = new Table(this.model);
        this.validationProblemTable.getTableHeader().setReorderingAllowed(false);
        this.addCopyPopupMenu();
        JScrollPane jScrollPane = this.guiFactory.giveScrollPane(this.validationProblemTable);
        this.add((Component)jScrollPane, "Center");
    }

    private void addCopyPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(COPYALLROWSCMD);
        jPopupMenu.add(jMenuItem);
        jMenuItem.addActionListener(this);
        this.setComponentPopupMenu(jPopupMenu);
        JPopupMenu jPopupMenu2 = new JPopupMenu();
        JMenuItem jMenuItem2 = new JMenuItem(COPYSINGLEROWCMD);
        jMenuItem2.addActionListener(this);
        jPopupMenu2.add(jMenuItem2);
        jMenuItem = new JMenuItem(COPYALLROWSCMD);
        jMenuItem.addActionListener(this);
        jPopupMenu2.add(jMenuItem);
        this.validationProblemTable.setComponentPopupMenu(jPopupMenu2);
        this.validationProblemTable.addMouseListener(new TableMouseListener(this, this.validationProblemTable));
    }

    void setModel(ProblemTableModel problemTableModel) {
        if (this.model != null) {
            this.model.removeProblemListListener(this.titleMaker);
        }
        this.model = problemTableModel;
        this.validationProblemTable.setModel(this.model);
        this.validationProblemTable.setRowSorter(new TableRowSorter<ProblemTableModel>(this.model));
        this.selectionModel = new ProblemTableSelectionModel(this.model);
        this.validationProblemTable.setSelectionModel(this.selectionModel);
        this.model.addProblemListListener(this.titleMaker);
        this.setStatusText(" ");
        this.validationProblemTable.setDefaultRenderer(String.class, this.htmlRenderer);
        this.validationProblemTable.getColumn(" ").setCellRenderer(this.severityRenderer);
        this.validationProblemTable.getColumn(" ").setMaxWidth(25);
        this.validationProblemTable.getColumn("Description").setPreferredWidth(90);
        this.validationProblemTable.getColumn("Suggestion").setPreferredWidth(190);
    }

    void setStatusText(String string) {
        this.statusLabel.setText(string);
    }

    Problem get(int n) {
        int n2 = this.validationProblemTable.convertRowIndexToModel(n);
        return this.model.getProblemAt(n2);
    }

    void addTableActionListener(ActionListener actionListener) {
        this.validationProblemTable.addActionListener(actionListener);
    }

    int nextIndexInCycle(boolean bl) {
        return this.selectionModel.nextIndexInCycle(bl);
    }

    void setSelectedIndex(int n) {
        this.selectionModel.setSelectionInterval(n, n);
    }

    void doAction(int n) {
        this.validationProblemTable.doAction(n);
    }

    void scrollTo(int n) {
        Rectangle rectangle = this.validationProblemTable.getCellRect(n, 0, true);
        this.validationProblemTable.scrollRectToVisible(rectangle);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(COPYSINGLEROWCMD)) {
            this.copySingleRowInValidationTableToClipboard();
        } else if (string.equals(COPYALLROWSCMD)) {
            this.copyAllRowsInValidationTableToClipboard();
        }
    }

    private void copyAllRowsInValidationTableToClipboard() {
        int n = this.validationProblemTable.getRowCount();
        if (n == 0) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            String string = (String)this.validationProblemTable.getModel().getValueAt(i, 1);
            String string2 = (String)this.validationProblemTable.getModel().getValueAt(i, 2);
            stringBuilder.append("Description: " + string + "\nSuggestion: " + string2 + "\n");
        }
        StringSelection stringSelection = new StringSelection(stringBuilder.toString());
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
    }

    private void copySingleRowInValidationTableToClipboard() {
        int n = this.validationProblemTable.getSelectedRow();
        if (n == -1) {
            return;
        }
        String string = (String)this.validationProblemTable.getModel().getValueAt(n, 1);
        String string2 = (String)this.validationProblemTable.getModel().getValueAt(n, 2);
        StringSelection stringSelection = new StringSelection("Description: " + string + "\nSuggestion: " + string2);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
    }

    private class TableMouseListener
    extends MouseAdapter {
        private JTable table;

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            int n = this.table.rowAtPoint(mouseEvent.getPoint());
            this.table.setRowSelectionInterval(n, n);
        }

        public TableMouseListener(Problems problems, JTable jTable) {
            this.table = jTable;
        }
    }
}

