/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.sciencegoals;

import alma.obsprep.bo.enumerations.CorrBits;
import alma.obsprep.bo.enumerations.CorrFilter;
import alma.obsprep.bo.enumerations.CorrFraction;
import alma.obsprep.bo.enumerations.CorrPolarization;
import alma.obsprep.bo.enumerations.SpectralAverage;
import alma.obsprep.bo.obsproject.SpectralScan;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.schedblock.ConfigModeComparator;
import alma.obsprep.bo.schedblock.CorrConfigMode;
import alma.obsprep.bo.schedblock.OTConfigModeDecoder;
import alma.obsprep.guiutil.ScrollWhenFocusedPane;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.verifiers.SpectralScanRepresentativeFrequencyVerifier;
import alma.obsprep.guiutil.mvc.widgets.OTComboBox;
import alma.obsprep.guiutil.mvc.widgets.OTTextField;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.boEditors.NoTooltipForZeroFrequencyValidator;
import alma.obsprep.ot.editors.misc.UserEditRestrictionController;
import alma.obsprep.ot.editors.sciencegoals.SfiSpectralSetupEditor;
import alma.obsprep.ot.editors.sciencegoals.SpectralScanTuningsTable;
import alma.obsprep.ot.editors.valuetypes.ValueUnitPairEditor;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.models.sciencegoals.SfiScanSetupModel;
import alma.obsprep.ot.models.sciencegoals.SpectralSetupParametersModel;
import alma.obsprep.util.FrequencyRange;
import alma.valuetypes.Frequency;
import alma.valuetypes.UserFrequency;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;

public class SfiScanSetupEditor
extends EditorWithGridBagLayout {
    private BandwidthSpecificationComboBox bandwidthSelectorComboBox;
    private static final String REP_FREQ_MSG = "<html><P><BR>The representative frequency defined in the observed frame is used in conjunction with the sensitivity entered on the<br> 'Control and Performance' page to estimate the required observing time and to set the size of the antenna beam shown in<br>the 'Spatial Visual' editor. The representative frequency defaults to the average mid-frequency of the achieved scan range <br>but may be subsequently set by the user to any frequency within the achieved scan range.</html>";
    private final boolean collapse;
    private SpectralScanTuningsTable scanTuningsTable;
    private final OTTextField spectralScanRestFrameFeedback = new OTTextField();
    private OTTextField tuningsOverlapTextField;
    private ValueUnitPairEditor representativeFrequencyEditor;
    private final OTTextField achievedScanRangeFeedback = new OTTextField();

    public SfiScanSetupEditor(Model model2, boolean bl) {
        Model model3;
        this.collapse = bl;
        this.setModel(model2);
        this.build();
        if (model2 instanceof SfiScanSetupModel) {
            model3 = (SfiScanSetupModel)model2;
            model3.subscribe((arg_0, arg_1, arg_2) -> this.lambda$new$0((SfiScanSetupModel)model3, arg_0, arg_1, arg_2));
        }
        if ((model3 = model2.getParentModel()) instanceof SpectralSetupParametersModel) {
            model3.subscribe((model, fieldID, object) -> {
                if (fieldID.equals(SfiSpectralSetupEditor.FID_POLARIZATION)) {
                    this.getModel().setAutoUpdateSpectralAveraging(false);
                    this.updateBandwidthCombo();
                    this.getModel().setAutoUpdateSpectralAveraging(true);
                }
            });
        }
        model2.publish();
    }

    @Override
    public SfiScanSetupModel getModel() {
        return (SfiScanSetupModel)super.getModel();
    }

    public SfiScanSetupEditor(Model model) {
        this(model, false);
    }

    @Override
    protected JPanel addGroup(JComponent jComponent, String string) {
        if (this.collapse) {
            return super.addGroup(jComponent, string);
        }
        return (JPanel)this.addNonCollapsingGroup(jComponent, string);
    }

    @Override
    protected void build() {
        super.build("Spectral Scan Setup");
    }

    @Override
    protected void addComponents(String string) {
        SfiScanSetupModel sfiScanSetupModel = this.getModel();
        JPanel jPanel = this.createNewGroup();
        JPanel jPanel2 = this.createNewGroup();
        GridBagLayout gridBagLayout = this.createNewLayout(jPanel);
        GridBagLayout gridBagLayout2 = this.createNewLayout(jPanel2);
        GridBagConstraints gridBagConstraints = this.createNewConstraints();
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        this.addVerticalSpace(jPanel2, gridBagLayout2, gridBagConstraints, 10);
        JLabel jLabel = new JLabel("<html>Requested start frequency (sky)</html>");
        ValueUnitPairEditor valueUnitPairEditor = this.addValueUnitPair((JComponent)jPanel2, gridBagLayout2, gridBagConstraints, sfiScanSetupModel.getStartFrequencyModel(), jLabel, "Requested spectral scan start frequency (sky)");
        valueUnitPairEditor.setName("SfiScanEditor.startFrequency");
        NoTooltipForZeroFrequencyValidator noTooltipForZeroFrequencyValidator = new NoTooltipForZeroFrequencyValidator(valueUnitPairEditor, false);
        valueUnitPairEditor.setVerifier("FOCUSLOST_VERIFIER", noTooltipForZeroFrequencyValidator);
        JLabel jLabel2 = new JLabel("<html>Requested end frequency (sky)</html>");
        ValueUnitPairEditor valueUnitPairEditor2 = this.addValueUnitPair((JComponent)jPanel2, gridBagLayout2, gridBagConstraints, sfiScanSetupModel.getEndFrequencyModel(), jLabel2, "Requested spectral scan end frequency (sky)");
        valueUnitPairEditor2.setName("SfiScanEditor.endFrequency");
        noTooltipForZeroFrequencyValidator = new NoTooltipForZeroFrequencyValidator(valueUnitPairEditor2, false);
        valueUnitPairEditor2.setVerifier("FOCUSLOST_VERIFIER", noTooltipForZeroFrequencyValidator);
        JLabel jLabel3 = new JLabel("Requested range (rest)");
        jLabel3.setToolTipText("The requested spectral scan frequency range (rest)");
        this.spectralScanRestFrameFeedback.setToolTipText("The requested spectral scan frequency range (rest)");
        this.spectralScanRestFrameFeedback.setEditable(false);
        this.spectralScanRestFrameFeedback.setFocusable(false);
        jLabel3.setName("SfiScanEditor.spectralScanRestFrameFeedback");
        this.register(this.spectralScanRestFrameFeedback, SfiScanSetupModel.FEEDBACK_AREA_FID);
        this.addLabeledComponent((JComponent)jPanel2, gridBagLayout2, gridBagConstraints, jLabel3, (JComponent)this.spectralScanRestFrameFeedback);
        this.addVerticalSpace(jPanel2, gridBagLayout2, gridBagConstraints, 10);
        JLabel jLabel4 = new JLabel("Achieved scan range (sky)");
        jLabel4.setToolTipText("Achieved spectral scan frequency range (sky)");
        this.achievedScanRangeFeedback.setToolTipText("Achieved spectral scan frequency range (sky)");
        this.achievedScanRangeFeedback.setEditable(false);
        this.achievedScanRangeFeedback.setFocusable(false);
        this.achievedScanRangeFeedback.setName("SfiScanEditor.achievedSpectralScanRangeFeedback");
        this.register(this.achievedScanRangeFeedback, SfiScanSetupModel.SPECSCAN_ACHIEVED_SCAN_RANGE_FID);
        this.addLabeledComponent((JComponent)jPanel2, gridBagLayout2, gridBagConstraints, jLabel4, (JComponent)this.achievedScanRangeFeedback);
        this.addVerticalSpace(jPanel2, gridBagLayout2, gridBagConstraints, 10);
        this.bandwidthSelectorComboBox = new BandwidthSpecificationComboBox();
        this.initEvents(this.bandwidthSelectorComboBox, SfiScanSetupModel.SPECSCAN_BANDWIDTH);
        this.bandwidthSelectorComboBox.setName("SfiScanEditor.bandwidthSelector");
        this.bandwidthSelectorComboBox.setToolTipText("The bandwidth and spectral resolution after the application of smoothing and spectral averaging");
        this.addHorizontalSpace(jPanel2, gridBagLayout2, gridBagConstraints, 530);
        this.addLabeledComponent((JComponent)jPanel2, gridBagLayout2, gridBagConstraints, "Bandwidth, Resolution (Hanning smoothed)", (JComponent)this.bandwidthSelectorComboBox);
        this.addVerticalSpace(jPanel2, gridBagLayout2, gridBagConstraints, 10);
        OTComboBox oTComboBox = this.makeOTComboBox(SfiScanSetupModel.SPECSCAN_SPECTRAL_AVERAGING, SpectralAverage.getLabels(), "Spectral averaging factor which will be used to determine the delivered spectral resolution");
        this.addLabeledComponent((JComponent)jPanel2, gridBagLayout2, gridBagConstraints, "Spectral averaging", (JComponent)oTComboBox);
        this.addVerticalSpace(jPanel2, gridBagLayout2, gridBagConstraints, 10);
        this.tuningsOverlapTextField = new OTTextField();
        this.tuningsOverlapTextField.setName("SfiScanEditor.tuningOverlapField");
        this.tuningsOverlapTextField.setEditable(false);
        this.tuningsOverlapTextField.setToolTipText("<html>Approximate overlap between the discrete tunings than comprise the scan. </html>");
        this.representativeFrequencyEditor = new ValueUnitPairEditor(this.getModel().getRepresentativeFrequencyValueUnitPairModel());
        this.representativeFrequencyEditor.setName("SfiScanEditor.RepresentativeFrequency");
        this.representativeFrequencyEditor.setToolTipText("Representative frequency (sky). Defaults to the centre frequency of the achieved spectral scan frequency range.");
        this.registerSubView(this.representativeFrequencyEditor);
        SpectralScanRepresentativeFrequencyVerifier spectralScanRepresentativeFrequencyVerifier = new SpectralScanRepresentativeFrequencyVerifier(this.representativeFrequencyEditor, this.getModel());
        this.representativeFrequencyEditor.setVerifier("FOCUSLOST_VERIFIER", spectralScanRepresentativeFrequencyVerifier);
        this.addLabeledComponent((JComponent)jPanel2, gridBagLayout2, gridBagConstraints, "Representative frequency (sky)", (JComponent)this.representativeFrequencyEditor);
        gridBagConstraints = this.createNewConstraints();
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, jPanel2);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(0, 180, 0, 0);
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, new JLabel(REP_FREQ_MSG));
        this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints, 10);
        this.scanTuningsTable = new SpectralScanTuningsTable(this.getModel().getSpectralScanTuningTableModel());
        Dimension dimension = new Dimension(800, this.scanTuningsTable.getRowHeight() * SpectralScan.MAXTUNINGS);
        this.scanTuningsTable.setPreferredScrollableViewportSize(dimension);
        this.scanTuningsTable.setName("SfiScanEditor.tuningsTable");
        ScrollWhenFocusedPane scrollWhenFocusedPane = new ScrollWhenFocusedPane(this.scanTuningsTable);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(0, 120, 0, 120);
        gridBagConstraints.anchor = 17;
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, scrollWhenFocusedPane);
        this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints, 10);
        this.add(jPanel);
        UserEditRestrictionController.getInstance().registerUserChangeRestrictionAffectedComponents(Arrays.asList(valueUnitPairEditor.getInput(), valueUnitPairEditor.getUnits(), valueUnitPairEditor2.getInput(), valueUnitPairEditor2.getUnits(), jLabel3, jLabel, jLabel2));
    }

    private void updateBandwidthCombo() {
        OTConfigModeDecoder oTConfigModeDecoder = OTConfigModeDecoder.getInstance();
        SpectralSetupParameters spectralSetupParameters = (SpectralSetupParameters)((Object)this.getModel().getParentModel().getDocument());
        if (!spectralSetupParameters.isSpectralScan()) {
            return;
        }
        CorrPolarization corrPolarization = spectralSetupParameters.getCorrPolarization();
        Set<CorrConfigMode> set = oTConfigModeDecoder.findMode(corrPolarization);
        set = oTConfigModeDecoder.findMode(CorrFraction.FULL, false, set);
        if (corrPolarization.equals((Object)CorrPolarization.SINGLE_X) || corrPolarization.equals((Object)CorrPolarization.SINGLE_Y)) {
            set = oTConfigModeDecoder.findMode(CorrBits.B2x2, set);
        }
        set = oTConfigModeDecoder.findModeInBandwidthRange(Frequency.createFrequencyGHZ(2.0), Frequency.createFrequencyGHZ(0.45), set);
        this.bandwidthSelectorComboBox.setModeList(set);
        Frequency frequency = this.getModel().getSpectralScanCenterInSkyFrame();
        this.bandwidthSelectorComboBox.setFrequency(UserFrequency.createUserFrequency(frequency));
        this.bandwidthSelectorComboBox.reset(this.getModel().getCorrelatorMode());
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        if (object == null) {
            return;
        }
        if (fieldID.equals(SfiScanSetupModel.SPECSCAN_BANDWIDTH)) {
            CorrConfigMode corrConfigMode = null;
            if (object instanceof CorrConfigMode) {
                corrConfigMode = (CorrConfigMode)object;
            } else if (object instanceof String) {
                String string = (String)object;
                corrConfigMode = CorrConfigMode.fromString(string);
            }
            assert (corrConfigMode != null);
            boolean bl = corrConfigMode.getFilter().equals((Object)CorrFilter.TFB);
            JComponent jComponent = this.getComponent(SfiScanSetupModel.SPECSCAN_SPECTRAL_AVERAGING);
            jComponent.setEnabled(bl);
        }
        super.update(fieldID, object);
    }

    public static void main(String[] stringArray) {
        InitServices.initModelSupportClasses();
        SpectralScan spectralScan = SpectralScan.createSpectralScan();
        SfiScanSetupModel sfiScanSetupModel = new SfiScanSetupModel(spectralScan);
        SfiScanSetupEditor sfiScanSetupEditor = new SfiScanSetupEditor(sfiScanSetupModel);
        SfiScanSetupEditor.runTestApp(sfiScanSetupEditor);
    }

    private /* synthetic */ void lambda$new$0(SfiScanSetupModel sfiScanSetupModel, Model model, FieldID fieldID, Object object) {
        if (fieldID.equals(SfiScanSetupModel.SPECSCAN_SPECTRAL_AVERAGING)) {
            this.getModel().setAutoUpdateSpectralAveraging(false);
            this.updateBandwidthCombo();
            this.getModel().setAutoUpdateSpectralAveraging(true);
        }
        if (fieldID.equals(SfiScanSetupModel.SPECSCAN_STARTFREQ_VALUE_VUP) || fieldID.equals(SfiScanSetupModel.SPECSCAN_ENDFREQ_VALUE_VUP)) {
            FrequencyRange frequencyRange = sfiScanSetupModel.getSpectralScanInRestFrame();
            if (frequencyRange != null) {
                DecimalFormat decimalFormat = new DecimalFormat("#0.0000");
                this.spectralScanRestFrameFeedback.setText(decimalFormat.format(((Frequency)((Object)frequencyRange.min())).getContentInGHz()) + " GHz - " + decimalFormat.format(((Frequency)((Object)frequencyRange.max())).getContentInGHz()) + " GHz");
            } else {
                this.spectralScanRestFrameFeedback.setText("Unknown");
            }
            this.getModel().setAutoUpdateSpectralAveraging(false);
            this.updateBandwidthCombo();
            this.getModel().setAutoUpdateSpectralAveraging(true);
        }
        if (fieldID.equals(SfiScanSetupModel.AVERAGETUNINGOVERLAP) && object != null) {
            this.tuningsOverlapTextField.setText(((Frequency)((Object)object)).toString());
        }
    }

    private class BandwidthSpecificationComboBox
    extends JComboBox<String> {
        private List<CorrConfigMode> modeList = new ArrayList<CorrConfigMode>();
        private Comparator<CorrConfigMode> comparator;
        private UserFrequency frequency;

        public BandwidthSpecificationComboBox() {
            this.setRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                    if (bl) {
                        this.setBackground(jList.getSelectionBackground());
                        this.setForeground(jList.getSelectionForeground());
                    } else {
                        this.setBackground(jList.getBackground());
                        this.setForeground(jList.getForeground());
                    }
                    if (object != null) {
                        CorrConfigMode corrConfigMode = CorrConfigMode.fromString((String)object);
                        StringBuilder stringBuilder = new StringBuilder("<html>");
                        boolean bl3 = corrConfigMode.getFilter().equals((Object)CorrFilter.TDM);
                        if (bl3) {
                            stringBuilder.append("<B>");
                        }
                        stringBuilder.append(corrConfigMode.formatWindowDescription((Frequency)((Object)BandwidthSpecificationComboBox.this.frequency), SfiScanSetupEditor.this.getModel().getAdvancedWindowSetup()).replaceAll(" ", "&nbsp;"));
                        if (bl3) {
                            stringBuilder.append("</B>");
                        }
                        stringBuilder.append("</html>");
                        this.setText(stringBuilder.toString());
                    }
                    return this;
                }
            });
            ConfigModeComparator.Column[] columnArray = new ConfigModeComparator.Column[]{ConfigModeComparator.Column.BANDWIDTH, ConfigModeComparator.Column.RESOLUTION};
            this.comparator = new ConfigModeComparator(columnArray);
        }

        void setFrequency(UserFrequency userFrequency) {
            this.frequency = userFrequency;
        }

        void setModeList(Set<CorrConfigMode> set) {
            CorrConfigMode[] corrConfigModeArray = new CorrConfigMode[set.size()];
            this.setModeList(Arrays.asList(set.toArray(corrConfigModeArray)));
        }

        void setModeList(List<CorrConfigMode> list) {
            this.modeList = list;
            Collections.sort(list, this.comparator);
        }

        void reset(CorrConfigMode corrConfigMode) {
            Integer n = this.getSelectedIndex();
            Integer n2 = null;
            DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
            for (int i = 0; i < this.modeList.size(); ++i) {
                CorrConfigMode corrConfigMode2 = this.modeList.get(i);
                defaultComboBoxModel.addElement(corrConfigMode2.toString());
                if (corrConfigMode2 == corrConfigMode) {
                    n = i;
                }
                if (!corrConfigMode2.getFilter().equals((Object)CorrFilter.TDM)) continue;
                n2 = i;
            }
            if (!this.modeList.isEmpty()) {
                this.setModel(defaultComboBoxModel);
                if (n == -1 && n2 != null) {
                    n = n2;
                }
                try {
                    this.setSelectedIndex(n);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

