/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.schedblock;

import alma.obsprep.bo.obsproject.ScienceSpectralWindow;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.editors.misc.FrequencyParser;
import alma.obsprep.ot.editors.schedblock.SpectralElementComboBoxPairTestEditor;
import alma.obsprep.util.TextUtils;
import alma.valuetypes.Frequency;

class SpectralElementComboBoxPairTestModel
extends Model {
    private final FrequencyParser parser = new FrequencyParser();

    public SpectralElementComboBoxPairTestModel(Object object) {
        super(object);
    }

    public ScienceSpectralWindow getSpectralWindow() {
        return (ScienceSpectralWindow)this.getDocument();
    }

    @Override
    public void publish() {
        if (this.document == null) {
            return;
        }
        this.publish(SpectralElementComboBoxPairTestEditor.BANDWIDTH_FID, this.getSpectralWindow().getBandWidth());
        this.publish(SpectralElementComboBoxPairTestEditor.RESOLUTION_FID, this.getSpectralWindow().getSpectralResolution());
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        if (fieldID.equals(SpectralElementComboBoxPairTestEditor.BANDWIDTH_FID)) {
            Frequency frequency;
            String string = TextUtils.stripHtmlTags((String)object);
            try {
                frequency = this.parser.parse(string, Frequency.class);
                ScienceSpectralWindow scienceSpectralWindow = this.getSpectralWindow();
                scienceSpectralWindow.getBandWidth().setContent(frequency.getContent());
                scienceSpectralWindow.getBandWidth().setUnit(frequency.getUnit());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                frequency = Frequency.createFrequency();
            }
            return frequency;
        }
        if (fieldID.equals(SpectralElementComboBoxPairTestEditor.RESOLUTION_FID)) {
            Frequency frequency;
            String string = TextUtils.stripHtmlTags((String)object);
            try {
                frequency = this.parser.parse(string, Frequency.class);
                ScienceSpectralWindow scienceSpectralWindow = this.getSpectralWindow();
                scienceSpectralWindow.getSpectralResolution().setContent(frequency.getContent());
                scienceSpectralWindow.getSpectralResolution().setUnit(frequency.getUnit());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                frequency = Frequency.createFrequency();
            }
            return frequency;
        }
        return object;
    }
}

