/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.jointproposals;

import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.obsprep.bo.obsproposal.JointProposal;
import alma.obsprep.bo.obsproposal.JointProposalPartner;
import alma.obsprep.guiutil.ColumnResizer;
import alma.obsprep.ot.editors.jointproposals.JointProposalTableModel;
import alma.obsprep.ot.editors.misc.ValueUnitPairCellEditor;
import alma.obsprep.ot.gui.factory.Table;
import alma.obsprep.ot.gui.resources.Icons;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.models.obsproject.JointProposalModel;
import alma.valuetypes.Time;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import lombok.NonNull;

public class JointProposalTable
extends Table {
    public static final int TABLE_WIDTH = 700;
    private TableColumn mainObservatoryColumn = null;

    public JointProposalTable(TableModel tableModel) {
        super(tableModel);
        this.setSelectionMode(0);
        this.setColumnSelectionAllowed(false);
        this.getTableHeader().setReorderingAllowed(false);
        this.setPreferredScrollableViewportSize(new Dimension(700, 80));
        this.setupTableCellEditors();
        this.setupTableCellRenderers();
    }

    private void setupTableCellRenderers() {
        TableColumn tableColumn = this.getColumnModel().getColumn(JointProposalTableModel.ColumnDescriptor.REQUESTED_TIME_COLUMN.getColumnIndex());
        tableColumn.setCellRenderer((jTable, object, bl, bl2, n, n2) -> {
            JLabel jLabel = new JLabel();
            if (object != null) {
                Time time = (Time)object;
                jLabel.setText(String.format("%.2f %s", time.getContentInUnits(time.getUnit()), time.getUnit()));
            }
            return jLabel;
        });
        TableColumn tableColumn2 = this.getColumnModel().getColumn(JointProposalTableModel.ColumnDescriptor.OBSERVATORY_COLUMN.getColumnIndex());
        tableColumn2.setCellRenderer((jTable, object, bl, bl2, n, n2) -> {
            GridBagLayout gridBagLayout = new GridBagLayout();
            JPanel jPanel = new JPanel(gridBagLayout);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            JLabel jLabel = new JLabel();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            if (object != null) {
                jLabel.setText((String)object);
            }
            jPanel.add(jLabel);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.anchor = 17;
            JLabel jLabel2 = new JLabel(Icons.downChevron);
            gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
            jPanel.add(jLabel2);
            return jPanel;
        });
    }

    private JointProposalTableModel getMyModel() {
        return (JointProposalTableModel)this.getModel();
    }

    private void setupTableCellEditors() {
        TableColumn tableColumn = this.getColumnModel().getColumn(JointProposalTableModel.ColumnDescriptor.PROJECT_CODE_COLUMN.getColumnIndex());
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(new JTextField());
        defaultCellEditor.setClickCountToStart(2);
        tableColumn.setCellEditor(defaultCellEditor);
        TableColumn tableColumn2 = this.getColumnModel().getColumn(JointProposalTableModel.ColumnDescriptor.OBSERVATORY_COLUMN.getColumnIndex());
        String[] stringArray = AlmaPolicies.getInstance().getKnownPartnerObservatories();
        defaultCellEditor = new DefaultCellEditor(new JComboBox<String>(stringArray));
        defaultCellEditor.setClickCountToStart(2);
        tableColumn2.setCellEditor(defaultCellEditor);
        TableColumn tableColumn3 = this.getColumnModel().getColumn(JointProposalTableModel.ColumnDescriptor.REQUESTED_TIME_COLUMN.getColumnIndex());
        defaultCellEditor = new ValueUnitPairCellEditor.NonNegativeTimeEditor();
        defaultCellEditor.setClickCountToStart(2);
        tableColumn3.setCellEditor(defaultCellEditor);
        ColumnResizer.initColumnSizes(this, this.getMyModel().getLongValues());
    }

    public void setMainObservatoryColumnVisibility(boolean bl) {
        boolean bl2;
        TableColumnModel tableColumnModel = this.getColumnModel();
        int n = JointProposalTableModel.ColumnDescriptor.MAIN_OBSERVATORY_COLUMN.columnIndex;
        boolean bl3 = bl2 = tableColumnModel.getColumnCount() == n + 1;
        if (bl && bl2) {
            this.mainObservatoryColumn = tableColumnModel.getColumn(n);
            this.removeColumn(this.mainObservatoryColumn);
        } else if (!bl && !bl2 && this.mainObservatoryColumn != null) {
            this.addColumn(this.mainObservatoryColumn);
        }
    }

    public static void main(String[] stringArray) {
        InitServices.initModelSupportClasses();
        JointProposalPartner jointProposalPartner = JointProposalPartner.createJointProposalPartner();
        jointProposalPartner.setIsMainObservatory(true);
        jointProposalPartner.setObservatory("JWST");
        jointProposalPartner.setProjectCode("2022.2");
        jointProposalPartner.setRequestedTime(Time.createTimeMin(200.0));
        JointProposal jointProposal = JointProposal.createJointProposal();
        jointProposal.addJointProposalPartner(jointProposalPartner);
        jointProposalPartner = JointProposalPartner.createJointProposalPartner();
        jointProposalPartner.setIsMainObservatory(false);
        jointProposalPartner.setObservatory("VLA");
        jointProposalPartner.setProjectCode("2022.2");
        jointProposalPartner.setRequestedTime(Time.createTimeMin(200.0));
        jointProposal.addJointProposalPartner(jointProposalPartner);
        @NonNull JointProposalModel jointProposalModel = new JointProposalModel((Object)jointProposal);
        JointProposalTableModel jointProposalTableModel = new JointProposalTableModel(jointProposalModel);
        jointProposalModel.setJointProposalTableModel(jointProposalTableModel);
        JointProposalTable jointProposalTable = new JointProposalTable(jointProposalTableModel);
        JDialog jDialog = new JDialog(new JFrame(), "Joint proposal table", true);
        jDialog.setLayout(new FlowLayout());
        jDialog.add(jointProposalTable);
        jDialog.setSize(700, 500);
        jDialog.setVisible(true);
    }
}

