/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.guiutil.mvc.examples;

import alma.obsprep.guiutil.mvc.widgets.IndeterminateProgressMonitor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Random;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;

public class IndeterminateProgressMonitorDemo
extends JPanel
implements ActionListener,
PropertyChangeListener {
    private IndeterminateProgressMonitor progressMonitor;
    private JButton startButton = new JButton("Start");
    private JTextArea taskOutput;
    private Task task;

    public IndeterminateProgressMonitorDemo() {
        super(new BorderLayout());
        this.startButton.setActionCommand("start");
        this.startButton.addActionListener(this);
        this.taskOutput = new JTextArea(5, 20);
        this.taskOutput.setMargin(new Insets(12, 12, 11, 11));
        this.taskOutput.setEditable(false);
        this.add((Component)this.startButton, "First");
        this.add((Component)new JScrollPane(this.taskOutput), "Center");
        this.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.progressMonitor = new IndeterminateProgressMonitor(this, "Running a Long Task", "");
        this.task = new Task();
        this.task.addPropertyChangeListener(this);
        this.task.addPropertyChangeListener(this.progressMonitor);
        this.progressMonitor.addPropertyChangeListener(this);
        this.task.execute();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("progress")) {
            int n = (Integer)propertyChangeEvent.getNewValue();
            String string2 = String.format("Completed %d%%.\n", n);
            this.taskOutput.append(string2);
            this.progressMonitor.isCancelled();
        } else if (string.equals("IPM_CANCELLED")) {
            this.task.cancel(true);
            this.taskOutput.append("Task cancelled.\n");
            this.startButton.setEnabled(true);
        }
    }

    private static void createAndShowGUI() {
        JFrame jFrame = new JFrame("IndeterminateProgressMonitorDemo");
        jFrame.setDefaultCloseOperation(3);
        IndeterminateProgressMonitorDemo indeterminateProgressMonitorDemo = new IndeterminateProgressMonitorDemo();
        indeterminateProgressMonitorDemo.setOpaque(true);
        jFrame.setContentPane(indeterminateProgressMonitorDemo);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                IndeterminateProgressMonitorDemo.createAndShowGUI();
            }
        });
    }

    class Task
    extends SwingWorker<Void, Void> {
        Task() {
        }

        @Override
        public Void doInBackground() {
            Random random = new Random();
            int n = 0;
            this.setProgress(0);
            try {
                Thread.sleep(1000L);
                while (n < 100 && !this.isCancelled()) {
                    Thread.sleep(random.nextInt(1000));
                    this.setProgress(Math.min(n += random.nextInt(10), 100));
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return null;
        }

        @Override
        public void done() {
            IndeterminateProgressMonitorDemo.this.startButton.setEnabled(true);
        }
    }
}

