/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.guiutil.mvc;

import alma.obsprep.guiutil.mvc.AutoModel;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.verifiers.DoubleVerifier;
import alma.obsprep.guiutil.mvc.verifiers.IntegerVerifier;
import alma.obsprep.guiutil.mvc.verifiers.Verifier;
import java.lang.reflect.Method;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class AutoEditor
extends Editor {
    AutoModel model = null;

    public AutoEditor(AutoModel autoModel) {
        this.model = autoModel;
        super.setModel(autoModel);
        this.build();
    }

    @Override
    protected void build() {
        for (int i = 0; i < this.model.getPropCount(); ++i) {
            Method method = this.model.getSetter(i);
            String string = method.getName().substring(3);
            FieldID fieldID = this.model.getFieldID(i);
            Class clazz = this.model.getSetterArg(i);
            JLabel jLabel = new JLabel(string);
            JTextField jTextField = null;
            Verifier verifier = null;
            if (clazz == Integer.TYPE || clazz == Short.TYPE || clazz == Long.TYPE) {
                jTextField = var9_9 = new JTextField();
                verifier = new IntegerVerifier(this, (JTextField)var9_9);
                this.initEvents((JTextField)var9_9, fieldID, "KEYSTROKE_VERIFIER", verifier);
            } else if (clazz == Float.TYPE || clazz == Double.TYPE) {
                jTextField = var9_9 = new JTextField();
                verifier = new DoubleVerifier(this, (JTextField)var9_9);
                this.initEvents((JTextField)var9_9, fieldID, "KEYSTROKE_VERIFIER", verifier);
            } else if (clazz == String.class || clazz == Character.TYPE) {
                var9_9 = new JTextField();
                if (clazz == Character.TYPE) {
                    var9_9.setColumns(1);
                }
                jTextField = var9_9;
                this.initEvents((JTextField)var9_9, fieldID);
            } else {
                if (clazz != Boolean.TYPE) continue;
                jTextField = var9_9 = new JCheckBox();
                this.initEvents((JCheckBox)var9_9, fieldID);
            }
            this.addLabeledWidget(jLabel, jTextField);
        }
        this.layoutLabeledWidgets();
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        int n = this.model.getPropCount();
        int n2 = -1;
        for (int i = 0; i < n; ++i) {
            if (!this.model.getFieldID(i).equals(fieldID)) continue;
            n2 = i;
            break;
        }
        Method method = this.model.getSetter(n2);
        Class clazz = this.model.getSetterArg(n2);
        JComponent jComponent = this.getComponent(fieldID);
        if (clazz == Integer.TYPE || clazz == Short.TYPE || clazz == Long.TYPE || clazz == Float.TYPE || clazz == Double.TYPE || clazz == String.class || clazz == Character.TYPE) {
            JTextField jTextField = (JTextField)jComponent;
            this.set((JComponent)jTextField, object);
        } else if (clazz == Boolean.TYPE) {
            JCheckBox jCheckBox = (JCheckBox)jComponent;
            Boolean bl = (Boolean)object;
            this.set(jCheckBox, bl);
        } else {
            throw new RuntimeException("Unknown setter arg class " + String.valueOf(clazz));
        }
    }
}

