/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.schedblock;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.enumerations.CorrPolarization;
import alma.obsprep.bo.enumerations.SpectralAverage;
import alma.obsprep.bo.obsproject.AdvancedWindowSetup;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.schedblock.CorrConfigMode;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.valuetypes.StorageVolume;

public class DataRateCalculation {
    private static final int NO_OF_OUTPUT_STREAMS = 1;
    public static final int BYTES_PER_VISIBILITY = 4;
    private final Array arrayForDataCalculation;

    public StorageVolume getSpectralWindowDataVolumePerInteg(CorrConfigMode corrConfigMode, AdvancedWindowSetup advancedWindowSetup, SpectralSetupParameters spectralSetupParameters) throws ReceiverBand.ReceiverNotFoundException {
        if (!corrConfigMode.isValid()) {
            return StorageVolume.createStorageVolume();
        }
        CorrPolarization corrPolarization = corrConfigMode.getPolarization();
        int n = corrConfigMode.getEffectiveChannels();
        SpectralAverage spectralAverage = SpectralAverage.getValue(advancedWindowSetup.getSmoothingFactor());
        StorageVolume storageVolume = StorageVolume.createStorageVolume((double)1300.0, (String)StorageVolume.UNIT_B);
        storageVolume = (StorageVolume)storageVolume.plus((AbstractDoubleWithUnit)((StorageVolume)this.getSpectralWindowDataVolumePerInteg(corrPolarization, n, spectralSetupParameters).divide(spectralAverage.getDataRateScalingFactor())));
        if (spectralSetupParameters.isWalshSwitching() && (advancedWindowSetup.getUseImage() || spectralSetupParameters.isSingleContinuum() || spectralSetupParameters.isSpectralScan())) {
            storageVolume = (StorageVolume)storageVolume.multiply(2.0);
        }
        return storageVolume;
    }

    private StorageVolume getSpectralWindowDataVolumePerInteg(CorrPolarization corrPolarization, int n, SpectralSetupParameters spectralSetupParameters) throws ReceiverBand.ReceiverNotFoundException {
        int n2 = corrPolarization.getProductsCount();
        StorageVolume storageVolume = StorageVolume.createStorageVolume((double)(4 * n2 * n), (String)StorageVolume.UNIT_B);
        storageVolume = storageVolume.times(1 * this.getDataMultiplier(spectralSetupParameters));
        storageVolume.convertToUnit(StorageVolume.UNIT_MB);
        return storageVolume;
    }

    private int getDataMultiplier(SpectralSetupParameters spectralSetupParameters) throws ReceiverBand.ReceiverNotFoundException {
        return this.arrayForDataCalculation.isInterferometry() ? this.getNumBaselines(spectralSetupParameters) : this.getNumAntennasForDataRates(spectralSetupParameters);
    }

    private int getNumBaselines(SpectralSetupParameters spectralSetupParameters) throws ReceiverBand.ReceiverNotFoundException {
        int n = this.getNumAntennasForDataRates(spectralSetupParameters);
        return n * (n - 1) / 2;
    }

    private int getNumAntennasForDataRates(SpectralSetupParameters spectralSetupParameters) throws ReceiverBand.ReceiverNotFoundException {
        return this.arrayForDataCalculation.getNumberAntennasForDataRates(spectralSetupParameters);
    }

    public DataRateCalculation(Array array) {
        this.arrayForDataCalculation = array;
    }
}

