/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.obsproject;

import alma.obsprep.bo.enumerations.CorrPolarization;
import alma.obsprep.bo.obsproject.ExpectedPropertiesElements;
import alma.obsprep.bo.obsproject.SingleContinuumNonOverlappingBandwidthCalculator;
import alma.obsprep.bo.obsproject.SpectralLineNonOverlappingBandwidthCalculator;
import alma.obsprep.bo.obsproject.SpectralScanNonOverlappingBandwidthCalculator;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.valuetypes.Frequency;
import alma.valuetypes.Velocity;
import lombok.NonNull;

public abstract class NonOverlappingBandwidthCalculator {
    protected SpectralSetupParameters ssp;
    protected Velocity sourceVelocity;

    protected NonOverlappingBandwidthCalculator(SpectralSetupParameters spectralSetupParameters, Velocity velocity) {
        this.ssp = spectralSetupParameters;
        this.sourceVelocity = velocity;
    }

    public static NonOverlappingBandwidthCalculator getCalculator(@NonNull SpectralSetupParameters spectralSetupParameters, @NonNull TargetParameters targetParameters) {
        if (spectralSetupParameters == null) {
            throw new NullPointerException("ssp is marked non-null but is null");
        }
        if (targetParameters == null) {
            throw new NullPointerException("tp is marked non-null but is null");
        }
        Velocity velocity = targetParameters.getSourceVelocity();
        if (spectralSetupParameters.isSingleContinuum()) {
            return new SingleContinuumNonOverlappingBandwidthCalculator(spectralSetupParameters, velocity);
        }
        if (spectralSetupParameters.isSpectralScan()) {
            return new SpectralScanNonOverlappingBandwidthCalculator(spectralSetupParameters, velocity);
        }
        return new SpectralLineNonOverlappingBandwidthCalculator(spectralSetupParameters, velocity);
    }

    public static NonOverlappingBandwidthCalculator getCalculator(@NonNull SpectralSetupParameters spectralSetupParameters, @NonNull ExpectedPropertiesElements expectedPropertiesElements) {
        if (spectralSetupParameters == null) {
            throw new NullPointerException("ssp is marked non-null but is null");
        }
        if (expectedPropertiesElements == null) {
            throw new NullPointerException("epe is marked non-null but is null");
        }
        Velocity velocity = expectedPropertiesElements.velocity;
        if (spectralSetupParameters.isSingleContinuum()) {
            return new SingleContinuumNonOverlappingBandwidthCalculator(spectralSetupParameters, velocity);
        }
        if (spectralSetupParameters.isSpectralScan()) {
            return new SpectralScanNonOverlappingBandwidthCalculator(spectralSetupParameters, velocity);
        }
        return new SpectralLineNonOverlappingBandwidthCalculator(spectralSetupParameters, velocity);
    }

    public Frequency calculate() {
        Frequency frequency = this.calculatePerPoln();
        if (frequency == null) {
            return null;
        }
        CorrPolarization corrPolarization = CorrPolarization.getCorrPolarization(this.ssp.getPolarisation());
        return (Frequency)frequency.multiply(corrPolarization.getObsCount());
    }

    public abstract Frequency calculatePerPoln();
}

