/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.component.client;

import alma.JavaContainerError.wrappers.AcsJContainerServicesEx;
import alma.acs.component.client.ManagerClient;
import alma.acs.concurrent.DaemonThreadFactory;
import alma.acs.container.AcsManagerProxy;
import alma.acs.container.CleaningDaemonThreadFactory;
import alma.acs.container.ContainerServices;
import alma.acs.container.ContainerServicesBase;
import alma.acs.container.ContainerServicesImpl;
import alma.acs.container.corba.AcsCorba;
import alma.acs.logging.AcsLogger;
import alma.acs.logging.ClientLogManager;
import alma.acs.logging.engine.LogReceiver;
import alma.acs.util.ACSPorts;
import alma.alarmsystem.source.ACSAlarmSystemInterfaceFactory;
import com.cosylab.CDB.DAL;
import com.cosylab.CDB.DALHelper;
import java.util.logging.Level;
import java.util.logging.Logger;
import junit.framework.TestCase;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.PortableServer.POA;
import si.ijs.maci.Client;

public class ComponentClientTestCase
extends TestCase {
    protected AcsCorba acsCorba;
    private ContainerServicesImpl m_containerServices;
    private CleaningDaemonThreadFactory m_threadFactory;
    protected AcsManagerProxy m_acsManagerProxy;
    protected AcsLogger m_logger;
    private LogReceiver logReceiver;
    protected String m_managerLoc;
    private ManagerClient managerClientImpl;
    private Client m_managerClient;
    private String m_namePrefix;

    public ComponentClientTestCase(String name) throws Exception {
        super(name);
        this.m_namePrefix = name;
    }

    protected void runTest() throws Throwable {
        try {
            super.runTest();
        }
        catch (Throwable thr) {
            if (this.m_logger != null) {
                this.m_logger.log(Level.WARNING, "JUnit test error in " + this.getFullName(), thr);
            }
            throw thr;
        }
    }

    protected void setUp() throws Exception {
        this.m_logger = ClientLogManager.getAcsLogManager().getLoggerForApplication(this.getFullName(), true);
        this.m_logger.info("-------------------------------");
        this.m_logger.info("ComponentClientTestCase#setUp()");
        POA rootPOA = null;
        try {
            this.acsCorba = new AcsCorba(this.m_logger);
            rootPOA = this.acsCorba.initCorbaForClient(false);
            this.connectToManager();
            DAL cdb = DALHelper.narrow((Object)this.m_acsManagerProxy.get_service("CDB", false));
            this.m_threadFactory = new CleaningDaemonThreadFactory(this.m_namePrefix, (Logger)this.m_logger);
            this.m_containerServices = new ContainerServicesImpl(this, this.m_acsManagerProxy, cdb, rootPOA, this.acsCorba, this.m_logger, this.m_acsManagerProxy.getManagerHandle(), ((java.lang.Object)((java.lang.Object)this)).getClass().getName(), null, this.m_threadFactory){

                @Override
                public AcsLogger getLogger() {
                    return this.m_logger;
                }
            };
            this.managerClientImpl.setContainerServices(this.m_containerServices);
            this.initRemoteLogging();
            ACSAlarmSystemInterfaceFactory.init((ContainerServicesBase)this.m_containerServices);
        }
        catch (Exception ex1) {
            this.m_logger.log(Level.SEVERE, "failed to initialize the ORB, or connect to the ACS Manager, or to set up the container services.", (Throwable)ex1);
            if (this.acsCorba != null) {
                try {
                    this.acsCorba.shutdownORB(true, false);
                    this.acsCorba.doneCorba();
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            throw ex1;
        }
    }

    protected void connectToManager() throws Exception {
        if (System.getProperty("ACS.manager") != null) {
            this.m_managerLoc = System.getProperty("ACS.manager").trim();
        } else {
            String host = ACSPorts.getIP();
            this.m_managerLoc = "corbaloc::" + host + ":" + ACSPorts.getManagerPort() + "/Manager";
        }
        this.managerClientImpl = new ManagerClient(this.getFullName(), (Logger)this.m_logger){

            @Override
            public void disconnect() {
                ComponentClientTestCase.this.m_logger.info("disconnected from manager");
                ComponentClientTestCase.this.m_acsManagerProxy.logoutFromManager();
                ComponentClientTestCase.this.m_acsManagerProxy = null;
                throw new RuntimeException("disconnected from the manager");
            }
        };
        ORB orb = this.acsCorba.getORB();
        this.m_managerClient = this.managerClientImpl._this(orb);
        this.m_acsManagerProxy = new AcsManagerProxy(this.m_managerLoc, orb, (Logger)this.m_logger);
        this.m_acsManagerProxy.loginToManager(this.m_managerClient, 1);
    }

    protected String getFullName() {
        String fullName = this.m_namePrefix + "#" + this.getName();
        return fullName;
    }

    protected ContainerServices getContainerServices() {
        return this.m_containerServices;
    }

    protected void tearDown() throws Exception {
        block6: {
            try {
                this.m_acsManagerProxy.shutdownNotify();
                this.m_containerServices.releaseAllComponents();
                ACSAlarmSystemInterfaceFactory.done();
                if (this.logReceiver != null && this.logReceiver.isInitialized()) {
                    this.logReceiver.stop();
                }
                this.m_containerServices.cleanUp();
                this.m_acsManagerProxy.logoutFromManager();
                ClientLogManager.getAcsLogManager().shutdown(true);
                this.m_threadFactory.cleanUp();
                if (this.acsCorba == null) break block6;
                this.acsCorba.shutdownORB(true, false);
            }
            catch (Exception e) {
                try {
                    System.err.println("Exception in tearDown: ");
                    e.printStackTrace(System.err);
                    throw e;
                }
                catch (Throwable throwable) {
                    this.m_threadFactory.cleanUp();
                    if (this.acsCorba != null) {
                        this.acsCorba.shutdownORB(true, false);
                        Thread destroyThread = new DaemonThreadFactory("OrbDestroy").newThread(new Runnable(){

                            @Override
                            public void run() {
                                ComponentClientTestCase.this.acsCorba.doneCorba();
                            }
                        });
                        destroyThread.start();
                        destroyThread.join(20000L);
                    }
                    Thread.sleep(1000L);
                    throw throwable;
                }
            }
            Thread destroyThread = new DaemonThreadFactory("OrbDestroy").newThread(new /* invalid duplicate definition of identical inner class */);
            destroyThread.start();
            destroyThread.join(20000L);
        }
        Thread.sleep(1000L);
    }

    protected void initRemoteLogging() {
        java.lang.Object errMsg = null;
        try {
            if (!ClientLogManager.getAcsLogManager().initRemoteLogging(this.acsCorba.getORB(), this.m_acsManagerProxy.getManager(), this.m_acsManagerProxy.getManagerHandle(), false)) {
                errMsg = "ACS central logging not available. ";
            }
        }
        catch (Throwable thr) {
            errMsg = "ACS central logging not available. Failed with unexpected error " + thr.toString();
        }
        if (errMsg != null) {
            ClientLogManager.getAcsLogManager().suppressRemoteLogging();
            this.m_logger.warning((String)errMsg);
        }
    }

    protected LogReceiver getLogReceiver() throws AcsJContainerServicesEx {
        if (this.logReceiver == null) {
            boolean initOk = false;
            try {
                this.logReceiver = new LogReceiver();
                initOk = this.logReceiver.initialize(this.acsCorba.getORB(), this.m_acsManagerProxy.getManager(), 20);
            }
            catch (Throwable thr) {
                AcsJContainerServicesEx ex = new AcsJContainerServicesEx(thr);
                ex.setContextInfo("Failed to obtain an initialized LogReceiver.");
                throw ex;
            }
            if (!initOk) {
                AcsJContainerServicesEx ex = new AcsJContainerServicesEx();
                ex.setContextInfo("LogReceiver failed to initialize within 20 seconds.");
                throw ex;
            }
        }
        return this.logReceiver;
    }
}

