/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.reader;

import org.exolab.castor.xml.AttributeSet;
import org.exolab.castor.xml.Namespaces;
import org.exolab.castor.xml.XMLException;
import org.exolab.castor.xml.schema.Annotation;
import org.exolab.castor.xml.schema.AttributeDecl;
import org.exolab.castor.xml.schema.Form;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SchemaContext;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.castor.xml.schema.reader.AnnotationUnmarshaller;
import org.exolab.castor.xml.schema.reader.ComponentReader;
import org.exolab.castor.xml.schema.reader.SimpleTypeUnmarshaller;

public class AttributeUnmarshaller
extends ComponentReader {
    private ComponentReader unmarshaller;
    private int depth = 0;
    private AttributeDecl _attribute = null;
    private Schema _schema = null;
    private boolean foundAnnotation = false;
    private boolean foundSimpleType = false;

    public AttributeUnmarshaller(SchemaContext schemaContext, Schema schema, AttributeSet atts) {
        super(schemaContext);
        this._schema = schema;
        this._attribute = new AttributeDecl(schema);
        String attValue = atts.getValue("ref");
        if (attValue != null) {
            this._attribute.setReference(attValue);
        }
        if ((attValue = atts.getValue("name")) != null) {
            if (this._attribute.isReference()) {
                String err = "An attribute cannot have a 'name' attribute and a 'ref' attribute at the same time.";
                throw new IllegalStateException(err);
            }
            this._attribute.setName(attValue);
        }
        if ((attValue = atts.getValue("default")) != null) {
            this._attribute.setDefaultValue(attValue);
        }
        this._attribute.setId(atts.getValue("id"));
        attValue = atts.getValue("fixed");
        if (attValue != null) {
            this._attribute.setFixedValue(attValue);
        }
        if ((attValue = atts.getValue("form")) != null) {
            if (this._attribute.isReference()) {
                String err = "An attribute reference cannot have a 'form' attribute.";
                throw new IllegalArgumentException(err);
            }
            this._attribute.setForm(Form.valueOf(attValue));
        }
        if ((attValue = atts.getValue("type")) != null) {
            if (this._attribute.isReference()) {
                String err = "An attribute reference cannot have a 'type' attribute.";
                throw new IllegalArgumentException(err);
            }
            this._attribute.setSimpleTypeReference(attValue);
        }
        if ((attValue = atts.getValue("use")) != null) {
            if (this._attribute.isDefault() && !attValue.equals("optional")) {
                throw new IllegalArgumentException("When 'default' is present, the 'use' attribute must have the value 'optional'.");
            }
            this._attribute.setUse(attValue);
        }
    }

    @Override
    public String elementName() {
        return "attribute";
    }

    public AttributeDecl getAttribute() {
        return this._attribute;
    }

    @Override
    public Object getObject() {
        return this.getAttribute();
    }

    @Override
    public void startElement(String name, String namespace, AttributeSet atts, Namespaces nsDecls) throws XMLException {
        if (this.unmarshaller != null) {
            this.unmarshaller.startElement(name, namespace, atts, nsDecls);
            ++this.depth;
            return;
        }
        if ("annotation".equals(name)) {
            if (this.foundAnnotation) {
                this.error("Only one (1) annotation is allowed as a child of an attribute declaration.");
            }
            if (this.foundSimpleType) {
                this.error("An annotation may only appear as the first child of an attribute declaration.");
            }
            this.foundAnnotation = true;
            this.unmarshaller = new AnnotationUnmarshaller(this.getSchemaContext(), atts);
        } else if ("simpleType".equals(name)) {
            if (this.foundSimpleType) {
                this.error("Only one (1) simpleType is allowed as a child of an attribute declaration.");
            }
            this.foundSimpleType = true;
            this.unmarshaller = new SimpleTypeUnmarshaller(this.getSchemaContext(), this._schema, atts);
        } else {
            this.illegalElement(name);
        }
    }

    @Override
    public void endElement(String name, String namespace) throws XMLException {
        if (this.unmarshaller != null && this.depth > 0) {
            this.unmarshaller.endElement(name, namespace);
            --this.depth;
            return;
        }
        this.unmarshaller.finish();
        if ("annotation".equals(name)) {
            Annotation ann = (Annotation)this.unmarshaller.getObject();
            this._attribute.addAnnotation(ann);
        } else if ("simpleType".equals(name)) {
            SimpleType simpleType = ((SimpleTypeUnmarshaller)this.unmarshaller).getSimpleType();
            this._attribute.setSimpleType(simpleType);
        }
        this.unmarshaller = null;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws XMLException {
        if (this.unmarshaller != null) {
            this.unmarshaller.characters(ch, start, length);
        }
    }
}

