/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.logging.ts;

import alma.acs.logging.AcsLogLevel;
import alma.acs.logging.AcsLogRecord;
import alma.acs.logging.AcsLogger;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;

public abstract class TypesafeLogBase {
    protected final Logger logger;
    protected final Map<String, Object> nameValue;
    protected final AcsLogRecord lr;

    protected TypesafeLogBase(Logger logger, String logName, AcsLogLevel level, String audience, String msg, String array, String antenna) {
        this.logger = logger;
        if (logger instanceof AcsLogger) {
            ((AcsLogger)logger).addLoggerClass(TypesafeLogBase.class);
            ((AcsLogger)logger).addLoggerClass(this.getClass());
        }
        this.nameValue = new LinkedHashMap<String, Object>();
        this.nameValue.put("logName", logName);
        this.lr = new AcsLogRecord(level, msg, this.nameValue, logger.getName());
        this.lr.setAudience(audience);
        this.lr.setArray(array);
        this.lr.setAntenna(antenna);
    }

    public TypesafeLogBase setArray(String array) {
        this.lr.setArray(array);
        return this;
    }

    public TypesafeLogBase setAntenna(String antenna) {
        this.lr.setAntenna(antenna);
        return this;
    }

    public String getArray() {
        return this.lr.getArray();
    }

    public String getAntenna() {
        return this.lr.getAntenna();
    }

    public void log() {
        this.logger.log(this.lr);
    }
}

