/*
 * Decompiled with CFR 0.152.
 */
package alma.common.sourcecatalog.restful;

import alma.common.sourcecatalog.Measurement;
import alma.common.sourcecatalog.Source;
import alma.common.sourcecatalog.restful.MeasurementJson;
import alma.common.sourcecatalog.restful.SourceNameJson;
import alma.common.sourcecatalog.utilities.TextUtils;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SourceJson
implements Source {
    private Collection<MeasurementJson> measurements;
    private List<SourceNameJson> names;

    @Override
    public List<String> getNames() {
        return this.names.stream().map(n -> n.getName()).collect(Collectors.toList());
    }

    @Override
    public Collection<Measurement> getMeasurements() {
        return this.measurements.stream().map(n -> n).collect(Collectors.toList());
    }

    @Override
    public String getFormattedName() {
        return TextUtils.join(this.getNames(), "; ");
    }

    public void addMeasurement(MeasurementJson measurementJson) {
        this.measurements.add(measurementJson);
    }

    public String toString() {
        return "Source [measurements=" + String.valueOf(this.measurements) + ", names=" + String.valueOf(this.getNames()) + "]";
    }
}

