/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.logging.archive.zoom;

import alma.acs.logging.archive.zoom.FileHelper;
import alma.acs.logging.archive.zoom.ZoomException;
import alma.acs.logging.archive.zoom.ZoomProgressListener;
import alma.acs.logging.engine.io.IOPorgressListener;
import alma.acs.util.IsoDateFormat;
import com.cosylab.logging.engine.ACS.ACSRemoteErrorListener;
import com.cosylab.logging.engine.ACS.ACSRemoteLogListener;
import com.cosylab.logging.engine.log.LogTypeHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.text.ParseException;
import java.util.Date;

public class FilesManager {
    public final String filesFolder;
    private IsoDateFormat dateFormat = new IsoDateFormat();
    private volatile boolean stopLoading;
    private FileHelper fileHelper = null;

    public FilesManager(String folder) throws ZoomException {
        this.filesFolder = this.checkFolderOfFiles(folder);
    }

    private String checkFolderOfFiles(String folder) throws ZoomException {
        if (folder == null || folder.isEmpty()) {
            throw new IllegalArgumentException("Invalid folder: " + folder);
        }
        File f = new File(folder);
        if (!f.isDirectory() || !f.canRead()) {
            throw new ZoomException("Invalid folder of XML files: " + folder);
        }
        folder = f.getAbsolutePath();
        return folder;
    }

    public boolean getLogs(String startDate, String endDate, ACSRemoteLogListener logListener, LogTypeHelper minLevel, LogTypeHelper maxLevel, ZoomProgressListener zoomListener, ACSRemoteErrorListener errorListener) throws FileNotFoundException, ZoomException {
        long end;
        Date date;
        long start;
        this.stopLoading = false;
        if (startDate == null) {
            start = 0L;
        } else {
            try {
                date = this.dateFormat.parse(startDate);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Invalid start date: " + endDate, e);
            }
            start = date.getTime();
        }
        if (endDate == null) {
            end = System.currentTimeMillis();
        } else {
            try {
                date = this.dateFormat.parse(endDate);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Invalid end date: " + endDate, e);
            }
            end = date.getTime();
        }
        if (logListener == null) {
            throw new IllegalArgumentException("The listener can't be null");
        }
        if (minLevel == null) {
            minLevel = LogTypeHelper.values()[0];
        }
        if (maxLevel == null) {
            maxLevel = LogTypeHelper.values()[LogTypeHelper.values().length - 1];
        }
        if (maxLevel.ordinal() < minLevel.ordinal()) {
            throw new IllegalArgumentException("Invalid level range [" + minLevel + ", " + maxLevel + "]");
        }
        if (zoomListener != null) {
            zoomListener.zoomReadingFile(0);
        }
        boolean ret = true;
        File[] files = this.getFileList(start, end);
        if (zoomListener != null) {
            zoomListener.zoomTotalFileToRead(files.length);
        }
        int index = 0;
        for (File inFile : files) {
            if (zoomListener != null) {
                zoomListener.zoomReadingFile(++index);
            }
            this.fileHelper = new FileHelper(inFile, start, end, minLevel, maxLevel);
            if (this.stopLoading) {
                return false;
            }
            ret = ret && this.fileHelper.loadLogs(logListener, new ProgressListener(), errorListener);
        }
        return ret;
    }

    public File[] getFileList(long start, long end) {
        if (start > end) {
            throw new IllegalArgumentException("Invalid time range");
        }
        if (this.filesFolder == null || this.filesFolder.isEmpty()) {
            throw new IllegalStateException("Folder of files not initialized!");
        }
        FileNameFilter filter = new FileNameFilter(start, end);
        File f = new File(this.filesFolder);
        if (!f.isDirectory() || !f.canRead()) {
            throw new IllegalStateException(this.filesFolder + " unreadable/does not exist!");
        }
        return f.listFiles(filter);
    }

    public boolean isOperational() {
        try {
            this.checkFolderOfFiles(this.filesFolder);
        }
        catch (Exception e) {
            return false;
        }
        File f = new File(this.filesFolder);
        return this.getFileList(0L, System.currentTimeMillis()).length > 0;
    }

    public void stopLoading() {
        this.stopLoading = true;
        if (this.fileHelper != null) {
            this.fileHelper.stopLoading();
        }
    }

    private static class ProgressListener
    implements IOPorgressListener {
        private ProgressListener() {
        }

        public void bytesRead(long bytes) {
        }

        public void bytesWritten(long bytes) {
        }

        public void logsRead(int numOfLogs) {
        }

        public void logsWritten(int numOfLogs) {
        }
    }

    public class FileNameFilter
    implements FilenameFilter {
        private static final String header = "logOutput";
        private final long start;
        private final long end;

        public FileNameFilter(long start, long end) {
            if (start < 0L || end == 0L || end < start) {
                throw new IllegalArgumentException("Invalid time interval [" + start + ", " + end + "]");
            }
            this.start = start;
            this.end = end;
        }

        @Override
        public boolean accept(File dir, String name) {
            Date endFileDate;
            Date startFileDate;
            if (name.indexOf(header) == -1) {
                return false;
            }
            if (!name.toLowerCase().endsWith(".xml")) {
                return false;
            }
            String[] dates = (name = name.substring(header.length(), name.length() - 4)).split("--");
            if (dates == null || dates.length != 2) {
                return false;
            }
            dates[0] = dates[0].replaceAll("_", ":");
            dates[1] = dates[1].replaceAll("_", ":");
            try {
                startFileDate = FilesManager.this.dateFormat.parse(dates[0]);
                endFileDate = FilesManager.this.dateFormat.parse(dates[1]);
            }
            catch (Throwable t) {
                return false;
            }
            long startFile = startFileDate.getTime();
            long endFile = endFileDate.getTime();
            if (startFile > endFile) {
                return false;
            }
            return endFile > this.start && startFile <= this.end;
        }
    }
}

