/*
 * Decompiled with CFR 0.152.
 */
package skyview.process.imagefinder;

import nom.tam.fits.Header;
import skyview.executive.Settings;
import skyview.geometry.DepthSampler;
import skyview.geometry.Sampler;
import skyview.process.ImageFinder;
import skyview.process.Processor;
import skyview.survey.Image;

public class Prefetcher
implements Processor {
    @Override
    public String getName() {
        return "ImagePrefetcher";
    }

    @Override
    public String getDescription() {
        return "Ensures image finding using downloaded images";
    }

    @Override
    public void process(Image[] inputs, Image output, int[] source, Sampler samp, DepthSampler dsamp) {
        if (inputs == null || source == null) {
            return;
        }
        boolean[] need = new boolean[inputs.length];
        for (int i = 0; i < source.length; ++i) {
            if (source[i] < 0) continue;
            need[source[i]] = true;
        }
        boolean redo = false;
        for (int i = 0; i < need.length; ++i) {
            if (!need[i] || inputs[i].valid()) continue;
            System.err.println("  Fetching candidate:" + i);
            inputs[i].validate();
            redo = true;
        }
        if (redo) {
            System.err.println("  Recalculating pixel source images.");
            ImageFinder imFin = ImageFinder.factory(Settings.get("imagefinder"));
            imFin.setStrict(Settings.has("StrictGeometry"));
            int[] newMatch = imFin.findImages(inputs, output);
            System.arraycopy(newMatch, 0, source, 0, source.length);
        }
    }

    @Override
    public void updateHeader(Header header) {
    }
}

