/*
 * Decompiled with CFR 0.152.
 */
package skyview.ij;

import java.awt.Font;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import skyview.executive.Settings;
import skyview.geometry.Converter;
import skyview.geometry.CoordinateSystem;
import skyview.geometry.Projection;
import skyview.geometry.Scaler;
import skyview.geometry.Util;
import skyview.geometry.WCS;
import skyview.ij.IJProcessor;

public class Drawer {
    IJProcessor proc;
    double x0;
    double y0;
    double a00 = 1.0;
    double a01 = 0.0;
    double a10 = 0.0;
    double a11 = 1.0;
    double scale = 1.0;
    double offX = 0.0;
    double offY = 0.0;
    boolean colorSet = false;
    boolean cont = false;
    double lastx = -1.0;
    double lasty = -1.0;
    int pointSize = 12;
    Converter cnv = null;
    WCS wcs;
    double angScale;
    double currentAngle = 0.0;
    double initialAngle = 0.0;
    int recursion = 0;

    Drawer(IJProcessor ij, int nx, int ny, WCS wcs) {
        this.proc = ij;
        this.x0 = (double)nx / 2.0;
        this.y0 = (double)ny / 2.0;
        this.wcs = wcs;
        this.angScale = wcs.getScale();
        if (Settings.has("drawAngle")) {
            try {
                this.initialAngle = Double.parseDouble(Settings.get("drawAngle"));
            }
            catch (Exception e) {
                System.err.println("  Unable to parse plot angle:" + Settings.get("plotAngle"));
            }
        }
        this.reset();
    }

    void rotate(String angle) {
        try {
            double xangle = Math.toRadians(Double.parseDouble(angle));
            this.currentAngle += xangle;
            this.a00 = this.a11 = Math.cos(this.currentAngle);
            this.a01 = -Math.sin(this.currentAngle);
            this.a10 = -this.a01;
        }
        catch (Exception e) {
            System.err.println("  Draw error: rotate:" + angle);
        }
    }

    void offset(String val) {
        String[] offsets = val.split("\\s+");
        boolean OK = false;
        if (offsets.length == 2) {
            try {
                double x = Double.parseDouble(offsets[0]);
                double y = Double.parseDouble(offsets[1]);
                this.offX += x;
                this.offY += y;
                OK = true;
            }
            catch (Exception e) {}
        } else if (offsets.length == 1 && offsets[0].length() == 2) {
            char c1 = offsets[0].charAt(0);
            char c2 = offsets[0].charAt(1);
            OK = true;
            if (c1 == '+') {
                this.offX += this.x0;
            } else if (c1 == '-') {
                this.offX -= this.x0;
            }
            if (c2 == '+') {
                this.offY += this.y0;
            } else if (c2 == '-') {
                this.offY -= this.y0;
            }
        }
        if (!OK) {
            System.err.println("  Draw Error adding offset:" + val);
        }
    }

    void reset() {
        this.offX = 0.0;
        this.offY = 0.0;
        this.scale = 1.0;
        this.a00 = 1.0;
        this.a11 = 1.0;
        this.a01 = 0.0;
        this.a10 = 0.0;
        this.currentAngle = 0.0;
        this.rotate("" + this.initialAngle);
        this.cnv = null;
        if (this.colorSet) {
            this.color("white");
        }
        this.thick("1");
        this.font("12");
    }

    void drawFile(String file) {
        ++this.recursion;
        if (this.recursion < 10) {
            ArrayList<String> input = new ArrayList<String>();
            int readCount = -1;
            try {
                String line;
                BufferedReader bf = new BufferedReader(new FileReader(file));
                readCount = 0;
                while ((line = bf.readLine()) != null) {
                    input.add(line);
                    ++readCount;
                }
            }
            catch (Exception e) {
                System.err.println("  Error reading draw file:" + file + " at line " + readCount);
            }
            this.draw(input.toArray(new String[0]));
        } else {
            System.err.println("  Draw error: Reached recusion limit on:" + file);
        }
        --this.recursion;
    }

    void drawCommands() {
        String[] cmds = Settings.getArray("draw");
        this.draw(cmds);
    }

    public void draw(String[] cmds) {
        for (int i = 0; i < cmds.length; ++i) {
            String cmd = cmds[i].trim();
            if (cmd.length() == 0 || cmd.charAt(0) == '#') {
                this.cont = false;
                continue;
            }
            String[] flds = cmd.split("\\s+", 2);
            String key = flds[0].toLowerCase();
            if (key.equals("reset")) {
                this.reset();
                this.cont = false;
                continue;
            }
            if (flds.length == 1) {
                System.err.println("  Empty command in draw (" + i + ") :" + cmd);
                continue;
            }
            String val = flds[1];
            if (key.equals("scale")) {
                this.scale(val);
                this.cont = false;
                continue;
            }
            if (key.equals("project")) {
                this.project(val);
                this.cont = false;
                continue;
            }
            if (key.equals("file")) {
                this.drawFile(val);
                this.cont = false;
                continue;
            }
            if (key.equals("offset")) {
                this.offset(val);
                this.cont = false;
                continue;
            }
            if (key.equals("color")) {
                this.color(val);
                continue;
            }
            if (key.equals("rotate")) {
                this.rotate(val);
                this.cont = false;
                continue;
            }
            if (key.equals("thick")) {
                this.thick(val);
                continue;
            }
            if (key.equals("font")) {
                this.font(val);
                this.cont = false;
                continue;
            }
            if (key.equals("text")) {
                this.text(val);
                this.cont = false;
                continue;
            }
            if (key.equals("circle")) {
                this.circle(val);
                continue;
            }
            this.line(key, val);
        }
    }

    void font(String val) {
        String[] fields = val.split("\\s+");
        int pnt = this.pointSize;
        try {
            pnt = Integer.parseInt(fields[0]);
            String font = "SansSerif";
            if (fields.length > 1) {
                font = fields[1];
            }
            this.proc.getImageProcessor().setFont(new Font(font, 0, this.pointSize));
        }
        catch (Exception e) {
            System.err.println("  Draw: Unable to set font:" + val);
        }
        this.pointSize = pnt;
    }

    void project(String val) {
        try {
            String[] fields = val.split("\\s+");
            String proj = fields[0];
            String csys = null;
            if (fields.length > 1) {
                csys = fields[1];
            }
            Projection pj = null;
            double sign = 1.0;
            if (proj.equalsIgnoreCase("Coo")) {
                proj = "Car";
                sign = -1.0;
            }
            if (Projection.fixedPoint(proj) == null) {
                double[] c = new double[]{this.x0, this.y0};
                double[] p = new double[3];
                Converter cvx = this.wcs.inverse();
                cvx.transform(c, p);
                pj = new Projection(val, Util.coord(p));
            } else {
                pj = new Projection(proj);
            }
            this.cnv = new Converter();
            this.cnv.add(new Scaler(0.0, 0.0, -sign * this.angScale, 0.0, 0.0, this.angScale));
            if (pj.getDistorter() != null) {
                this.cnv.add(pj.getDistorter().inverse());
            }
            this.cnv.add(pj.getProjecter().inverse());
            if (pj.getRotater() != null) {
                this.cnv.add(pj.getRotater().inverse());
            }
            if (csys != null) {
                CoordinateSystem cs = CoordinateSystem.factory(csys);
                if (cs == null) {
                    System.err.println("  Drawer: Invalid coordinate system ignored:" + csys);
                    csys = null;
                }
                if (cs.getSphereDistorter() != null) {
                    this.cnv.add(cs.getSphereDistorter().inverse());
                }
                if (cs.getRotater() != null) {
                    this.cnv.add(cs.getRotater().inverse());
                }
            }
            if (csys != null) {
                this.cnv.add(this.wcs.getCoordinateSystem().getRotater());
                this.cnv.add(this.wcs.getCoordinateSystem().getSphereDistorter());
            }
            Projection wp = this.wcs.getProjection();
            this.cnv.add(wp.getRotater());
            this.cnv.add(wp.getProjecter());
            this.cnv.add(this.wcs.getScaler());
        }
        catch (Exception e) {
            System.err.println("  Unable to set drawing projection:" + val + "\nError is:" + e);
        }
    }

    void thick(String val) {
        try {
            this.proc.getImageProcessor().setLineWidth(Integer.parseInt(val));
        }
        catch (Exception e) {
            System.err.println("  Draw error setting thickness:" + val);
        }
    }

    void color(String input) {
        this.colorSet = true;
        this.proc.setColor(input);
    }

    void scale(String val) {
        char last = val.charAt(val.length() - 1);
        double factor = 1.0;
        if (last == '\"') {
            factor = Math.toRadians(2.777777777777778E-4);
        } else if (last == '\'') {
            factor = Math.toRadians(0.016666666666666666);
        } else if (last == 'd' || last == 'D') {
            factor = Math.toRadians(1.0);
        }
        if (factor != 1.0) {
            val = val.substring(0, val.length() - 1);
            factor /= this.angScale;
        }
        try {
            this.scale = factor * Double.parseDouble(val);
        }
        catch (Exception e) {
            System.err.println("  Draw error: Invalid scale:" + val);
        }
    }

    void circle(String val) {
        boolean OK = false;
        try {
            String[] fields = val.split("\\s+");
            if (fields.length == 3) {
                double[] pnt = this.getPoint(Double.parseDouble(fields[0]), Double.parseDouble(fields[1]));
                double r = Double.parseDouble(fields[2]);
                int diam = (int)((r *= this.scale) + 0.5);
                if (!Double.isNaN(pnt[0])) {
                    this.proc.getImageProcessor().drawOval((int)(this.x0 + pnt[0] - (double)(diam / 2) + 0.5), (int)(this.y0 - (pnt[1] + (double)(diam / 2) + 0.5)), diam, diam);
                }
                OK = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!OK) {
            System.err.println("  Draw error in circle:" + val);
        }
    }

    double[] getPoint(double xIn, double yIn) {
        double tx = (xIn + this.offX) * this.scale;
        double ty = (yIn + this.offY) * this.scale;
        double xOut = this.a00 * tx + this.a01 * ty;
        double yOut = this.a10 * tx + this.a11 * ty;
        double[] pnt = new double[]{xOut, yOut};
        if (this.cnv != null) {
            this.cnv.transform(pnt, pnt);
            pnt[0] = pnt[0] - this.x0;
            pnt[1] = pnt[1] - this.y0;
        }
        return pnt;
    }

    void line(String p1, String p2) {
        try {
            double[] pnt = this.getPoint(Double.parseDouble(p1), Double.parseDouble(p2));
            if (this.cont && !Double.isNaN(pnt[0]) && !Double.isNaN(this.lastx)) {
                this.proc.drawLine(this.lastx + this.x0, this.y0 - this.lasty, pnt[0] + this.x0, this.y0 - pnt[1]);
            }
            this.cont = true;
            this.lastx = pnt[0];
            this.lasty = pnt[1];
        }
        catch (Exception e) {
            System.err.println("  Draw error on segment:" + p1 + " " + p2);
            this.cont = false;
        }
    }

    void text(String val) {
        try {
            String[] fields = val.split("\\s+", 4);
            if (fields.length != 4) {
                return;
            }
            double[] pnt = this.getPoint(Double.parseDouble(fields[0]), Double.parseDouble(fields[1]));
            double ang = Double.parseDouble(fields[2]);
            if (!Double.isNaN(pnt[0])) {
                this.proc.plotString(fields[3], this.x0 + pnt[0], this.y0 + pnt[1], Math.toRadians(-(Math.toDegrees(this.currentAngle) + ang)));
            }
        }
        catch (Exception e) {
            System.err.println("  Draw error on text:" + val);
        }
    }
}

