/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.Menus;
import ij.gui.GenericDialog;
import ij.io.PluginClassLoader;
import ij.plugin.PlugIn;
import ij.util.StringSorter;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Vector;

public class Installer
implements PlugIn {
    private static String[] menus = new String[]{"Shortcuts", "Plugins", "Import", "Save As", "Filters", "Tools", "Utilities"};
    private static final String TITLE = "Installer";
    private static String command = "";
    private static String shortcut = "";
    private static String defaultPlugin = "";
    private static String menuStr = menus[0];

    public void run(String arg) {
        this.installPlugin();
    }

    void installPlugin() {
        String[] plugins = this.getPlugins();
        if (plugins == null || plugins.length == 0) {
            IJ.error("No plugins found");
            return;
        }
        GenericDialog gd = new GenericDialog("Install Plugin", IJ.getInstance());
        gd.addChoice("Plugin:", plugins, defaultPlugin);
        gd.addChoice("Menu:", menus, menuStr);
        gd.addStringField("Command:", command, 16);
        gd.addStringField("Shortcut:", shortcut, 3);
        gd.addStringField("Argument:", "", 12);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        String plugin = gd.getNextChoice();
        menuStr = gd.getNextChoice();
        command = gd.getNextString();
        shortcut = gd.getNextString();
        String argument = gd.getNextString();
        IJ.register(Installer.class);
        defaultPlugin = plugin;
        if (command.equals("")) {
            IJ.showMessage(TITLE, "Command required");
            return;
        }
        if (shortcut.length() > 1) {
            shortcut = shortcut.replace('f', 'F');
        }
        int menu = 32;
        if (menuStr.equals(menus[0])) {
            menu = 104;
        } else if (menuStr.equals(menus[1])) {
            menu = 112;
        } else if (menuStr.equals(menus[2])) {
            menu = 105;
        } else if (menuStr.equals(menus[3])) {
            menu = 115;
        } else if (menuStr.equals(menus[4])) {
            menu = 102;
        } else if (menuStr.equals(menus[5])) {
            menu = 116;
        } else if (menuStr.equals(menus[6])) {
            menu = 117;
        }
        if (!argument.equals("")) {
            plugin = plugin + "(\"" + argument + "\")";
        }
        int err = Menus.installPlugin(plugin, (char)menu, command, shortcut, IJ.getInstance());
        switch (err) {
            case -1: {
                IJ.showMessage(TITLE, "The command \"" + command + "\" \nis already being used.");
                return;
            }
            case -2: {
                IJ.showMessage(TITLE, "The shortcut must be a single character or \"F1\"-\"F12\".");
                return;
            }
            case -3: {
                IJ.showMessage("The \"" + shortcut + "\" shortcut is already being used.");
                return;
            }
        }
        command = "";
        shortcut = "";
        if (!plugin.endsWith(")")) {
            this.installAbout(plugin);
        }
    }

    void installAbout(String plugin) {
        boolean hasShowAboutMethod = false;
        PluginClassLoader loader = new PluginClassLoader(Menus.getPlugInsPath());
        try {
            Class c = loader.loadClass(plugin);
            Method m = c.getDeclaredMethod("showAbout", new Class[0]);
            if (m != null) {
                hasShowAboutMethod = true;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (hasShowAboutMethod) {
            Menus.installPlugin(plugin + "(\"about\")", 'a', plugin + "...", "", IJ.getInstance());
        }
    }

    String[] getPlugins() {
        String path = Menus.getPlugInsPath();
        if (path == null) {
            return null;
        }
        File f = new File(path);
        Object[] list = f.list();
        if (list == null) {
            return null;
        }
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < list.length; ++i) {
            String className = list[i];
            boolean isClassFile = className.endsWith(".class");
            if (className.indexOf(95) >= 0 && isClassFile && className.indexOf(36) < 0) {
                className = className.substring(0, className.length() - 6);
                v.addElement(className);
                continue;
            }
            if (isClassFile) continue;
            this.getSubdirectoryPlugins(path, className, v);
        }
        list = new String[v.size()];
        v.copyInto(list);
        StringSorter.sort((String[])list);
        return list;
    }

    void getSubdirectoryPlugins(String path, String dir, Vector v) {
        if (dir.endsWith(".java")) {
            return;
        }
        File f = new File(path, dir);
        if (!f.isDirectory()) {
            return;
        }
        String[] list = f.list();
        if (list == null) {
            return;
        }
        dir = dir + "/";
        for (int i = 0; i < list.length; ++i) {
            String name = list[i];
            if (name.indexOf(95) < 0 || !name.endsWith(".class") || name.indexOf(36) >= 0) continue;
            name = name.substring(0, name.length() - 6);
            v.addElement(name);
        }
    }
}

