/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.sbbuilder;

import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.experts.TechnicalJustificationExpert;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGeneratorTemplate;
import java.util.EnumSet;
import java.util.Optional;
import lombok.NonNull;

public class SBGenerationContext {
    Optional<TechnicalJustificationExpert.TechnicalJustificationCalculations> tjData = Optional.empty();
    private RequestedArray array = null;
    private SBGeneratorTemplate.SchedBlockType sbType = null;
    private ScienceGoal goal = null;
    private EnumSet<SBGeneratorTemplate.SBGenerationSchema> schemaToUseForSBGeneration = null;
    private SchedBlock sb = null;
    private Integer spectralScanTuningIndex = null;
    private Configuration configuration = null;
    private double antennaRelatedTOSTimeMultiplier = 1.0;
    private Optional<Configuration> primaryConfiguration = Optional.empty();

    public boolean isVLBI() {
        return this.schemaToUseForSBGeneration.contains((Object)SBGeneratorTemplate.SBGenerationSchema.VLBI);
    }

    public final SBGeneratorTemplate.SchedBlockType getSBType() {
        return this.sbType;
    }

    public final EnumSet<SBGeneratorTemplate.SBGenerationSchema> getSchemaToUseForSBGeneration() {
        return this.schemaToUseForSBGeneration;
    }

    public final SchedBlock getSB() {
        return this.sb;
    }

    public final ReceiverBand getReceiverBand() {
        return this.goal.getReceiverBand();
    }

    public SBGenerationContext setArray(RequestedArray requestedArray) {
        this.array = requestedArray;
        return this;
    }

    public SBGenerationContext setSBType(SBGeneratorTemplate.SchedBlockType schedBlockType) {
        this.sbType = schedBlockType;
        return this;
    }

    public SBGenerationContext setScienceGoal(ScienceGoal scienceGoal) {
        this.goal = scienceGoal;
        return this;
    }

    public SBGenerationContext setSBGenerationSchema(EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet) {
        this.schemaToUseForSBGeneration = enumSet;
        return this;
    }

    public SBGenerationContext setSB(SchedBlock schedBlock) {
        this.sb = schedBlock;
        return this;
    }

    public Configuration getMostTheoreticalExtendedConfiguration() {
        if (this.goal != null && this.goal.getPerformanceParameters().isAngularResolutionModeAny()) {
            return Configuration.getMostExtendedAnyConfiguration();
        }
        if (this.goal != null && this.goal.getPerformanceParameters().isAngularResolutionModeRange()) {
            return Configuration.getMostExtendedCompatibleConfiguration(this.array, this.getGoal());
        }
        return this.configuration;
    }

    public SBGenerationContext setConfiguration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public SBGenerationContext setPrimaryConfiguration(@NonNull Configuration configuration) {
        if (configuration == null) {
            throw new NullPointerException("configuration is marked non-null but is null");
        }
        this.primaryConfiguration = Optional.of(configuration);
        return this;
    }

    public String toString() {
        return "SBGenerationContext [array=" + String.valueOf((Object)this.array) + ", sbType=" + String.valueOf((Object)this.sbType) + ", goal=" + String.valueOf(this.goal) + ", schemaToUseForSBGeneration=" + String.valueOf(this.schemaToUseForSBGeneration) + ", sb=" + String.valueOf(this.sb) + "]";
    }

    public SBGenerationContext deepCopy() {
        SBGenerationContext sBGenerationContext = new SBGenerationContext();
        sBGenerationContext.setArray(this.getArray()).setScienceGoal(this.getGoal()).setSBType(this.getSBType()).setSB(this.getSB() != null ? this.getSB() : null).setConfiguration(this.getConfiguration()).setSBGenerationSchema(this.getSchemaToUseForSBGeneration()).setAntennaRelatedTOSTimeMultiplier(this.getAntennaRelatedTOSTimeMultiplier());
        if (this.getPrimaryConfiguration().isPresent()) {
            sBGenerationContext.setPrimaryConfiguration(this.getPrimaryConfiguration().get());
        }
        return sBGenerationContext;
    }

    public boolean isTM1SB() {
        return this.sbType.equals((Object)SBGeneratorTemplate.SchedBlockType.TWELVEMEXTENDEDCONFIGURATION);
    }

    public boolean is7mSB() {
        return this.sbType.equals((Object)SBGeneratorTemplate.SchedBlockType.ACA7M);
    }

    public boolean isTM2SB() {
        return this.sbType.equals((Object)SBGeneratorTemplate.SchedBlockType.TWELVEMCOMPACTCONFIGURATION);
    }

    public boolean isTPScienceSB() {
        return this.sbType.equals((Object)SBGeneratorTemplate.SchedBlockType.TPSCIENCE);
    }

    public boolean isTPAmpCalSB() {
        return this.sbType.equals((Object)SBGeneratorTemplate.SchedBlockType.TPAMPCAL);
    }

    public boolean isB2B() {
        return this.getSchemaToUseForSBGeneration().contains((Object)SBGeneratorTemplate.SBGenerationSchema.DGC_B2B);
    }

    public boolean isBWSW() {
        return this.getSchemaToUseForSBGeneration().contains((Object)SBGeneratorTemplate.SBGenerationSchema.DGC_BWSW);
    }

    public boolean isACACorrelatorConfigurationRequired() {
        if (this.goal == null) {
            throw new WizardSBGenerationException("science goal has not been defined");
        }
        return this.goal.getScienceGoalExpertParameterHelper().isACACorrelatorEnabled();
    }

    public boolean isSolar() {
        return this.schemaToUseForSBGeneration.contains((Object)SBGeneratorTemplate.SBGenerationSchema.SOLAR);
    }

    public void setAntennaRelatedTOSTimeMultiplier(double d) {
        this.antennaRelatedTOSTimeMultiplier = d;
    }

    public Optional<TechnicalJustificationExpert.TechnicalJustificationCalculations> getTjData() {
        return this.tjData;
    }

    public void setTjData(Optional<TechnicalJustificationExpert.TechnicalJustificationCalculations> optional) {
        this.tjData = optional;
    }

    public RequestedArray getArray() {
        return this.array;
    }

    public ScienceGoal getGoal() {
        return this.goal;
    }

    public Integer getSpectralScanTuningIndex() {
        return this.spectralScanTuningIndex;
    }

    public void setSpectralScanTuningIndex(Integer n) {
        this.spectralScanTuningIndex = n;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public double getAntennaRelatedTOSTimeMultiplier() {
        return this.antennaRelatedTOSTimeMultiplier;
    }

    public Optional<Configuration> getPrimaryConfiguration() {
        return this.primaryConfiguration;
    }
}

