/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.obsparams;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.services.generator.refactored.obsparams.CalibrationTimer;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;
import alma.valuetypes.Time;
import lombok.NonNull;

public abstract class AtmosphericTimer
extends CalibrationTimer {
    protected AtmosphericTimer(SpectralSpec spectralSpec, SBGenerationContext sBGenerationContext) {
        super(spectralSpec, sBGenerationContext);
    }

    public static Time getCycleTime(@NonNull ReceiverBand receiverBand) {
        if (receiverBand == null) {
            throw new NullPointerException("band is marked non-null but is null");
        }
        return switch (receiverBand.getNumber()) {
            case 1, 2, 3, 4, 5, 6 -> Time.createTime((double)600.0, (String)Time.UNIT_S);
            case 7 -> Time.createTime((double)480.0, (String)Time.UNIT_S);
            case 8 -> Time.createTime((double)420.0, (String)Time.UNIT_S);
            case 9, 10 -> Time.createTime((double)360.0, (String)Time.UNIT_S);
            default -> {
                Log.logger(AtmosphericTimer.class).warning("Unable to determine the cycle time for the atm cal in band " + String.valueOf(receiverBand) + " defaulting to band 3 cycle time");
                yield Time.createTime((double)600.0, (String)Time.UNIT_S);
            }
        };
    }

    @Override
    public Time getCycleTime() {
        assert (this.ss != null);
        return AtmosphericTimer.getCycleTime(this.ss.getReceiverBand());
    }

    @Override
    public Time getDefaultIntegrationTime() {
        throw new UnsupportedOperationException("Integration time is unknown");
    }

    @Override
    public Time getScanDuration() {
        throw new UnsupportedOperationException("Subscan duration is unknown");
    }
}

