/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator;

import alma.obsprep.bo.schedblock.CheckSourceCalParameters;
import alma.obsprep.bo.schedblock.DelayCalParameters;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.services.generator.AbstractCalibratorParametersFactory;
import alma.valuetypes.Time;

public class BaselineCalibrationCalibratorParametersFactory
extends AbstractCalibratorParametersFactory {
    private final Time targetIntegrationTime;

    public BaselineCalibrationCalibratorParametersFactory(SpectralSpec spectralSpec, Time time) {
        super(spectralSpec);
        this.targetIntegrationTime = time.deepCopy();
    }

    @Override
    public DelayCalParameters getDelayCalParameters(int n) {
        DelayCalParameters delayCalParameters = super.getDelayCalParameters(n);
        if (n == 2) {
            delayCalParameters.setName("Target DelayCalParameters");
            delayCalParameters.setDefaultIntegrationTime(this.targetIntegrationTime.deepCopy());
            double d = this.targetIntegrationTime.getContentInUnits(Time.UNIT_S);
            double d2 = this.integrationTime.getContentInUnits(Time.UNIT_S);
            double d3 = this.correlatorExpert.calcSubscanDuration(d, d2, null);
            delayCalParameters.setSubScanDuration(Time.createTime((double)d3, (String)Time.UNIT_S));
            delayCalParameters.setCycleTime(Time.createTime((double)99999.0, (String)Time.UNIT_H));
        }
        return delayCalParameters;
    }

    @Override
    public CheckSourceCalParameters getCheckSourceCalParameters(int n) {
        CheckSourceCalParameters checkSourceCalParameters = super.getCheckSourceCalParameters(n);
        if (n == 2) {
            checkSourceCalParameters.setName("Target CheckSourceCalParameters");
            checkSourceCalParameters.setDefaultIntegrationTime(this.targetIntegrationTime.deepCopy());
            double d = this.targetIntegrationTime.getContentInUnits(Time.UNIT_S);
            double d2 = this.integrationTime.getContentInUnits(Time.UNIT_S);
            double d3 = this.correlatorExpert.calcSubscanDuration(d, d2, null);
            checkSourceCalParameters.setSubScanDuration(Time.createTime((double)d3, (String)Time.UNIT_S));
            checkSourceCalParameters.setCycleTime(Time.createTime((double)99999.0, (String)Time.UNIT_H));
        }
        return checkSourceCalParameters;
    }
}

