/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.etc;

import alma.obsprep.bo.obsproject.CalibrationSetupParameters;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.services.calibration.CalObs;
import alma.obsprep.services.calibration.CalType;
import alma.obsprep.services.calibration.SBTimeEstimateHelper;
import alma.obsprep.services.etc.TimeEstimatesPointingCalculatorInterface;
import lombok.NonNull;

public class SpectralScanTimeEstimatesPointingCalculator
implements TimeEstimatesPointingCalculatorInterface {
    @Override
    public int getNoOfPointingCalibrations(SBTimeEstimateHelper sBTimeEstimateHelper, @NonNull ScienceGoal scienceGoal, @NonNull SBTimeEstimateHelper.GroupType groupType, int n, int n2) {
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        if (groupType == null) {
            throw new NullPointerException("observingGroup is marked non-null but is null");
        }
        boolean bl = scienceGoal.getSpectralSetupParameters().isSpectralScan();
        if (!bl) {
            throw new IllegalArgumentException("This should be a spectral scan science goal");
        }
        String string = scienceGoal.getCalibrationSetupParameters().getSelection();
        switch (groupType) {
            case CALIBRATORS: {
                if (string.equals(CalibrationSetupParameters.SELECTION_SYSTEMALTERNATE)) {
                    return 2;
                }
                if (string.equals(CalibrationSetupParameters.SELECTION_USER)) {
                    int n3 = 1;
                    block4: for (CalObs[] calObsArray : sBTimeEstimateHelper.getCalibrationsForGroup(groupType)) {
                        for (CalObs calObs : calObsArray) {
                            if (!CalType.Amplitude.equals((Object)calObs.getCalType())) continue;
                            n3 = 2;
                            break block4;
                        }
                    }
                    return n3;
                }
                return 1;
            }
            case SCIENCE: {
                return n2 == 2 ? 1 : 0;
            }
        }
        throw new RuntimeException("observingGroup not recognised " + String.valueOf((Object)groupType));
    }

    @Override
    public int getNoOfPointingCalibrationsForUserDefinedStrategy(SBTimeEstimateHelper sBTimeEstimateHelper, SBTimeEstimateHelper.GroupType groupType) {
        int n = 0;
        block0 : switch (groupType) {
            case CALIBRATORS: {
                for (CalObs[] calObsArray : sBTimeEstimateHelper.getCalibrationsForGroup(groupType)) {
                    for (CalObs calObs : calObsArray) {
                        if (!CalType.Amplitude.equals((Object)calObs.getCalType())) continue;
                        n = 1;
                        break block0;
                    }
                }
                break;
            }
            case SCIENCE: {
                n = 0;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown observing group specified " + String.valueOf((Object)groupType));
            }
        }
        return n;
    }
}

