/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.valdef.schedblock;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.obsprep.bo.obsproject.Preconditions;
import alma.obsprep.ot.valdef.AbstractValidator;
import alma.obsprep.ot.valdef.ProblemListModel;
import alma.obsprep.problems.DefaultProblem;
import alma.obsprep.problems.Problem;
import alma.valuetypes.UserAngle;

public class PreconditionsValidator
extends AbstractValidator {
    @Override
    protected void localValidate(BusinessObject businessObject, ProblemListModel problemListModel) {
        Problem problem;
        Preconditions preconditions = (Preconditions)businessObject;
        double d = preconditions.getMaxAllowedHA().getContentInUnits(UserAngle.USERUNIT_H);
        double d2 = preconditions.getMinAllowedHA().getContentInUnits(UserAngle.USERUNIT_H);
        if (d < -12.0 || d > 12.0) {
            problem = DefaultProblem.createError("Maximum HA is invalid", "Set the maximum HA allowed to a sensible value", (IBusinessObject)preconditions);
            problemListModel.add(problem);
        }
        if (d2 < -12.0 || d2 > 12.0) {
            problem = DefaultProblem.createError("Minimum HA is invalid", "Set the minimum HA allowed to a sensible value", (IBusinessObject)preconditions);
            problemListModel.add(problem);
        }
        if (d2 > d) {
            problem = DefaultProblem.createError("Minimum HA is greater than maximum HA", "Set the HA limits to consistent values", (IBusinessObject)preconditions);
            problemListModel.add(problem);
        }
    }
}

