/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.schedblock;

import alma.observatorycharacteristics.capabilities.AlmaCapabilities;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.verifiers.DoubleVerifier;
import alma.obsprep.guiutil.mvc.verifiers.IntegerVerifier;
import alma.obsprep.guiutil.mvc.verifiers.SchedBlockRepresentativeFrequencyVerifier;
import alma.obsprep.guiutil.mvc.widgets.OTTextArea;
import alma.obsprep.guiutil.mvc.widgets.OTTextField;
import alma.obsprep.ot.boEditors.ComponentCollection;
import alma.obsprep.ot.boEditors.FieldIDs;
import alma.obsprep.ot.boEditors.HAVerifier;
import alma.obsprep.ot.editors.misc.ExpertParametersEditor;
import alma.obsprep.ot.editors.obsproject.ObsUnitEditor;
import alma.obsprep.ot.editors.schedblock.SchedBlockObservingGroupEditor;
import alma.obsprep.ot.editors.schedblock.SchedBlockTemporalTabbedEditor;
import alma.obsprep.ot.editors.valuetypes.UserUnitValueUnitPairEditor;
import alma.obsprep.ot.editors.valuetypes.ValueUnitPairEditor;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.models.misc.ExpertParametersModel;
import alma.obsprep.ot.models.schedblock.SchedBlockModel;
import alma.obsprep.ot.models.schedblock.SchedBlockObservingGroupModel;
import alma.obsprep.ot.models.schedblock.SchedBlockTemporalTabbedModel;
import alma.valuetypes.UserAngle;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.help.CSH;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class SchedBlockEditor
extends ObsUnitEditor {
    private static final long serialVersionUID = -7480239386549726407L;
    private JPanel advancedParameters = null;
    private OTTextArea scriptTextArea = null;
    private SchedBlockRepresentativeFrequencyVerifier repFreqVerifier = null;

    public SchedBlockEditor(Model model) {
        this.setModel(model);
        this.build();
        model.publish();
    }

    @Override
    public SchedBlockModel getModel() {
        return (SchedBlockModel)super.getModel();
    }

    public void setAdvancedParametersVisible(boolean bl) {
        if (this.advancedParameters != null) {
            this.advancedParameters.setVisible(bl);
        }
    }

    public void setScriptEditingVisible(boolean bl) {
        if (this.scriptTextArea != null) {
            this.scriptTextArea.setScriptEditingVisible(bl);
        }
    }

    @Override
    protected void addComponents(String string) {
        JComponent jComponent = this.addBasicsGroup(string);
        CSH.setHelpIDString((Component)jComponent, (String)"TOC-Phase 2 Program Scheduling Blocks-The Scheduling Block-Basics");
        JPanel jPanel = this.addControlGroup();
        CSH.setHelpIDString((Component)jPanel, (String)"TOC-Phase 2 Program Scheduling Blocks-The Scheduling Block-Control");
        jPanel = this.addPreconditionsComponent(string);
        CSH.setHelpIDString((Component)jPanel, (String)"TOC-Phase 2 Program Scheduling Blocks-The Scheduling Block-Preconditions");
        jPanel = this.addSchedBlockComponent(string);
        CSH.setHelpIDString((Component)jPanel, (String)"TOC-Phase 2 Program Scheduling Blocks-The Scheduling Block-SchedBlock");
        jPanel = this.addAdvancedPanel();
        CSH.setHelpIDString((Component)jPanel, (String)"TOC-Phase 2 Program Scheduling Blocks-The Scheduling Block-Advanced Parameters");
        jPanel = this.addPerformanceGoalsComponent();
        CSH.setHelpIDString((Component)jPanel, (String)"TOC-Phase 2 Program Scheduling Blocks-The Scheduling Block-Performance Goals and Scheduling Constraints");
        jPanel = this.addUnitDependenciesGroup(string);
        CSH.setHelpIDString((Component)jPanel, (String)"TOC-Phase 2 Program Scheduling Blocks-The Scheduling Block-Unit Dependencies");
        jPanel = this.addTemporalConstraintsComponent(string);
        CSH.setHelpIDString((Component)jPanel, (String)"TOC-Phase 2 Program Scheduling Blocks-The Scheduling Block-Temporal Constraints");
        jPanel = this.addObservingGroupPanel();
        CSH.setHelpIDString((Component)jPanel, (String)"TOC-Phase 2 Program Scheduling Blocks-The Scheduling Block-Observing Groups");
    }

    protected JPanel addPreconditionsComponent(String string) {
        JPanel jPanel = this.createNewGroup();
        GridBagLayout gridBagLayout = this.createNewLayout(jPanel);
        GridBagConstraints gridBagConstraints = this.createNewConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        ComponentCollection componentCollection = new ComponentCollection();
        componentCollection.remember(this.makeLabel("Baseline cal"));
        componentCollection.remember(this.makeCheckBox(FieldIDs.baselineCalFID, "Is a baseline calibration required before this " + string + " is executed?"));
        componentCollection.remember(this.makeLabel("Polarization"));
        componentCollection.remember(this.makeCheckBox(FieldIDs.polarisationFID, "Is a polarization calibration required before this " + string + " is executed?"));
        this.addComponentArray(jPanel, gridBagLayout, gridBagConstraints, componentCollection);
        this.addValueUnitPair((JComponent)jPanel, gridBagLayout, gridBagConstraints, this.getModel().getMaxPWVCModel(), "MaxPWVC", "The maximum precipitable water vapour column density (mm)");
        this.addValueUnitPair((JComponent)jPanel, gridBagLayout, gridBagConstraints, this.getModel().getSeeingModel(), "Seeing", "The seeing requirements");
        this.addValueUnitPair((JComponent)jPanel, gridBagLayout, gridBagConstraints, this.getModel().getPhaseStabilityModel(), "Phase Stability", "The phase stability requirements");
        this.addValueUnitPair((JComponent)jPanel, gridBagLayout, gridBagConstraints, this.getModel().getMaxWindVelocityModel(), "Max Wind Velocity", "The maximum allowed wind velocity");
        String[] stringArray = new String[]{UserAngle.USERUNIT_H};
        UserUnitValueUnitPairEditor userUnitValueUnitPairEditor = new UserUnitValueUnitPairEditor(this.getModel().getMinAllowedHaModel());
        userUnitValueUnitPairEditor.setRestrictedUnits(stringArray);
        userUnitValueUnitPairEditor.setRestrictedUnitsToBeDisplayed(true);
        userUnitValueUnitPairEditor.setToolTipText("The minimum allowed hour angle");
        this.addLabeledComponent((JComponent)jPanel, gridBagLayout, gridBagConstraints, "Min Allowed HA", (JComponent)userUnitValueUnitPairEditor);
        HAVerifier hAVerifier = new HAVerifier(userUnitValueUnitPairEditor);
        hAVerifier.setUnitsInWhichToValidate(UserAngle.USERUNIT_H);
        userUnitValueUnitPairEditor.setVerifier("FOCUSLOST_VERIFIER", hAVerifier);
        userUnitValueUnitPairEditor = new UserUnitValueUnitPairEditor(this.getModel().getMaxAllowedHaModel());
        userUnitValueUnitPairEditor.setRestrictedUnits(stringArray);
        userUnitValueUnitPairEditor.setRestrictedUnitsToBeDisplayed(true);
        hAVerifier = new HAVerifier(userUnitValueUnitPairEditor);
        hAVerifier.setUnitsInWhichToValidate(UserAngle.USERUNIT_H);
        userUnitValueUnitPairEditor.setVerifier("FOCUSLOST_VERIFIER", hAVerifier);
        userUnitValueUnitPairEditor.setToolTipText("The maximum allowed hour angle");
        this.addLabeledComponent((JComponent)jPanel, gridBagLayout, gridBagConstraints, "Max Allowed HA", (JComponent)userUnitValueUnitPairEditor);
        return this.addGroup(jPanel, "Preconditions");
    }

    protected JPanel addSchedBlockComponent(String string) {
        JPanel jPanel = this.createNewGroup();
        GridBagLayout gridBagLayout = this.createNewLayout(jPanel);
        GridBagConstraints gridBagConstraints = this.createNewConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.addBooleanComponent(jPanel, gridBagLayout, gridBagConstraints, FieldIDs.standardModeFID, "Standard Mode", "Is this a standard observing mode?");
        this.addOTComboBox(jPanel, gridBagLayout, gridBagConstraints, FieldIDs.modeNameFID, "Mode Name", "Mode Name", this.getModel().getModeNameList());
        this.addOTComboBox(jPanel, gridBagLayout, gridBagConstraints, FieldIDs.modeTypeFID, "Mode Type", "Mode Type", this.getModel().getModeTypeList());
        ComponentCollection componentCollection = new ComponentCollection();
        componentCollection.remember(this.makeLabel("Execution Count"));
        JComponent[] jComponentArray = new JComponent[1];
        OTTextField oTTextField = this.makeTextField(FieldIDs.repeatCountFID, "The number of times this block should be run");
        jComponentArray[0] = oTTextField;
        componentCollection.remember(jComponentArray);
        this.setVerifier(oTTextField, "FOCUSLOST_VERIFIER", new IntegerVerifier(this, oTTextField, 0, Integer.MAX_VALUE));
        componentCollection.remember(this.makeLabel("Indefinite Repeat"));
        componentCollection.remember(this.makeCheckBox(FieldIDs.indefiniteRepeatFID, "Repeat this schedblock indefinitely"));
        this.addComponentArray(jPanel, gridBagLayout, gridBagConstraints, componentCollection);
        this.addValueUnitPair((JComponent)jPanel, gridBagLayout, gridBagConstraints, this.getModel().getSBMaximumTimeModel(), "SB Maximum Execution Time", "Maximum observing time per individual execution of this SB. The execution of the SB will be automatically terminated if this time is exceeded.");
        this.scriptTextArea = this.addOTTextArea(jPanel, gridBagLayout, gridBagConstraints, FieldIDs.obsProcScriptFID, 200, 75, "Obs. Procedure", "The procedure that will be executed to take data", false);
        this.addBooleanComponent(jPanel, gridBagLayout, gridBagConstraints, FieldIDs.runQuicklookFID, "Run Quick Look", "Indicates whether or not the quicklook should execute on completion of this SB.");
        return this.addGroup(jPanel, "SchedBlock");
    }

    protected JPanel addPerformanceGoalsComponent() {
        JPanel jPanel = this.createNewGroup();
        GridBagLayout gridBagLayout = this.createNewLayout(jPanel);
        GridBagConstraints gridBagConstraints = this.createNewConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        OTTextField oTTextField = this.addTextComponent(jPanel, gridBagLayout, gridBagConstraints, FieldIDs.representativeTargetFID, "Representative Target", "Representative Target of this SchedBlock");
        oTTextField.setEditable(false);
        ComponentCollection componentCollection = new ComponentCollection();
        componentCollection.remember(this.makeLabel("Representative Coordinates"));
        componentCollection.remember(this.makeSkyCoordsEditor(this.getModel().getRepresentativeCoordinatesModel(), "Representative latitude and longitude for this SB."));
        this.addComponentArray(jPanel, gridBagLayout, gridBagConstraints, componentCollection);
        ValueUnitPairEditor valueUnitPairEditor = this.addValueUnitPair((JComponent)jPanel, gridBagLayout, gridBagConstraints, this.getModel().getRepresentativeFrequencyModel(), "Representative Frequency", "A frequency that is representative of the SchedBlock's goals. It must be within the range of the Representative Receiver Band selected below");
        AlmaCapabilities almaCapabilities = AlmaCapabilities.getInstance();
        this.repFreqVerifier = new SchedBlockRepresentativeFrequencyVerifier(valueUnitPairEditor, this.getModel().getRepresentativeReceiverBand());
        valueUnitPairEditor.setVerifier("KEYSTROKE_VERIFIER", this.repFreqVerifier);
        List<String> list = almaCapabilities.getAvailableReceiverBands();
        this.addComboBox((JComponent)jPanel, gridBagLayout, gridBagConstraints, FieldIDs.representativeBandFID, "Representative Receiver Band", "Representative receiver band for this SBs execution", (String[])list.stream().toArray(String[]::new));
        this.addValueUnitPair((JComponent)jPanel, gridBagLayout, gridBagConstraints, this.getModel().getMinAcceptableAngResolutionModel(), "Min. Angular Resolution", "The minimum acceptable spatial resolution at the representative frequency");
        this.addValueUnitPair((JComponent)jPanel, gridBagLayout, gridBagConstraints, this.getModel().getMaxAcceptableAngResolutionModel(), "Max. Angular Resolution", "The maximum acceptable spatial resolution at the representative frequency");
        this.addLabeledComponent((JComponent)jPanel, gridBagLayout, gridBagConstraints, "Imaging Dynamic Range", (JComponent)this.makeTextFieldWithDoubleVerifier(FieldIDs.imagingDynamicRangeFID, "The imaging dynamic range goal for the representative frequency", 0.0, Double.MAX_VALUE));
        this.addLabeledComponent((JComponent)jPanel, gridBagLayout, gridBagConstraints, "Spectral Dynamic Range", (JComponent)this.makeTextFieldWithDoubleVerifier(FieldIDs.spectralDynamicRangeFID, "The spectral dynamic range goal for the representative frequency", 0.0, Double.MAX_VALUE));
        this.addValueUnitPair((JComponent)jPanel, gridBagLayout, gridBagConstraints, this.getModel().getBwForSpectraDynamicRangeModel(), "Spectral Dynamic Range Bandwidth", "The bandwidth which was used in the calculation of the spectral dynamic range");
        this.addLabeledComponent((JComponent)jPanel, gridBagLayout, gridBagConstraints, "Largest Angular Scale", (JComponent)this.makeTextField(FieldIDs.desiredLAS, false, "Source LAS (taken from Science Goal)"));
        this.addLabeledComponent((JComponent)jPanel, gridBagLayout, gridBagConstraints, "Operational Configuration", (JComponent)this.makeTextField(FieldIDs.nominalConfiguration, 25, false, "Configurations during which this SB could be observed. The array rarely corresponds exactly to a nominal configuration"));
        this.addLabeledComponent((JComponent)jPanel, gridBagLayout, gridBagConstraints, "Max. Allowed Beam Axial Ratio", (JComponent)this.makeTextField(FieldIDs.maxAllowedBeamAxialRatio, 25, true, "The axial ratio of the synthesized beam should not exceed this value"));
        JComponent jComponent = this.getComponent(FieldIDs.maxAllowedBeamAxialRatio);
        this.setVerifier(jComponent, "FOCUSLOST_VERIFIER", new DoubleVerifier(this, (OTTextField)jComponent));
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, this.makeCheckBox(FieldIDs.requiresTPAntennas, "Requires TP Antennas", false, "Whether TP antennas are required for high frequency 7-m operation."));
        return this.addGroup(jPanel, "Performance Goals and Scheduling Constraints");
    }

    protected JPanel addTemporalConstraintsComponent(String string) {
        JPanel jPanel = this.createNewGroup();
        this.createNewLayout(jPanel);
        SchedBlockTemporalTabbedModel schedBlockTemporalTabbedModel = this.getModel().getSchedBlockTemporalTabbedModel();
        SchedBlockTemporalTabbedEditor schedBlockTemporalTabbedEditor = new SchedBlockTemporalTabbedEditor(schedBlockTemporalTabbedModel);
        jPanel.add(schedBlockTemporalTabbedEditor);
        return this.addGroup(jPanel, "Temporal Constraints", true);
    }

    protected JPanel addAdvancedPanel() {
        JPanel jPanel = this.createNewGroup();
        this.createNewLayout(jPanel);
        ExpertParametersModel expertParametersModel = this.getModel().getExpertParametersModel();
        ExpertParametersEditor.Builder builder = new ExpertParametersEditor.Builder();
        ExpertParametersEditor expertParametersEditor = builder.model(expertParametersModel).build();
        jPanel.add(expertParametersEditor);
        this.advancedParameters = this.addGroup(jPanel, "Advanced Parameters", false);
        return this.advancedParameters;
    }

    protected JPanel addObservingGroupPanel() {
        JPanel jPanel = this.createNewGroup();
        this.createNewLayout(jPanel);
        SchedBlockObservingGroupModel schedBlockObservingGroupModel = this.getModel().getSchedBlockObservingGroupModel();
        SchedBlockObservingGroupEditor schedBlockObservingGroupEditor = new SchedBlockObservingGroupEditor(schedBlockObservingGroupModel);
        jPanel.add(schedBlockObservingGroupEditor);
        return this.addGroup(jPanel, "Observing Groups", true);
    }

    @Override
    protected void build() {
        super.build("SchedBlock");
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        SchedBlockModel schedBlockModel = this.getModel();
        if (fieldID.equals(FieldIDs.indefiniteRepeatFID)) {
            boolean bl = Boolean.parseBoolean(object.toString());
            JComponent jComponent = this.getComponent(FieldIDs.repeatCountFID);
            this.setEnabled(jComponent, !bl);
        } else if (fieldID.equals(FieldIDs.representativeBandFID)) {
            ReceiverBand receiverBand = schedBlockModel.getRepresentativeReceiverBand();
            this.repFreqVerifier.setReceiverBand(receiverBand);
            this.repFreqVerifier.verify();
        } else if (fieldID.equals(FieldIDs.representativeTargetFID) && object == null) {
            super.update(fieldID, " ( No Representative Target set ) ");
            return;
        }
        super.update(fieldID, object);
    }

    public static void main(String[] stringArray) {
        InitServices.initModelSupportClasses();
        SchedBlockModel schedBlockModel = new SchedBlockModel(null);
        SchedBlockEditor schedBlockEditor = new SchedBlockEditor(schedBlockModel);
        SchedBlock schedBlock = SchedBlock.createSchedBlock();
        schedBlockModel.setDocument(schedBlock);
        JScrollPane jScrollPane = new JScrollPane(schedBlockEditor);
        jScrollPane.setPreferredSize(new Dimension(500, 800));
        jScrollPane.setVerticalScrollBarPolicy(22);
        JFrame jFrame = new JFrame(schedBlockEditor.getClass().getSimpleName());
        jFrame.setDefaultCloseOperation(3);
        jFrame.getContentPane().add(jScrollPane);
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

